/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.zvtm.glyphs;

import fr.inria.zvtm.engine.Camera;
import fr.inria.zvtm.glyphs.VCircle;
import java.awt.Color;
import java.awt.Dimension;

public class SICircle<T>
extends VCircle {
    public SICircle() {
    }

    public SICircle(double x, double y, int z, double d, Color c) {
        super(x, y, z, d, c);
    }

    public SICircle(double x, double y, int z, double d, Color c, Color bc) {
        super(x, y, z, d, c, bc);
    }

    public SICircle(double x, double y, int z, double d, Color c, Color bc, float alpha) {
        super(x, y, z, d, c, bc, alpha);
    }

    @Override
    public boolean visibleInViewport(double wb, double nb, double eb, double sb, Camera c) {
        if (this.vx >= wb && this.vx <= eb && this.vy >= sb && this.vy <= nb) {
            return true;
        }
        double trueSize = this.size / 2.0 * (c.focal + c.altitude) / c.focal;
        return this.vx - trueSize <= eb && this.vx + trueSize >= wb && this.vy - trueSize <= nb && this.vy + trueSize >= sb;
    }

    @Override
    public void project(Camera c, Dimension d) {
        int i = c.getIndex();
        this.coef = c.focal / (c.focal + c.altitude);
        this.pc[i].cx = (int)Math.round((double)(d.width / 2) + (this.vx - c.vx) * this.coef);
        this.pc[i].cy = (int)Math.round((double)(d.height / 2) - (this.vy - c.vy) * this.coef);
        this.pc[i].cr = (int)Math.round(this.size);
    }

    @Override
    public void projectForLens(Camera c, int lensWidth, int lensHeight, float lensMag, double lensx, double lensy) {
        int i = c.getIndex();
        this.coef = c.focal / (c.focal + c.altitude) * (double)lensMag;
        this.pc[i].lcx = (int)Math.round((double)(lensWidth / 2) + (this.vx - lensx) * this.coef);
        this.pc[i].lcy = (int)Math.round((double)(lensHeight / 2) - (this.vy - lensy) * this.coef);
        this.pc[i].lcr = (int)Math.round(this.size);
    }

    @Override
    public Object clone() {
        SICircle<T> res = new SICircle<T>(this.vx, this.vy, this.vz, this.size, this.color);
        res.borderColor = this.borderColor;
        res.cursorInsideColor = this.cursorInsideColor;
        res.bColor = this.bColor;
        res.filled = this.filled;
        res.paintBorder = this.paintBorder;
        return res;
    }
}

