/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.zvtm.glyphs;

import fr.inria.zvtm.glyphs.ClosedShape;
import fr.inria.zvtm.glyphs.ColorIndicator;
import fr.inria.zvtm.glyphs.Glyph;
import fr.inria.zvtm.glyphs.GlyphPanel;
import fr.inria.zvtm.glyphs.GlyphTracker;
import fr.inria.zvtm.glyphs.VCirPanel;
import fr.inria.zvtm.glyphs.VCircle;
import fr.inria.zvtm.glyphs.VEllPanel;
import fr.inria.zvtm.glyphs.VEllipse;
import fr.inria.zvtm.glyphs.VRectPanel;
import fr.inria.zvtm.glyphs.VRectangle;
import fr.inria.zvtm.glyphs.VRectangleOr;
import fr.inria.zvtm.glyphs.VShape;
import fr.inria.zvtm.glyphs.VShapePanel;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class GlyphFactory
extends JDialog
implements ActionListener,
MouseListener,
ChangeListener {
    public static Color PANEL_BKG = (Color)UIManager.getLookAndFeelDefaults().get("Panel.background");
    public static String V_Shape = "VShape";
    public static String V_Rectangle = "VRectangle";
    public static String V_Ellipse = "VEllipse";
    public static String V_Circle = "VCircle";
    private static Vector allowedShapeTypes = GlyphFactory.initShapeTypes();
    private static String defaultShapeType = V_Shape;
    private static boolean changeableShapeType = true;
    private static Color defaultFillColor = new Color(204, 204, 255);
    private static boolean editableFillColor = true;
    private static Color defaultBorderColor = Color.black;
    private static boolean editableBorderColor = true;
    private static boolean defaultTransparencyOnOff = true;
    private static boolean editableTransparencyOnOff = true;
    private static double defaultAlphaValue = 1.0;
    private static boolean editableAlphaValue = true;
    private static boolean defaultOrientationOnOff = true;
    private static boolean editableOrientationOnOff = true;
    private static double defaultAngleValue = 0.0;
    private static boolean editableAngleValue = true;
    private static long defaultSizeValue = 10L;
    private static boolean editableSizeValue = true;
    private static int defaultVertexCount = 8;
    private static boolean editableVertexCount = true;
    private static double[] defaultVertexValues = new double[]{1.0, 0.5, 1.0, 0.5, 1.0, 0.5, 1.0, 0.5};
    private static boolean editableVertexValues = true;
    private static int GLYPH_PANEL_WIDTH = 301;
    GlyphTracker gt;
    GlyphPanel glyphPanel;
    JComboBox glList;
    ColorIndicator ci1;
    ColorIndicator ci2;
    JCheckBox transpChk;
    JCheckBox angleChk;
    JCheckBox aliasChk;
    JCheckBox gridChk;
    JCheckBox geomChk;
    JSpinner transpSpin;
    JSpinner angleSpin;
    JSpinner sizeSpin;
    JSpinner vxSpin;
    JLabel vxVal;
    JLabel vxValLb;
    JLabel vxLb;
    JButton okBt;
    JButton cancelBt;
    JButton resetBt;
    double angle = defaultAngleValue;
    long size = defaultSizeValue;
    boolean orientable = defaultOrientationOnOff;
    double aspectRatio = 1.0;
    double alpha = defaultAlphaValue;
    Color fillColor = defaultFillColor;
    Color borderColor = defaultBorderColor;
    double[] vertices = defaultVertexValues;

    private static Vector initShapeTypes() {
        Vector<String> res = new Vector<String>();
        res.add(V_Shape);
        res.add(V_Rectangle);
        res.add(V_Ellipse);
        res.add(V_Circle);
        return res;
    }

    public static boolean hasEditableAngle() {
        return editableAngleValue;
    }

    public static boolean hasEditableVertexValues() {
        return editableVertexValues;
    }

    public static Glyph getGlyphFactoryDialog(Frame owner) {
        GlyphTracker res = new GlyphTracker();
        GlyphFactory gf = new GlyphFactory(res, owner);
        gf.addWindowListener(new Closer());
        gf.addComponentListener(new DisposeOnClose());
        gf.setVisible(true);
        return res.getGlyph();
    }

    public static Glyph getGlyphFactoryDialog(Dialog owner) {
        GlyphTracker res = new GlyphTracker();
        GlyphFactory gf = new GlyphFactory(res, owner);
        gf.addWindowListener(new Closer());
        gf.addComponentListener(new DisposeOnClose());
        gf.setVisible(true);
        return res.getGlyph();
    }

    public static Glyph getGlyphFactoryDialog(Frame owner, long dsv) {
        if (dsv != -1L) {
            defaultSizeValue = dsv;
        }
        GlyphTracker res = new GlyphTracker();
        GlyphFactory gf = new GlyphFactory(res, owner);
        gf.addWindowListener(new Closer());
        gf.addComponentListener(new DisposeOnClose());
        gf.setVisible(true);
        return res.getGlyph();
    }

    public static Glyph getGlyphFactoryDialog(Dialog owner, long dsv) {
        if (dsv != -1L) {
            defaultSizeValue = dsv;
        }
        GlyphTracker res = new GlyphTracker();
        GlyphFactory gf = new GlyphFactory(res, owner);
        gf.addWindowListener(new Closer());
        gf.addComponentListener(new DisposeOnClose());
        gf.setVisible(true);
        return res.getGlyph();
    }

    public static Glyph getGlyphFactoryDialog(Frame owner, Vector ast, String dst, boolean cst, Color dfc, boolean efc, Color dbc, boolean ebc, boolean dto, boolean eto, double dav, boolean eav, boolean doo, boolean eoo, double dagv, boolean eagv, long dsv, boolean esv, int dvc, boolean evc, double[] dvv, boolean evv) {
        if (ast != null) {
            allowedShapeTypes = ast;
        }
        if (allowedShapeTypes.contains(dst)) {
            defaultShapeType = dst;
        }
        changeableShapeType = cst;
        if (dfc != null) {
            defaultFillColor = dfc;
        }
        editableFillColor = efc;
        if (dbc != null) {
            defaultBorderColor = dbc;
        }
        editableBorderColor = ebc;
        defaultTransparencyOnOff = dto;
        editableTransparencyOnOff = eto;
        if (dav != -1.0) {
            defaultAlphaValue = dav;
        }
        editableAlphaValue = eav;
        defaultOrientationOnOff = doo;
        editableOrientationOnOff = eoo;
        if (dagv != -10.0) {
            defaultAngleValue = dagv;
        }
        editableAngleValue = eagv;
        if (dsv != -1L) {
            defaultSizeValue = dsv;
        }
        editableSizeValue = esv;
        if (dvc > 0) {
            defaultVertexCount = dvc;
        }
        editableVertexCount = evc;
        if (dvv != null) {
            defaultVertexValues = dvv;
        }
        editableVertexValues = evv;
        if (defaultVertexValues.length != defaultVertexCount) {
            defaultVertexCount = defaultVertexValues.length;
        }
        return GlyphFactory.getGlyphFactoryDialog(owner);
    }

    public static Glyph getGlyphFactoryDialog(Dialog owner, Vector ast, String dst, boolean cst, Color dfc, boolean efc, Color dbc, boolean ebc, boolean dto, boolean eto, double dav, boolean eav, boolean doo, boolean eoo, double dagv, boolean eagv, long dsv, boolean esv, int dvc, boolean evc, double[] dvv, boolean evv) {
        if (ast != null) {
            allowedShapeTypes = ast;
        }
        if (allowedShapeTypes.contains(dst)) {
            defaultShapeType = dst;
        }
        changeableShapeType = cst;
        if (dfc != null) {
            defaultFillColor = dfc;
        }
        editableFillColor = efc;
        if (dbc != null) {
            defaultBorderColor = dbc;
        }
        editableBorderColor = ebc;
        defaultTransparencyOnOff = dto;
        editableTransparencyOnOff = eto;
        if (dav != -1.0) {
            defaultAlphaValue = dav;
        }
        editableAlphaValue = eav;
        defaultOrientationOnOff = doo;
        editableOrientationOnOff = eoo;
        if (dagv != -10.0) {
            defaultAngleValue = dagv;
        }
        editableAngleValue = eagv;
        if (dsv != -1L) {
            defaultSizeValue = dsv;
        }
        editableSizeValue = esv;
        if (dvc > 0) {
            defaultVertexCount = dvc;
        }
        editableVertexCount = evc;
        if (dvv != null) {
            defaultVertexValues = dvv;
        }
        editableVertexValues = evv;
        if (defaultVertexValues.length != defaultVertexCount) {
            defaultVertexCount = defaultVertexValues.length;
        }
        return GlyphFactory.getGlyphFactoryDialog(owner);
    }

    static float[] doubleToFloatArray(double[] ar) {
        float[] res = new float[ar.length];
        for (int i = 0; i < ar.length; ++i) {
            res[i] = (float)ar[i];
        }
        return res;
    }

    GlyphFactory(GlyphTracker glt, Frame owner) {
        super(owner, "ZVTM Glyph Factory", true);
        this.gt = glt;
        this.initUI(defaultShapeType, true, false, true);
    }

    GlyphFactory(GlyphTracker glt, Dialog owner) {
        super(owner, "ZVTM Glyph Factory", true);
        this.gt = glt;
        this.initUI(defaultShapeType, true, false, true);
    }

    void initUI(String si, boolean grid, boolean alias, boolean geom) {
        Container cp = this.getContentPane();
        try {
            this.glList.removeActionListener(this);
            this.ci1.removeMouseListener(this);
            this.ci2.removeMouseListener(this);
            this.transpChk.removeActionListener(this);
            this.transpSpin.removeChangeListener(this);
            this.angleChk.removeActionListener(this);
            this.angleSpin.removeChangeListener(this);
            this.sizeSpin.removeChangeListener(this);
            this.vxSpin.removeChangeListener(this);
            this.gridChk.removeActionListener(this);
            this.aliasChk.removeActionListener(this);
            this.geomChk.removeActionListener(this);
            this.glyphPanel.removeMouseListener((MouseListener)((Object)this.glyphPanel));
            this.glyphPanel.removeMouseMotionListener((MouseMotionListener)((Object)this.glyphPanel));
            this.okBt.removeActionListener(this);
            this.cancelBt.removeActionListener(this);
            this.resetBt.removeActionListener(this);
        }
        catch (NullPointerException ex) {
            // empty catch block
        }
        cp.removeAll();
        JPanel mainPanel = new JPanel();
        mainPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), "Parameters"));
        mainPanel.setLayout(new GridLayout(1, 2));
        this.glyphPanel = this.setGlyphPanel(si);
        this.glyphPanel.setPreferredSize(new Dimension(GLYPH_PANEL_WIDTH, GLYPH_PANEL_WIDTH));
        this.glyphPanel.setMinimumSize(new Dimension(GLYPH_PANEL_WIDTH, GLYPH_PANEL_WIDTH));
        this.glyphPanel.setMaximumSize(new Dimension(GLYPH_PANEL_WIDTH, GLYPH_PANEL_WIDTH));
        mainPanel.add(this.glyphPanel);
        this.glyphPanel.addMouseListener((MouseListener)((Object)this.glyphPanel));
        this.glyphPanel.addMouseMotionListener((MouseMotionListener)((Object)this.glyphPanel));
        JPanel paramPanel = new JPanel();
        GridBagLayout gridBag1 = new GridBagLayout();
        GridBagConstraints constraints1 = new GridBagConstraints();
        paramPanel.setLayout(gridBag1);
        constraints1.fill = 2;
        constraints1.anchor = 10;
        Vector glyphTypes = (Vector)allowedShapeTypes.clone();
        this.glList = new JComboBox(glyphTypes);
        this.glList.setMaximumRowCount(5);
        GlyphFactory.buildConstraints(constraints1, 0, 0, 2, 1, 100, 14);
        gridBag1.setConstraints(this.glList, constraints1);
        paramPanel.add(this.glList);
        this.glList.setSelectedItem(si);
        this.glList.addActionListener(this);
        this.glList.setEnabled(changeableShapeType);
        this.ci1 = new ColorIndicator("Fill Color", this.fillColor);
        GlyphFactory.buildConstraints(constraints1, 0, 1, 1, 1, 50, 14);
        gridBag1.setConstraints(this.ci1, constraints1);
        paramPanel.add(this.ci1);
        this.ci2 = new ColorIndicator("Border Color", this.borderColor);
        GlyphFactory.buildConstraints(constraints1, 1, 1, 1, 1, 50, 14);
        gridBag1.setConstraints(this.ci2, constraints1);
        paramPanel.add(this.ci2);
        this.ci1.addMouseListener(this);
        this.ci2.addMouseListener(this);
        this.transpChk = new JCheckBox("Translucent", defaultTransparencyOnOff);
        GlyphFactory.buildConstraints(constraints1, 0, 2, 1, 1, 50, 14);
        gridBag1.setConstraints(this.transpChk, constraints1);
        paramPanel.add(this.transpChk);
        this.transpChk.addActionListener(this);
        this.transpChk.setEnabled(editableTransparencyOnOff);
        this.transpSpin = new JSpinner(new SpinnerNumberModel(defaultAlphaValue, 0.0, 1.0, 0.05));
        GlyphFactory.buildConstraints(constraints1, 1, 2, 1, 1, 50, 14);
        gridBag1.setConstraints(this.transpSpin, constraints1);
        paramPanel.add(this.transpSpin);
        this.transpSpin.setEnabled(this.transpChk.isSelected() ? editableAlphaValue : false);
        this.transpSpin.addChangeListener(this);
        this.angleChk = new JCheckBox("Orientation", defaultOrientationOnOff);
        GlyphFactory.buildConstraints(constraints1, 0, 3, 1, 1, 50, 14);
        gridBag1.setConstraints(this.angleChk, constraints1);
        paramPanel.add(this.angleChk);
        this.angleChk.addActionListener(this);
        this.angleChk.setEnabled(editableOrientationOnOff);
        this.angleSpin = new JSpinner(new SpinnerNumberModel(defaultAngleValue, 0.0, Math.PI * 2, 0.02));
        GlyphFactory.buildConstraints(constraints1, 1, 3, 1, 1, 50, 14);
        gridBag1.setConstraints(this.angleSpin, constraints1);
        paramPanel.add(this.angleSpin);
        this.angleSpin.setEnabled(this.angleChk.isSelected() ? editableAngleValue : false);
        this.angleSpin.addChangeListener(this);
        JLabel szLb = new JLabel("Size");
        GlyphFactory.buildConstraints(constraints1, 0, 4, 1, 1, 50, 14);
        gridBag1.setConstraints(szLb, constraints1);
        paramPanel.add(szLb);
        this.sizeSpin = new JSpinner(new SpinnerNumberModel((int)defaultSizeValue, 0, Integer.MAX_VALUE, 10));
        GlyphFactory.buildConstraints(constraints1, 1, 4, 1, 1, 50, 14);
        gridBag1.setConstraints(this.sizeSpin, constraints1);
        paramPanel.add(this.sizeSpin);
        this.sizeSpin.setEnabled(editableSizeValue);
        this.sizeSpin.addChangeListener(this);
        this.vxLb = new JLabel("Vertex count");
        GlyphFactory.buildConstraints(constraints1, 0, 5, 1, 1, 50, 14);
        gridBag1.setConstraints(this.vxLb, constraints1);
        paramPanel.add(this.vxLb);
        this.vxSpin = new JSpinner(new SpinnerNumberModel(defaultVertexCount, 3, Integer.MAX_VALUE, 1));
        GlyphFactory.buildConstraints(constraints1, 1, 5, 1, 1, 50, 14);
        gridBag1.setConstraints(this.vxSpin, constraints1);
        paramPanel.add(this.vxSpin);
        this.vxSpin.setEnabled(editableVertexCount);
        this.vxSpin.addChangeListener(this);
        this.vxValLb = new JLabel("Selected vertex value");
        GlyphFactory.buildConstraints(constraints1, 0, 6, 1, 1, 50, 14);
        gridBag1.setConstraints(this.vxValLb, constraints1);
        paramPanel.add(this.vxValLb);
        this.vxVal = new JLabel(" ");
        GlyphFactory.buildConstraints(constraints1, 1, 6, 1, 1, 50, 14);
        gridBag1.setConstraints(this.vxVal, constraints1);
        paramPanel.add(this.vxVal);
        this.gridChk = new JCheckBox("Grid", grid);
        GlyphFactory.buildConstraints(constraints1, 0, 7, 1, 1, 50, 14);
        gridBag1.setConstraints(this.gridChk, constraints1);
        paramPanel.add(this.gridChk);
        this.gridChk.addActionListener(this);
        this.aliasChk = new JCheckBox("Antialiasing", alias);
        GlyphFactory.buildConstraints(constraints1, 1, 7, 1, 1, 50, 14);
        gridBag1.setConstraints(this.aliasChk, constraints1);
        paramPanel.add(this.aliasChk);
        this.aliasChk.addActionListener(this);
        this.geomChk = new JCheckBox("Indicators", geom);
        GlyphFactory.buildConstraints(constraints1, 0, 8, 2, 1, 100, 14);
        gridBag1.setConstraints(this.geomChk, constraints1);
        paramPanel.add(this.geomChk);
        this.geomChk.setSelected(true);
        this.geomChk.addActionListener(this);
        paramPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        mainPanel.add(paramPanel);
        JPanel btPanel = new JPanel();
        btPanel.setLayout(new FlowLayout());
        this.okBt = new JButton("OK");
        this.okBt.addActionListener(this);
        btPanel.add(this.okBt);
        this.cancelBt = new JButton("Cancel");
        this.cancelBt.addActionListener(this);
        btPanel.add(this.cancelBt);
        this.resetBt = new JButton("Reset");
        this.resetBt.addActionListener(this);
        btPanel.add(this.resetBt);
        GridBagLayout gridBag = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        cp.setLayout(gridBag);
        constraints.fill = 1;
        constraints.anchor = 10;
        GlyphFactory.buildConstraints(constraints, 0, 0, 1, 1, 100, 99);
        gridBag.setConstraints(mainPanel, constraints);
        cp.add(mainPanel);
        GlyphFactory.buildConstraints(constraints, 0, 1, 1, 1, 100, 1);
        gridBag.setConstraints(btPanel, constraints);
        cp.add(btPanel);
        this.pack();
        this.setResizable(false);
        if (si.equals(V_Shape)) {
            this.vxSpin.setEnabled(true);
            this.vxLb.setEnabled(true);
            this.vxVal.setEnabled(true);
            this.vxValLb.setEnabled(true);
        } else {
            this.vxSpin.setEnabled(false);
            this.vxLb.setEnabled(false);
            this.vxVal.setEnabled(false);
            this.vxValLb.setEnabled(false);
            if (si.equals(V_Ellipse) || si.equals(V_Circle)) {
                this.angleSpin.setValue(new Double(0.0));
                this.orientable = false;
                this.angleSpin.setEnabled(false);
                this.angleChk.setSelected(false);
                this.angleChk.setEnabled(false);
                if (this.glyphPanel.selectedVertex == -2) {
                    this.glyphPanel.selectedVertex = -1;
                }
            }
        }
        if (this.aliasChk.isSelected()) {
            this.glyphPanel.setAntialiasing(true);
        } else {
            this.glyphPanel.setAntialiasing(false);
        }
        if (this.gridChk.isSelected()) {
            this.glyphPanel.setGrid(true);
        } else {
            this.glyphPanel.setGrid(false);
        }
        if (this.geomChk.isSelected()) {
            this.glyphPanel.setGeom(true);
        } else {
            this.glyphPanel.setGeom(false);
        }
    }

    GlyphPanel setGlyphPanel(String glClass) {
        if (glClass.equals(V_Shape)) {
            return new VShapePanel(this);
        }
        if (glClass.equals(V_Rectangle)) {
            return new VRectPanel(this);
        }
        if (glClass.equals(V_Circle)) {
            return new VCirPanel(this);
        }
        if (glClass.equals(V_Ellipse)) {
            return new VEllPanel(this);
        }
        return new VShapePanel(this);
    }

    void changeFillColor(Color c) {
        this.fillColor = c;
        this.ci1.setColor(this.fillColor);
        this.glyphPanel.setColor(this.fillColor, this.borderColor);
    }

    void changeBorderColor(Color c) {
        this.borderColor = c;
        this.ci2.setColor(this.borderColor);
        this.glyphPanel.setColor(this.fillColor, this.borderColor);
    }

    void changeOrient(double d) {
        this.angle = d;
        this.glyphPanel.setAngle(this.angle);
    }

    void changeSize(int s) {
        this.size = s;
    }

    void updateAngleSpin(double d) {
        this.angle = d;
        this.angleSpin.setValue(new Double(d));
    }

    void changeTransp(double d) {
        this.alpha = d;
        this.glyphPanel.setTransparency(this.alpha);
    }

    void changeVertices(int i) {
        if (i > this.vertices.length) {
            double[] tmpA = new double[this.vertices.length + 1];
            System.arraycopy(this.vertices, 0, tmpA, 0, this.vertices.length);
            tmpA[tmpA.length - 1] = 1.0;
            this.vertices = tmpA;
            this.glyphPanel.setVertices(this.vertices);
        } else if (i < this.vertices.length) {
            double[] tmpA = new double[this.vertices.length - 1];
            System.arraycopy(this.vertices, 0, tmpA, 0, this.vertices.length - 1);
            this.vertices = tmpA;
            this.glyphPanel.setVertices(this.vertices);
        }
    }

    void setVertexVal(double d) {
        if (d >= 0.0) {
            String s = Double.toString(d);
            this.vxVal.setText(s.length() > 6 ? s.substring(0, 6) : s);
        } else {
            this.vxVal.setText("");
        }
    }

    Glyph instantiateGlyph(String si) {
        ClosedShape g = null;
        if (si.equals(V_Shape)) {
            g = this.transpChk.isSelected() ? new VShape(0.0, 0.0, 0, this.size, GlyphFactory.doubleToFloatArray(this.vertices), this.fillColor, this.borderColor, (float)this.angle, (float)this.alpha) : new VShape(0.0, 0.0, 0, this.size, GlyphFactory.doubleToFloatArray(this.vertices), this.fillColor, this.borderColor, (float)this.angle);
        } else if (si.equals(V_Rectangle)) {
            long h;
            long w;
            if (this.aspectRatio >= 1.0) {
                w = this.size;
                h = Math.round((double)this.size / this.aspectRatio);
            } else {
                h = this.size;
                w = Math.round((double)this.size * this.aspectRatio);
            }
            g = this.angleChk.isSelected() ? (this.transpChk.isSelected() ? new VRectangleOr(0.0, 0.0, 0, w, h, this.fillColor, this.borderColor, (float)this.angle, (float)this.alpha) : new VRectangleOr(0.0, 0.0, 0, (double)w, (double)h, this.fillColor, this.borderColor, (double)((float)this.angle))) : (this.transpChk.isSelected() ? new VRectangle(0.0, 0.0, 0, w, h, this.fillColor, this.borderColor, (float)this.alpha) : new VRectangle(0.0, 0.0, 0, w, h, this.fillColor, this.borderColor));
        } else if (si.equals(V_Ellipse)) {
            long h;
            long w;
            if (this.aspectRatio >= 1.0) {
                w = this.size;
                h = Math.round((double)this.size / this.aspectRatio);
            } else {
                h = this.size;
                w = Math.round((double)this.size * this.aspectRatio);
            }
            g = this.transpChk.isSelected() ? new VEllipse(0.0, 0.0, 0, w, h, this.fillColor, this.borderColor, (float)this.alpha) : new VEllipse(0.0, 0.0, 0, w, h, this.fillColor, this.borderColor);
        } else if (si.equals(V_Circle)) {
            g = new VCircle(0.0, 0.0, 0, this.size, this.fillColor, this.borderColor, (float)this.alpha);
        }
        return g;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.transpChk) {
            if (this.transpChk.isSelected()) {
                this.transpSpin.setEnabled(editableAlphaValue);
            } else {
                this.transpSpin.setValue(new Double(1.0));
                this.transpSpin.setEnabled(false);
            }
        } else if (source == this.angleChk) {
            if (this.angleChk.isSelected()) {
                this.orientable = true;
                this.angleSpin.setEnabled(editableAngleValue);
                if (this.glyphPanel.selectedVertex == -2) {
                    this.glyphPanel.selectedVertex = -1;
                }
                this.glyphPanel.repaint();
            } else {
                this.angleSpin.setValue(new Double(0.0));
                this.orientable = false;
                this.angleSpin.setEnabled(false);
                if (this.glyphPanel.selectedVertex == -2) {
                    this.glyphPanel.selectedVertex = -1;
                }
                this.glyphPanel.repaint();
            }
        } else if (source == this.aliasChk) {
            if (this.aliasChk.isSelected()) {
                this.glyphPanel.setAntialiasing(true);
            } else {
                this.glyphPanel.setAntialiasing(false);
            }
        } else if (source == this.gridChk) {
            if (this.gridChk.isSelected()) {
                this.glyphPanel.setGrid(true);
            } else {
                this.glyphPanel.setGrid(false);
            }
        } else if (source == this.geomChk) {
            if (this.geomChk.isSelected()) {
                this.glyphPanel.setGeom(true);
            } else {
                this.glyphPanel.setGeom(false);
            }
        } else if (source == this.okBt) {
            Glyph g = this.instantiateGlyph((String)this.glList.getSelectedItem());
            this.gt.setGlyph(g);
            this.dispose();
        } else if (source == this.cancelBt) {
            this.gt.setGlyph(null);
            this.dispose();
        } else if (source == this.resetBt) {
            this.angle = defaultAngleValue;
            this.angleSpin.setValue(new Double(this.angle));
            this.size = defaultSizeValue;
            this.sizeSpin.setValue(new Integer((int)this.size));
            this.alpha = defaultAlphaValue;
            this.transpSpin.setValue(new Double(this.alpha));
            this.fillColor = defaultFillColor;
            this.ci1.setColor(this.fillColor);
            this.borderColor = defaultBorderColor;
            this.ci2.setColor(this.borderColor);
            this.vertices = defaultVertexValues;
            this.vxSpin.setValue(new Integer(this.vertices.length));
            this.glyphPanel.setColor(this.fillColor, this.borderColor);
            this.glyphPanel.setAngle(this.angle);
            this.glyphPanel.setTransparency(this.alpha);
            this.glyphPanel.setVertices(this.vertices);
        } else if (source == this.glList) {
            this.initUI((String)this.glList.getSelectedItem(), this.gridChk.isSelected(), this.aliasChk.isSelected(), this.geomChk.isSelected());
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        Object source = e.getSource();
        if (source == this.transpSpin) {
            this.changeTransp((Double)this.transpSpin.getValue());
        } else if (source == this.vxSpin) {
            this.changeVertices((Integer)this.vxSpin.getValue());
        } else if (source == this.angleSpin) {
            this.changeOrient((Double)this.angleSpin.getValue());
        } else if (source == this.sizeSpin) {
            this.changeSize((Integer)this.sizeSpin.getValue());
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        Object source = e.getSource();
        if (source == this.ci1 && editableFillColor) {
            this.changeFillColor(JColorChooser.showDialog(this, "Choose a New Fill Color", this.fillColor));
        } else if (source == this.ci2 && editableBorderColor) {
            this.changeBorderColor(JColorChooser.showDialog(this, "Choose a New Border Color", this.borderColor));
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    static void buildConstraints(GridBagConstraints gbc, int gx, int gy, int gw, int gh, int wx, int wy) {
        gbc.gridx = gx;
        gbc.gridy = gy;
        gbc.gridwidth = gw;
        gbc.gridheight = gh;
        gbc.weightx = wx;
        gbc.weighty = wy;
    }

    static class DisposeOnClose
    extends ComponentAdapter {
        DisposeOnClose() {
        }

        @Override
        public void componentHidden(ComponentEvent e) {
            Window w = (Window)e.getComponent();
            w.dispose();
        }
    }

    static class Closer
    extends WindowAdapter {
        Closer() {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            Window w = e.getWindow();
            w.setVisible(false);
        }
    }
}

