/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.check.ui.editor.outline;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.internal.xtend.xtend.ast.Check;
import org.eclipse.internal.xtend.xtend.ast.ExtensionFile;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.xtend.shared.ui.core.IXtendXpandResource;
import org.eclipse.xtend.shared.ui.editor.AbstractXtendXpandEditor;
import org.eclipse.xtend.shared.ui.editor.outlineview.AbstractExtXptContentOutlinePage;
import org.eclipse.xtend.shared.ui.editor.outlineview.OutlineElement;
import org.eclipse.xtend.shared.ui.expression.editor.EditorImages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckContentOutlinePage
extends AbstractExtXptContentOutlinePage {
    public static final int WARNING = 3;
    public static final int ERROR = 4;

    public CheckContentOutlinePage(AbstractXtendXpandEditor editor) {
        super((TextEditor)editor);
    }

    protected OutlineElement[] getChildren(Object parentElement) {
        if (parentElement instanceof IXtendXpandResource) {
            ExtensionFile check = (ExtensionFile)((IXtendXpandResource)parentElement).getExtXptResource();
            if (check == null) {
                return new OutlineElement[0];
            }
            ArrayList<OutlineElement> result = new ArrayList<OutlineElement>();
            result.addAll(this.toOutlineElementsForNamespaceImports(check.getNsImports()));
            result.addAll(this.toOutlineElementsForExtensionImports(check.getExtImports()));
            result.addAll(this.toOutlineElements(check.getChecks()));
            return result.toArray(new OutlineElement[result.size()]);
        }
        return new OutlineElement[0];
    }

    private List<OutlineElement> toOutlineElements(List<Check> checks) {
        ArrayList<OutlineElement> l = new ArrayList<OutlineElement>();
        for (Check check : checks) {
            Image img = EditorImages.getImage((String)"check_error.gif");
            int type = 4;
            if (!check.isErrorCheck()) {
                img = EditorImages.getImage((String)"check_warning.gif");
                type = 3;
            }
            l.add(new OutlineElement(check.toString(), check.getStart(), check.getEnd() - check.getStart(), img, type));
        }
        return l;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.registerToolbarActions(this.getSite().getActionBars());
    }

    private void registerToolbarActions(IActionBars actionBars) {
        actionBars.getToolBarManager().add((IAction)new AbstractExtXptContentOutlinePage.LexicalSortingAction((AbstractExtXptContentOutlinePage)this));
    }
}

