/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.java.resource;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.Compiler;
import org.eclipse.jdt.internal.compiler.DefaultErrorHandlingPolicies;
import org.eclipse.jdt.internal.compiler.ICompilerRequestor;
import org.eclipse.jdt.internal.compiler.IErrorHandlingPolicy;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ImportReference;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeParameter;
import org.eclipse.jdt.internal.compiler.batch.CompilationUnit;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileConstants;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.parser.Parser;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.TypesFactory;
import org.eclipse.xtext.common.types.access.binary.BinaryClass;
import org.eclipse.xtext.common.types.access.binary.asm.ClassFileBytesAccess;
import org.eclipse.xtext.common.types.access.binary.asm.JvmDeclaredTypeBuilder;
import org.eclipse.xtext.common.types.descriptions.EObjectDescriptionBasedStubGenerator;
import org.eclipse.xtext.java.resource.InMemoryClassLoader;
import org.eclipse.xtext.java.resource.IndexAwareNameEnvironment;
import org.eclipse.xtext.java.resource.JavaConfig;
import org.eclipse.xtext.java.resource.JavaResource;
import org.eclipse.xtext.parser.antlr.IReferableElementsUnloader;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.IResourceDescriptionsProvider;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.util.JavaVersion;
import org.eclipse.xtext.util.internal.Log;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Procedures;

@Log
public class JavaDerivedStateComputer {
    @Inject
    private IReferableElementsUnloader unloader;
    @Inject
    private EObjectDescriptionBasedStubGenerator stubGenerator;
    @Inject
    private IResourceDescriptionsProvider resourceDescriptionsProvider;
    private static final Logger LOG = Logger.getLogger(JavaDerivedStateComputer.class);

    public void discardDerivedState(Resource resource) {
        EList resourcesContentsList = resource.getContents();
        for (EObject eObject : resourcesContentsList) {
            this.unloader.unloadRoot(eObject);
        }
        resource.getContents().clear();
    }

    public void installStubs(Resource resource) {
        boolean _isInfoFile = this.isInfoFile(resource);
        if (_isInfoFile) {
            return;
        }
        CompilationUnit compilationUnit = this.getCompilationUnit(resource);
        IErrorHandlingPolicy _proceedWithAllProblems = DefaultErrorHandlingPolicies.proceedWithAllProblems();
        CompilerOptions _compilerOptions = this.getCompilerOptions(resource);
        DefaultProblemFactory _defaultProblemFactory = new DefaultProblemFactory();
        ProblemReporter _problemReporter = new ProblemReporter(_proceedWithAllProblems, _compilerOptions, (IProblemFactory)_defaultProblemFactory);
        Parser parser = new Parser(_problemReporter, true);
        CompilationResult compilationResult = new CompilationResult((ICompilationUnit)compilationUnit, 0, 1, -1);
        CompilationUnitDeclaration result = parser.dietParse((ICompilationUnit)compilationUnit, compilationResult);
        if (result.types != null) {
            for (TypeDeclaration type : result.types) {
                ImportReference _currentPackage = result.currentPackage;
                char[][] _importName = null;
                if (_currentPackage != null) {
                    _importName = _currentPackage.getImportName();
                }
                List _map = null;
                if ((List)Conversions.doWrapArray((Object)_importName) != null) {
                    Functions.Function1 _function = it -> String.valueOf(it);
                    _map = ListExtensions.map((List)((List)Conversions.doWrapArray((Object)_importName)), (Functions.Function1)_function);
                }
                String _join = null;
                if (_map != null) {
                    _join = IterableExtensions.join(_map, (CharSequence)".");
                }
                String packageName = _join;
                JvmDeclaredType jvmType = this.createType(type, packageName);
                resource.getContents().add((Object)jvmType);
            }
        }
    }

    public JvmDeclaredType createType(TypeDeclaration type, String packageName) {
        JvmGenericType _switchResult = null;
        int _kind = TypeDeclaration.kind((int)type.modifiers);
        switch (_kind) {
            case 1: {
                _switchResult = TypesFactory.eINSTANCE.createJvmGenericType();
                break;
            }
            case 2: {
                JvmGenericType _createJvmGenericType = TypesFactory.eINSTANCE.createJvmGenericType();
                Procedures.Procedure1 _function = it -> it.setInterface(true);
                _switchResult = (JvmDeclaredType)ObjectExtensions.operator_doubleArrow((Object)_createJvmGenericType, (Procedures.Procedure1)_function);
                break;
            }
            case 3: {
                _switchResult = TypesFactory.eINSTANCE.createJvmEnumerationType();
                break;
            }
            case 4: {
                _switchResult = TypesFactory.eINSTANCE.createJvmAnnotationType();
                break;
            }
            default: {
                String _string = type.toString();
                String _plus = "Cannot handle type " + _string;
                throw new IllegalArgumentException(_plus);
            }
        }
        JvmGenericType jvmType = _switchResult;
        jvmType.setPackageName(packageName);
        jvmType.setSimpleName(String.valueOf(type.name));
        if (jvmType instanceof JvmGenericType && type.typeParameters != null) {
            for (TypeParameter typeParameter : type.typeParameters) {
                JvmTypeParameter jvmTypeParam = TypesFactory.eINSTANCE.createJvmTypeParameter();
                jvmTypeParam.setName(String.valueOf(typeParameter.name));
                EList _typeParameters = jvmType.getTypeParameters();
                _typeParameters.add((Object)jvmTypeParam);
            }
        }
        if (type.memberTypes != null) {
            for (TypeParameter typeParameter : type.memberTypes) {
                JvmDeclaredType nested = this.createType((TypeDeclaration)typeParameter, null);
                EList _members = jvmType.getMembers();
                _members.add((Object)nested);
            }
        }
        return jvmType;
    }

    public CompilationUnit getCompilationUnit(Resource resource) {
        return ((JavaResource)resource).getCompilationUnit();
    }

    public void installFull(Resource resource) {
        boolean _isInfoFile = this.isInfoFile(resource);
        if (_isInfoFile) {
            return;
        }
        CompilationUnit compilationUnit = this.getCompilationUnit(resource);
        ClassLoader classLoader = this.getClassLoader(resource);
        IResourceDescriptions data = this.resourceDescriptionsProvider.getResourceDescriptions(resource.getResourceSet());
        if (data == null) {
            throw new IllegalStateException("no index installed");
        }
        IndexAwareNameEnvironment nameEnv = new IndexAwareNameEnvironment(resource, classLoader, data, this.stubGenerator);
        IErrorHandlingPolicy _proceedWithAllProblems = DefaultErrorHandlingPolicies.proceedWithAllProblems();
        CompilerOptions _compilerOptions = this.getCompilerOptions(resource);
        ICompilerRequestor _function = it -> {
            boolean _equals = Arrays.equals(it.fileName, compilationUnit.fileName);
            if (_equals) {
                ClassFile[] _classFiles;
                HashMap map = CollectionLiterals.newHashMap((Pair[])new Pair[0]);
                ArrayList topLevelTypes = CollectionLiterals.newArrayList((Object[])new String[0]);
                for (ClassFile cf : _classFiles = it.getClassFiles()) {
                    Functions.Function1 _function_1 = it_1 -> String.valueOf(it_1);
                    String className = IterableExtensions.join((Iterable)ListExtensions.map((List)((List)Conversions.doWrapArray((Object)cf.getCompoundName())), (Functions.Function1)_function_1), (CharSequence)".");
                    map.put(className, cf.getBytes());
                    if (cf.isNestedType) continue;
                    topLevelTypes.add(className);
                }
                InMemoryClassLoader inMemClassLoader = new InMemoryClassLoader(map, classLoader);
                for (String topLevel : topLevelTypes) {
                    try {
                        BinaryClass _binaryClass = new BinaryClass(topLevel, (ClassLoader)inMemClassLoader);
                        ClassFileBytesAccess _classFileBytesAccess = new ClassFileBytesAccess();
                        JvmDeclaredTypeBuilder builder = new JvmDeclaredTypeBuilder(_binaryClass, _classFileBytesAccess, (ClassLoader)inMemClassLoader);
                        JvmDeclaredType type = builder.buildType();
                        EList _contents = resource.getContents();
                        _contents.add((Object)type);
                    }
                    catch (Throwable _t) {
                        if (_t instanceof Throwable) {
                            Throwable t = _t;
                            throw new IllegalStateException("could not load type '" + topLevel + "'", t);
                        }
                        throw Exceptions.sneakyThrow((Throwable)_t);
                    }
                }
            }
        };
        DefaultProblemFactory _defaultProblemFactory = new DefaultProblemFactory();
        Compiler compiler = new Compiler((INameEnvironment)nameEnv, _proceedWithAllProblems, _compilerOptions, _function, (IProblemFactory)_defaultProblemFactory);
        compiler.compile(new ICompilationUnit[]{compilationUnit});
    }

    protected boolean isInfoFile(Resource resource) {
        boolean _xblockexpression = false;
        String name = resource.getURI().trimFileExtension().lastSegment();
        _xblockexpression = Objects.equal((Object)name, (Object)"package-info") || Objects.equal((Object)name, (Object)"module-info");
        return _xblockexpression;
    }

    protected CompilerOptions getCompilerOptions() {
        return this.getCompilerOptions((JavaConfig)null);
    }

    protected CompilerOptions getCompilerOptions(Resource resource) {
        ResourceSet _resourceSet = null;
        if (resource != null) {
            _resourceSet = resource.getResourceSet();
        }
        return this.getCompilerOptions(_resourceSet);
    }

    protected CompilerOptions getCompilerOptions(ResourceSet resourceSet) {
        JavaConfig _findInEmfObject = null;
        if (JavaConfig.class != null) {
            _findInEmfObject = JavaConfig.findInEmfObject((Notifier)resourceSet);
        }
        return this.getCompilerOptions(_findInEmfObject);
    }

    protected CompilerOptions getCompilerOptions(JavaConfig javaConfig) {
        try {
            NoSuchFieldException noSuchFieldException;
            JavaVersion _elvis = null;
            JavaVersion _javaSourceLevel = null;
            if (javaConfig != null) {
                _javaSourceLevel = javaConfig.getJavaSourceLevel();
            }
            _elvis = _javaSourceLevel != null ? _javaSourceLevel : JavaVersion.JAVA8;
            JavaVersion sourceVersion = _elvis;
            JavaVersion _elvis_1 = null;
            JavaVersion _javaTargetLevel = null;
            if (javaConfig != null) {
                _javaTargetLevel = javaConfig.getJavaTargetLevel();
            }
            _elvis_1 = _javaTargetLevel != null ? _javaTargetLevel : JavaVersion.JAVA8;
            JavaVersion targetVersion = _elvis_1;
            boolean _equals = Objects.equal((Object)sourceVersion, (Object)JavaVersion.JAVA7);
            if (_equals) {
                LOG.warn((Object)"The java source language has been configured with Java 7. JDT will not produce signature information for generic @Override methods in this version, which might lead to follow up issues.");
            }
            long sourceLevel = this.toJdtVersion(sourceVersion);
            long targetLevel = this.toJdtVersion(targetVersion);
            CompilerOptions compilerOptions = new CompilerOptions();
            compilerOptions.targetJDK = targetLevel;
            compilerOptions.inlineJsrBytecode = true;
            compilerOptions.sourceLevel = sourceLevel;
            compilerOptions.produceMethodParameters = true;
            compilerOptions.produceReferenceInfo = true;
            try {
                CompilerOptions.class.getField("originalSourceLevel").setLong(compilerOptions, targetLevel);
            }
            catch (Throwable _t) {
                if (_t instanceof NoSuchFieldException) {
                    noSuchFieldException = (NoSuchFieldException)_t;
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
            compilerOptions.complianceLevel = sourceLevel;
            try {
                CompilerOptions.class.getField("originalComplianceLevel").setLong(compilerOptions, targetLevel);
            }
            catch (Throwable _t_1) {
                if (_t_1 instanceof NoSuchFieldException) {
                    noSuchFieldException = (NoSuchFieldException)_t_1;
                }
                throw Exceptions.sneakyThrow((Throwable)_t_1);
            }
            return compilerOptions;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    protected long toJdtVersion(JavaVersion version) {
        try {
            long _switchResult = 0L;
            if (version != null) {
                switch (version) {
                    case JAVA5: {
                        _switchResult = 0x310000L;
                        break;
                    }
                    case JAVA6: {
                        _switchResult = 0x320000L;
                        break;
                    }
                    case JAVA7: {
                        _switchResult = 0x330000L;
                        break;
                    }
                    case JAVA8: {
                        long _xtrycatchfinallyexpression = 0L;
                        try {
                            _xtrycatchfinallyexpression = ClassFileConstants.class.getField("JDK1_8").getLong(null);
                        }
                        catch (Throwable _t) {
                            if (_t instanceof NoSuchFieldException) {
                                NoSuchFieldException e = (NoSuchFieldException)_t;
                                _xtrycatchfinallyexpression = 0x330000L;
                            }
                            throw Exceptions.sneakyThrow((Throwable)_t);
                        }
                        _switchResult = _xtrycatchfinallyexpression;
                        break;
                    }
                }
            }
            return _switchResult;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    protected ClassLoader getClassLoader(Resource it) {
        ResourceSet _resourceSet = it.getResourceSet();
        Object _classpathURIContext = ((XtextResourceSet)_resourceSet).getClasspathURIContext();
        return (ClassLoader)_classpathURIContext;
    }
}

