/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.index.Terms;
import org.apache.lucene.util.Bits;

public class ParallelLeafReader
extends LeafReader {
    private final FieldInfos fieldInfos;
    private final ParallelFields fields = new ParallelFields();
    private final LeafReader[] parallelReaders;
    private final LeafReader[] storedFieldsReaders;
    private final Set<LeafReader> completeReaderSet = Collections.newSetFromMap(new IdentityHashMap());
    private final boolean closeSubReaders;
    private final int maxDoc;
    private final int numDocs;
    private final boolean hasDeletions;
    private final SortedMap<String, LeafReader> fieldToReader = new TreeMap<String, LeafReader>();
    private final SortedMap<String, LeafReader> tvFieldToReader = new TreeMap<String, LeafReader>();

    public ParallelLeafReader(LeafReader ... readers) throws IOException {
        this(true, readers);
    }

    public ParallelLeafReader(boolean closeSubReaders, LeafReader ... readers) throws IOException {
        this(closeSubReaders, readers, readers);
    }

    public ParallelLeafReader(boolean closeSubReaders, LeafReader[] readers, LeafReader[] storedFieldsReaders) throws IOException {
        this.closeSubReaders = closeSubReaders;
        if (readers.length == 0 && storedFieldsReaders.length > 0) {
            throw new IllegalArgumentException("There must be at least one main reader if storedFieldsReaders are used.");
        }
        this.parallelReaders = (LeafReader[])readers.clone();
        this.storedFieldsReaders = (LeafReader[])storedFieldsReaders.clone();
        if (this.parallelReaders.length > 0) {
            LeafReader first = this.parallelReaders[0];
            this.maxDoc = first.maxDoc();
            this.numDocs = first.numDocs();
            this.hasDeletions = first.hasDeletions();
        } else {
            this.numDocs = 0;
            this.maxDoc = 0;
            this.hasDeletions = false;
        }
        Collections.addAll(this.completeReaderSet, this.parallelReaders);
        Collections.addAll(this.completeReaderSet, this.storedFieldsReaders);
        for (LeafReader reader : this.completeReaderSet) {
            if (reader.maxDoc() == this.maxDoc) continue;
            throw new IllegalArgumentException("All readers must have same maxDoc: " + this.maxDoc + "!=" + reader.maxDoc());
        }
        FieldInfos.Builder builder = new FieldInfos.Builder();
        for (LeafReader reader : this.parallelReaders) {
            FieldInfos readerFieldInfos = reader.getFieldInfos();
            for (FieldInfo fieldInfo : readerFieldInfos) {
                if (this.fieldToReader.containsKey(fieldInfo.name)) continue;
                builder.add(fieldInfo);
                this.fieldToReader.put(fieldInfo.name, reader);
                if (!fieldInfo.hasVectors()) continue;
                this.tvFieldToReader.put(fieldInfo.name, reader);
            }
        }
        this.fieldInfos = builder.finish();
        for (LeafReader reader : this.parallelReaders) {
            Fields readerFields = reader.fields();
            for (String field : readerFields) {
                if (this.fieldToReader.get(field) != reader) continue;
                this.fields.addField(field, readerFields.terms(field));
            }
        }
        for (LeafReader reader : this.completeReaderSet) {
            if (!closeSubReaders) {
                reader.incRef();
            }
            reader.registerParentReader(this);
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder("ParallelLeafReader(");
        Iterator<LeafReader> iter = this.completeReaderSet.iterator();
        while (iter.hasNext()) {
            buffer.append(iter.next());
            if (!iter.hasNext()) continue;
            buffer.append(", ");
        }
        return buffer.append(')').toString();
    }

    @Override
    public void addCoreClosedListener(LeafReader.CoreClosedListener listener) {
        ParallelLeafReader.addCoreClosedListenerAsReaderClosedListener(this, listener);
    }

    @Override
    public void removeCoreClosedListener(LeafReader.CoreClosedListener listener) {
        ParallelLeafReader.removeCoreClosedListenerAsReaderClosedListener(this, listener);
    }

    @Override
    public FieldInfos getFieldInfos() {
        return this.fieldInfos;
    }

    @Override
    public Bits getLiveDocs() {
        this.ensureOpen();
        return this.hasDeletions ? this.parallelReaders[0].getLiveDocs() : null;
    }

    @Override
    public Fields fields() {
        this.ensureOpen();
        return this.fields;
    }

    @Override
    public int numDocs() {
        return this.numDocs;
    }

    @Override
    public int maxDoc() {
        return this.maxDoc;
    }

    @Override
    public void document(int docID, StoredFieldVisitor visitor) throws IOException {
        this.ensureOpen();
        for (LeafReader reader : this.storedFieldsReaders) {
            reader.document(docID, visitor);
        }
    }

    @Override
    public Fields getTermVectors(int docID) throws IOException {
        this.ensureOpen();
        ParallelFields fields = null;
        for (Map.Entry<String, LeafReader> ent : this.tvFieldToReader.entrySet()) {
            String fieldName = ent.getKey();
            Terms vector = ent.getValue().getTermVector(docID, fieldName);
            if (vector == null) continue;
            if (fields == null) {
                fields = new ParallelFields();
            }
            fields.addField(fieldName, vector);
        }
        return fields;
    }

    @Override
    protected synchronized void doClose() throws IOException {
        IOException ioe = null;
        for (LeafReader reader : this.completeReaderSet) {
            try {
                if (this.closeSubReaders) {
                    reader.close();
                    continue;
                }
                reader.decRef();
            }
            catch (IOException e) {
                if (ioe != null) continue;
                ioe = e;
            }
        }
        if (ioe != null) {
            throw ioe;
        }
    }

    @Override
    public NumericDocValues getNumericDocValues(String field) throws IOException {
        this.ensureOpen();
        LeafReader reader = (LeafReader)this.fieldToReader.get(field);
        return reader == null ? null : reader.getNumericDocValues(field);
    }

    @Override
    public BinaryDocValues getBinaryDocValues(String field) throws IOException {
        this.ensureOpen();
        LeafReader reader = (LeafReader)this.fieldToReader.get(field);
        return reader == null ? null : reader.getBinaryDocValues(field);
    }

    @Override
    public SortedDocValues getSortedDocValues(String field) throws IOException {
        this.ensureOpen();
        LeafReader reader = (LeafReader)this.fieldToReader.get(field);
        return reader == null ? null : reader.getSortedDocValues(field);
    }

    @Override
    public SortedNumericDocValues getSortedNumericDocValues(String field) throws IOException {
        this.ensureOpen();
        LeafReader reader = (LeafReader)this.fieldToReader.get(field);
        return reader == null ? null : reader.getSortedNumericDocValues(field);
    }

    @Override
    public SortedSetDocValues getSortedSetDocValues(String field) throws IOException {
        this.ensureOpen();
        LeafReader reader = (LeafReader)this.fieldToReader.get(field);
        return reader == null ? null : reader.getSortedSetDocValues(field);
    }

    @Override
    public Bits getDocsWithField(String field) throws IOException {
        this.ensureOpen();
        LeafReader reader = (LeafReader)this.fieldToReader.get(field);
        return reader == null ? null : reader.getDocsWithField(field);
    }

    @Override
    public NumericDocValues getNormValues(String field) throws IOException {
        this.ensureOpen();
        LeafReader reader = (LeafReader)this.fieldToReader.get(field);
        NumericDocValues values = reader == null ? null : reader.getNormValues(field);
        return values;
    }

    @Override
    public PointValues getPointValues() {
        return new PointValues(){

            @Override
            public void intersect(String fieldName, PointValues.IntersectVisitor visitor) throws IOException {
                LeafReader reader = (LeafReader)ParallelLeafReader.this.fieldToReader.get(fieldName);
                if (reader == null) {
                    return;
                }
                PointValues dimValues = reader.getPointValues();
                if (dimValues == null) {
                    return;
                }
                dimValues.intersect(fieldName, visitor);
            }

            @Override
            public byte[] getMinPackedValue(String fieldName) throws IOException {
                LeafReader reader = (LeafReader)ParallelLeafReader.this.fieldToReader.get(fieldName);
                if (reader == null) {
                    return null;
                }
                PointValues dimValues = reader.getPointValues();
                if (dimValues == null) {
                    return null;
                }
                return dimValues.getMinPackedValue(fieldName);
            }

            @Override
            public byte[] getMaxPackedValue(String fieldName) throws IOException {
                LeafReader reader = (LeafReader)ParallelLeafReader.this.fieldToReader.get(fieldName);
                if (reader == null) {
                    return null;
                }
                PointValues dimValues = reader.getPointValues();
                if (dimValues == null) {
                    return null;
                }
                return dimValues.getMaxPackedValue(fieldName);
            }

            @Override
            public int getNumDimensions(String fieldName) throws IOException {
                LeafReader reader = (LeafReader)ParallelLeafReader.this.fieldToReader.get(fieldName);
                if (reader == null) {
                    return 0;
                }
                PointValues dimValues = reader.getPointValues();
                if (dimValues == null) {
                    return 0;
                }
                return dimValues.getNumDimensions(fieldName);
            }

            @Override
            public int getBytesPerDimension(String fieldName) throws IOException {
                LeafReader reader = (LeafReader)ParallelLeafReader.this.fieldToReader.get(fieldName);
                if (reader == null) {
                    return 0;
                }
                PointValues dimValues = reader.getPointValues();
                if (dimValues == null) {
                    return 0;
                }
                return dimValues.getBytesPerDimension(fieldName);
            }

            @Override
            public long size(String fieldName) {
                LeafReader reader = (LeafReader)ParallelLeafReader.this.fieldToReader.get(fieldName);
                if (reader == null) {
                    return 0L;
                }
                PointValues dimValues = reader.getPointValues();
                if (dimValues == null) {
                    return 0L;
                }
                return dimValues.size(fieldName);
            }

            @Override
            public int getDocCount(String fieldName) {
                LeafReader reader = (LeafReader)ParallelLeafReader.this.fieldToReader.get(fieldName);
                if (reader == null) {
                    return 0;
                }
                PointValues dimValues = reader.getPointValues();
                if (dimValues == null) {
                    return 0;
                }
                return dimValues.getDocCount(fieldName);
            }
        };
    }

    @Override
    public void checkIntegrity() throws IOException {
        this.ensureOpen();
        for (LeafReader reader : this.completeReaderSet) {
            reader.checkIntegrity();
        }
    }

    public LeafReader[] getParallelReaders() {
        this.ensureOpen();
        return this.parallelReaders;
    }

    private final class ParallelFields
    extends Fields {
        final Map<String, Terms> fields = new TreeMap<String, Terms>();

        ParallelFields() {
        }

        void addField(String fieldName, Terms terms) {
            this.fields.put(fieldName, terms);
        }

        @Override
        public Iterator<String> iterator() {
            return Collections.unmodifiableSet(this.fields.keySet()).iterator();
        }

        @Override
        public Terms terms(String field) {
            return this.fields.get(field);
        }

        @Override
        public int size() {
            return this.fields.size();
        }
    }
}

