/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ide.server.formatting;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.Collections;
import java.util.List;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.xtext.formatting2.FormatterRequest;
import org.eclipse.xtext.formatting2.IFormatter2;
import org.eclipse.xtext.formatting2.regionaccess.ITextRegionAccess;
import org.eclipse.xtext.formatting2.regionaccess.ITextReplacement;
import org.eclipse.xtext.formatting2.regionaccess.TextRegionAccessBuilder;
import org.eclipse.xtext.ide.server.Document;
import org.eclipse.xtext.preferences.ITypedPreferenceValues;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.TextRegion;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class FormattingService {
    @Inject(optional=true)
    private Provider<IFormatter2> formatter2Provider;
    @Inject
    private Provider<FormatterRequest> formatterRequestProvider;
    @Inject
    private TextRegionAccessBuilder regionBuilder;

    public List<TextEdit> format(XtextResource resource, Document document, int offset, int length) {
        if (this.formatter2Provider != null) {
            TextRegion _textRegion = new TextRegion(offset, length);
            List<ITextReplacement> replacements = this.format2(resource, (ITextRegion)_textRegion, null);
            Functions.Function1 _function = r -> this.toTextEdit(document, r.getReplacementText(), r.getOffset(), r.getLength());
            return IterableExtensions.toList((Iterable)ListExtensions.map(replacements, (Functions.Function1)_function));
        }
        return CollectionLiterals.newArrayList((Object[])new TextEdit[0]);
    }

    protected TextEdit toTextEdit(Document document, String formattedText, int startOffset, int length) {
        TextEdit _textEdit = new TextEdit();
        Procedures.Procedure1 _function = it -> {
            it.setNewText(formattedText);
            Range _range = new Range();
            Procedures.Procedure1 _function_1 = it_1 -> {
                it_1.setStart(document.getPosition(startOffset));
                it_1.setEnd(document.getPosition(startOffset + length));
            };
            Range _doubleArrow = (Range)ObjectExtensions.operator_doubleArrow((Object)_range, (Procedures.Procedure1)_function_1);
            it.setRange(_doubleArrow);
        };
        return (TextEdit)ObjectExtensions.operator_doubleArrow((Object)_textEdit, (Procedures.Procedure1)_function);
    }

    protected List<ITextReplacement> format2(XtextResource resource, ITextRegion selection, ITypedPreferenceValues preferences) {
        FormatterRequest request = (FormatterRequest)this.formatterRequestProvider.get();
        request.setAllowIdentityEdits(false);
        request.setFormatUndefinedHiddenRegionsOnly(false);
        if (selection != null) {
            request.setRegions(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new ITextRegion[]{selection})));
        }
        if (preferences != null) {
            request.setPreferences(preferences);
        }
        ITextRegionAccess regionAccess = this.regionBuilder.forNodeModel(resource).create();
        request.setTextRegionAccess(regionAccess);
        IFormatter2 formatter2 = (IFormatter2)this.formatter2Provider.get();
        List replacements = formatter2.format(request);
        return replacements;
    }
}

