/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.tasks;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.xtext.tasks.Priority;
import org.eclipse.xtext.tasks.Task;

public class TaskMarkerCreator {
    public void createMarker(Task task, IResource resource, String markerType) throws CoreException {
        IMarker marker = resource.createMarker(markerType);
        this.setMarkerAttributes(task, resource, marker);
    }

    protected void setMarkerAttributes(Task task, IResource resource, IMarker marker) throws CoreException {
        marker.setAttribute("location", (Object)("line " + task.getLineNumber()));
        marker.setAttribute("priority", this.getPriority(task.getTag().getPriority()));
        marker.setAttribute("message", (Object)task.getFullText());
        marker.setAttribute("lineNumber", task.getLineNumber());
        marker.setAttribute("charStart", task.getOffset());
        marker.setAttribute("charEnd", task.getOffset() + task.getTotalLength());
        marker.setAttribute("userEditable", false);
    }

    private int getPriority(Priority priority) {
        switch (priority) {
            case HIGH: {
                return 2;
            }
            case NORMAL: {
                return 1;
            }
            case LOW: {
                return 0;
            }
        }
        return 1;
    }
}

