/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.zvtm.widgets;

import fr.inria.zvtm.widgets.FontTracker;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class FontDialog
extends JDialog
implements ActionListener {
    static final String ZVTM_FONT_CHOOSER = "ZVTM Font Chooser";
    static String DEFAULT_FAMILY = "Dialog";
    static int DEFAULT_STYLE = 0;
    static int DEFAULT_SIZE = 10;
    FontTracker ft;
    JButton okBt;
    JButton cancelBt;
    JList familyList;
    JList styleList;
    JList sizeList;
    String[] allFontFamilies = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
    String[] allFontStyles = new String[]{"Plain", "Bold", "Italic", "BoldItalic"};
    String[] allFontSizes = new String[]{"4", "6", "8", "10", "12", "14", "16", "18", "20", "24"};

    public static Font getFontDialog(Frame owner) {
        FontTracker res = new FontTracker();
        FontDialog fd = new FontDialog(res, owner);
        fd.addWindowListener(new Closer());
        fd.addComponentListener(new DisposeOnClose());
        fd.setLocationRelativeTo(owner);
        fd.setVisible(true);
        return res.getFont();
    }

    public static Font getFontDialog(Dialog owner) {
        FontTracker res = new FontTracker();
        FontDialog fd = new FontDialog(res, owner);
        fd.addWindowListener(new Closer());
        fd.addComponentListener(new DisposeOnClose());
        fd.setLocationRelativeTo(owner);
        fd.setVisible(true);
        return res.getFont();
    }

    public static Font getFontDialog(Frame owner, Font f) {
        if (f != null) {
            DEFAULT_FAMILY = f.getFamily();
            DEFAULT_STYLE = f.getStyle();
            DEFAULT_SIZE = f.getSize();
        }
        FontTracker res = new FontTracker();
        FontDialog fd = new FontDialog(res, owner);
        fd.addWindowListener(new Closer());
        fd.addComponentListener(new DisposeOnClose());
        fd.setLocationRelativeTo(owner);
        fd.setVisible(true);
        return res.getFont();
    }

    public static Font getFontDialog(Dialog owner, Font f) {
        if (f != null) {
            DEFAULT_FAMILY = f.getFamily();
            DEFAULT_STYLE = f.getStyle();
            DEFAULT_SIZE = f.getSize();
        }
        FontTracker res = new FontTracker();
        FontDialog fd = new FontDialog(res, owner);
        fd.addWindowListener(new Closer());
        fd.addComponentListener(new DisposeOnClose());
        fd.setLocationRelativeTo(owner);
        fd.setVisible(true);
        return res.getFont();
    }

    public static Font decode(String fontSpec) {
        if (fontSpec != null && fontSpec.length() > 0) {
            StringTokenizer st = new StringTokenizer(fontSpec, " ", false);
            String[] tokens = new String[st.countTokens()];
            if (tokens.length >= 3) {
                int size;
                int i = 0;
                while (st.hasMoreTokens()) {
                    tokens[i++] = st.nextToken();
                }
                String tokenizedFamily = "";
                for (int j = 0; j < tokens.length - 3; ++j) {
                    tokenizedFamily = tokenizedFamily + tokens[j] + " ";
                }
                String family = tokenizedFamily = tokenizedFamily + tokens[tokens.length - 3];
                if (family == null) {
                    family = DEFAULT_FAMILY;
                }
                String tokenizedStyle = tokens[tokens.length - 2];
                String tokenizedSize = tokens[tokens.length - 1];
                int style = tokenizedStyle.equals("Bold") ? 1 : (tokenizedStyle.equals("Italic") ? 2 : (tokenizedStyle.equals("BoldItalic") ? 3 : 0));
                try {
                    size = Integer.parseInt(tokenizedSize);
                    if (size <= 0) {
                        size = DEFAULT_SIZE;
                    }
                }
                catch (NumberFormatException ex) {
                    size = DEFAULT_SIZE;
                }
                return new Font(family, style, size);
            }
            return new Font(DEFAULT_FAMILY, DEFAULT_STYLE, DEFAULT_SIZE);
        }
        return new Font(DEFAULT_FAMILY, DEFAULT_STYLE, DEFAULT_SIZE);
    }

    FontDialog(FontTracker ftt, Frame owner) {
        super(owner, ZVTM_FONT_CHOOSER, true);
        this.setLocation(owner.getLocation());
        this.ft = ftt;
        this.initUI();
    }

    FontDialog(FontTracker ftt, Dialog owner) {
        super(owner, ZVTM_FONT_CHOOSER, true);
        this.setLocation(owner.getLocation());
        this.ft = ftt;
        this.initUI();
    }

    void initUI() {
        Container cp = this.getContentPane();
        try {
            this.okBt.removeActionListener(this);
            this.cancelBt.removeActionListener(this);
        }
        catch (NullPointerException ex) {
            // empty catch block
        }
        cp.removeAll();
        JPanel mainPanel = new JPanel();
        GridBagLayout gridBag1 = new GridBagLayout();
        GridBagConstraints constraints1 = new GridBagConstraints();
        mainPanel.setLayout(gridBag1);
        constraints1.fill = 1;
        constraints1.anchor = 10;
        this.familyList = new JList<String>(this.allFontFamilies);
        JScrollPane sp1 = new JScrollPane(this.familyList);
        FontDialog.buildConstraints(constraints1, 0, 0, 1, 1, 30, 100);
        gridBag1.setConstraints(sp1, constraints1);
        mainPanel.add(sp1);
        this.styleList = new JList<String>(this.allFontStyles);
        JScrollPane sp2 = new JScrollPane(this.styleList);
        FontDialog.buildConstraints(constraints1, 1, 0, 1, 1, 30, 0);
        gridBag1.setConstraints(sp2, constraints1);
        mainPanel.add(sp2);
        this.sizeList = new JList<String>(this.allFontSizes);
        JScrollPane sp3 = new JScrollPane(this.sizeList);
        FontDialog.buildConstraints(constraints1, 2, 0, 1, 1, 25, 0);
        gridBag1.setConstraints(sp3, constraints1);
        mainPanel.add(sp3);
        JPanel btPanel = new JPanel();
        btPanel.setLayout(new FlowLayout());
        this.okBt = new JButton("OK");
        this.okBt.addActionListener(this);
        btPanel.add(this.okBt);
        this.cancelBt = new JButton("Cancel");
        this.cancelBt.addActionListener(this);
        btPanel.add(this.cancelBt);
        GridBagLayout gridBag = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        cp.setLayout(gridBag);
        constraints.fill = 1;
        constraints.anchor = 10;
        FontDialog.buildConstraints(constraints, 0, 0, 1, 1, 100, 99);
        gridBag.setConstraints(mainPanel, constraints);
        cp.add(mainPanel);
        FontDialog.buildConstraints(constraints, 0, 1, 1, 1, 100, 1);
        gridBag.setConstraints(btPanel, constraints);
        cp.add(btPanel);
        this.setSize(350, 200);
        this.setResizable(false);
        this.familyList.setSelectedValue(DEFAULT_FAMILY, true);
        if (DEFAULT_STYLE == 0) {
            this.styleList.setSelectedValue("Plain", true);
        } else if (DEFAULT_STYLE == 1) {
            this.styleList.setSelectedValue("Bold", true);
        } else if (DEFAULT_STYLE == 2) {
            this.styleList.setSelectedValue("Italic", true);
        } else if (DEFAULT_STYLE == 3) {
            this.styleList.setSelectedValue("BoldItalic", true);
        }
        this.sizeList.setSelectedValue(new Integer(DEFAULT_SIZE).toString(), true);
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.okBt) {
            this.ft.setFont(this.getSelectedFont());
            this.dispose();
        } else if (source == this.cancelBt) {
            this.ft.setFont(null);
            this.dispose();
        }
    }

    Font getSelectedFont() {
        int size;
        String selectedStyle;
        String family = (String)this.familyList.getSelectedValue();
        if (family == null) {
            family = DEFAULT_FAMILY;
        }
        int style = (selectedStyle = (String)this.styleList.getSelectedValue()).equals("Bold") ? 1 : (selectedStyle.equals("Italic") ? 2 : (selectedStyle.equals("BoldItalic") ? 3 : 0));
        try {
            String selectedSize = (String)this.sizeList.getSelectedValue();
            size = Integer.parseInt(selectedSize);
            if (size <= 0) {
                size = DEFAULT_SIZE;
            }
        }
        catch (NumberFormatException ex) {
            size = DEFAULT_SIZE;
        }
        return new Font(family, style, size);
    }

    static void buildConstraints(GridBagConstraints gbc, int gx, int gy, int gw, int gh, int wx, int wy) {
        gbc.gridx = gx;
        gbc.gridy = gy;
        gbc.gridwidth = gw;
        gbc.gridheight = gh;
        gbc.weightx = wx;
        gbc.weighty = wy;
    }

    public static String getFontStyleName(int i) {
        if (i == 1) {
            return "Bold";
        }
        if (i == 2) {
            return "Italic";
        }
        if (i == 3) {
            return "BoldItalic";
        }
        return "Plain";
    }

    static class DisposeOnClose
    extends ComponentAdapter {
        DisposeOnClose() {
        }

        public void componentHidden(ComponentEvent e) {
            Window w = (Window)e.getComponent();
            w.dispose();
        }
    }

    static class Closer
    extends WindowAdapter {
        Closer() {
        }

        public void windowClosing(WindowEvent e) {
            Window w = e.getWindow();
            w.setVisible(false);
        }
    }
}

