/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.zvtm.glyphs;

import fr.inria.zvtm.engine.VirtualSpaceManager;
import fr.inria.zvtm.glyphs.Glyph;
import java.awt.Color;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ClosedShape<T>
extends Glyph {
    public Color borderColor;
    protected float[] HSVb = new float[3];
    public Color bColor = Color.BLACK;
    public Color cursorInsideFColor;
    boolean filled = true;
    boolean paintBorder = true;

    public void setFilled(boolean b) {
        if (b != this.filled) {
            this.filled = b;
            VirtualSpaceManager.INSTANCE.repaint();
        }
    }

    @Override
    public boolean isFilled() {
        return this.filled;
    }

    public void setDrawBorder(boolean b) {
        if (b != this.paintBorder) {
            this.paintBorder = b;
            VirtualSpaceManager.INSTANCE.repaint();
        }
    }

    @Override
    public boolean isBorderDrawn() {
        return this.paintBorder;
    }

    public void setCursorInsideFillColor(Color c) {
        this.cursorInsideFColor = c;
    }

    @Override
    public void setBorderColor(Color c) {
        this.bColor = this.borderColor = c;
        if (this.borderColor != null) {
            this.HSVb = Color.RGBtoHSB(this.borderColor.getRed(), this.borderColor.getGreen(), this.borderColor.getBlue(), new float[3]);
        }
        VirtualSpaceManager.INSTANCE.repaint();
    }

    @Override
    public void setHSVbColor(float h, float s, float v) {
        this.HSVb[0] = h;
        if (this.HSVb[0] > 1.0f) {
            this.HSVb[0] = 1.0f;
        } else if (this.HSVb[0] < 0.0f) {
            this.HSVb[0] = 0.0f;
        }
        this.HSVb[1] = s;
        if (this.HSVb[1] > 1.0f) {
            this.HSVb[1] = 1.0f;
        } else if (this.HSVb[1] < 0.0f) {
            this.HSVb[1] = 0.0f;
        }
        this.HSVb[2] = v;
        if (this.HSVb[2] > 1.0f) {
            this.HSVb[2] = 1.0f;
        } else if (this.HSVb[2] < 0.0f) {
            this.HSVb[2] = 0.0f;
        }
        this.bColor = this.borderColor = Color.getHSBColor(this.HSVb[0], this.HSVb[1], this.HSVb[2]);
        VirtualSpaceManager.INSTANCE.repaint();
    }

    @Override
    public void addHSVbColor(float h, float s, float v) {
        this.HSVb[0] = this.HSVb[0] + h;
        if (this.HSVb[0] > 1.0f) {
            this.HSVb[0] = 1.0f;
        } else if (this.HSVb[0] < 0.0f) {
            this.HSVb[0] = 0.0f;
        }
        this.HSVb[1] = this.HSVb[1] + s;
        if (this.HSVb[1] > 1.0f) {
            this.HSVb[1] = 1.0f;
        } else if (this.HSVb[1] < 0.0f) {
            this.HSVb[1] = 0.0f;
        }
        this.HSVb[2] = this.HSVb[2] + v;
        if (this.HSVb[2] > 1.0f) {
            this.HSVb[2] = 1.0f;
        } else if (this.HSVb[2] < 0.0f) {
            this.HSVb[2] = 0.0f;
        }
        this.bColor = this.borderColor = Color.getHSBColor(this.HSVb[0], this.HSVb[1], this.HSVb[2]);
        VirtualSpaceManager.INSTANCE.repaint();
    }

    @Override
    public float[] getHSVbColor() {
        return this.HSVb;
    }

    @Override
    public Color getBorderColor() {
        return this.borderColor;
    }

    public Color getDefaultBorderColor() {
        return this.bColor;
    }

    @Override
    public void highlight(boolean b, Color selectedColor) {
        boolean update = false;
        if (b) {
            if (this.cursorInsideFColor != null) {
                this.color = this.cursorInsideFColor;
                update = true;
            }
            if (this.cursorInsideColor != null) {
                this.borderColor = this.cursorInsideColor;
                update = true;
            }
        } else if (this.isSelected() && selectedColor != null) {
            this.borderColor = selectedColor;
            update = true;
        } else {
            if (this.cursorInsideFColor != null) {
                this.color = this.fColor;
                update = true;
            }
            if (this.cursorInsideColor != null) {
                this.borderColor = this.bColor;
                update = true;
            }
        }
        if (update) {
            VirtualSpaceManager.INSTANCE.repaint();
        }
    }
}

