/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.zvtm.engine.portals;

import fr.inria.zvtm.engine.Camera;
import fr.inria.zvtm.engine.View;
import fr.inria.zvtm.engine.VirtualSpaceManager;
import fr.inria.zvtm.engine.portals.TrailingCameraPortal;
import fr.inria.zvtm.event.ObservedRegionListener;
import fr.inria.zvtm.glyphs.Glyph;
import fr.inria.zvtm.glyphs.Translucent;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;

public class TrailingOverview
extends TrailingCameraPortal {
    AlphaComposite orST = AlphaComposite.getInstance(3, 0.5f);
    Camera observedRegionCamera;
    View observedRegionView;
    double[] observedRegion;
    float orcoef;
    Timer borderTimer;
    ObservedRegionListener observedRegionListener;

    public TrailingOverview(int x, int y, int w, int h, Camera pc, Camera orc, float a, int xo, int yo) {
        super(x, y, w, h, pc, a, xo, yo);
        this.observedRegionCamera = orc;
        this.observedRegionView = orc.getOwningView();
        this.observedRegion = new double[4];
        this.borderTimer = new Timer();
        this.borderTimer.scheduleAtFixedRate((TimerTask)new BorderTimer(this), 40L, 40L);
    }

    public void setTransparencyValue(float a) {
        block3: {
            if (a < 0.0f) {
                a = 0.0f;
            }
            try {
                this.alphaC = AlphaComposite.getInstance(3, a);
                this.alpha = a;
                this.orST = AlphaComposite.getInstance(3, a / 2.0f);
            }
            catch (IllegalArgumentException ex) {
                if (!VirtualSpaceManager.debugModeON()) break block3;
                System.err.println("Error animating translucency of " + this.toString() + ": " + a);
            }
        }
    }

    public boolean coordInsideObservedRegion(int cx, int cy) {
        return (long)cx >= (long)(this.x + this.w / 2) + Math.round((this.observedRegion[0] - this.camera.vx) * (double)this.orcoef) && (long)cy >= (long)(this.y + this.h / 2) + Math.round((this.camera.vy - this.observedRegion[1]) * (double)this.orcoef) && (long)cx <= (long)(this.x + this.w / 2) + Math.round((this.observedRegion[2] - this.camera.vx) * (double)this.orcoef) && (long)cy <= (long)(this.y + this.h / 2) + Math.round((this.camera.vy - this.observedRegion[3]) * (double)this.orcoef);
    }

    public void setObservedRegionListener(ObservedRegionListener orl) {
        this.observedRegionListener = orl;
    }

    void observedRegionIntersects(double[] wnes) {
        if (this.observedRegionListener != null) {
            this.observedRegionListener.intersectsParentRegion(wnes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics2D g2d, int viewWidth, int viewHeight) {
        g2d.setClip(this.x, this.y, this.w, this.h);
        g2d.setComposite(this.alphaC);
        if (this.bkgColor != null) {
            g2d.setColor(this.bkgColor);
            g2d.fillRect(this.x, this.y, this.w, this.h);
        }
        this.standardStroke = g2d.getStroke();
        this.standardTransform = g2d.getTransform();
        this.drawnGlyphs = this.cameraSpace.getDrawnGlyphs(this.camIndex);
        Vector vector = this.drawnGlyphs;
        synchronized (vector) {
            this.drawnGlyphs.removeAllElements();
            this.duncoef = (this.camera.focal + this.camera.altitude) / this.camera.focal;
            this.viewWC = this.camera.vx - (double)(this.w / 2) * this.duncoef;
            this.viewNC = this.camera.vy + (double)(this.h / 2) * this.duncoef;
            this.viewEC = this.camera.vx + (double)(this.w / 2) * this.duncoef;
            this.viewSC = this.camera.vy - (double)(this.h / 2) * this.duncoef;
            this.gll = this.cameraSpace.getDrawingList();
            for (int i = 0; i < this.gll.length; ++i) {
                if (this.gll[i] == null) continue;
                Glyph glyph = this.gll[i];
                synchronized (glyph) {
                    if (this.gll[i].visibleInViewport(this.viewWC, this.viewNC, this.viewEC, this.viewSC, this.camera)) {
                        this.gll[i].project(this.camera, this.size);
                        if (this.gll[i].isVisible()) {
                            this.gll[i].draw(g2d, this.w, this.h, this.camIndex, this.standardStroke, this.standardTransform, this.x, this.y);
                        }
                        this.cameraSpace.drewGlyph(this.gll[i], this.camIndex);
                    }
                    continue;
                }
            }
        }
        this.observedRegion = this.observedRegionView.getVisibleRegion(this.observedRegionCamera, this.observedRegion);
        g2d.setColor(Color.GREEN);
        g2d.setComposite(this.orST);
        this.orcoef = (float)(this.camera.focal / (this.camera.focal + this.camera.altitude));
        g2d.fillRect((int)((long)(this.x + this.w / 2) + Math.round((this.observedRegion[0] - this.camera.vx) * (double)this.orcoef)), (int)((long)(this.y + this.h / 2) - Math.round((this.observedRegion[1] - this.camera.vy) * (double)this.orcoef)), (int)Math.round((this.observedRegion[2] - this.observedRegion[0]) * (double)this.orcoef), (int)Math.round((this.observedRegion[1] - this.observedRegion[3]) * (double)this.orcoef));
        g2d.setComposite(this.alphaC);
        g2d.drawRect((int)((long)(this.x + this.w / 2) + Math.round((this.observedRegion[0] - this.camera.vx) * (double)this.orcoef)), (int)((long)(this.y + this.h / 2) - Math.round((this.observedRegion[1] - this.camera.vy) * (double)this.orcoef)), (int)Math.round((this.observedRegion[2] - this.observedRegion[0]) * (double)this.orcoef), (int)Math.round((this.observedRegion[1] - this.observedRegion[3]) * (double)this.orcoef));
        g2d.setClip(0, 0, viewWidth, viewHeight);
        if (this.borderColor != null) {
            g2d.setColor(this.borderColor);
            g2d.drawRect(this.x, this.y, this.w, this.h);
        }
        g2d.setComposite(Translucent.acO);
    }

    public void dispose() {
        super.dispose();
        this.borderTimer.cancel();
    }

    protected class BorderTimer
    extends TimerTask {
        TrailingOverview portal;
        double[] portalRegion = new double[4];
        double[] intersection = new double[4];

        BorderTimer(TrailingOverview p) {
            this.portal = p;
        }

        public void run() {
            this.portal.getVisibleRegion(this.portalRegion);
            this.intersection[0] = this.portal.observedRegion[0] - this.portalRegion[0];
            this.intersection[1] = this.portal.observedRegion[1] - this.portalRegion[1];
            this.intersection[2] = this.portal.observedRegion[2] - this.portalRegion[2];
            this.intersection[3] = this.portal.observedRegion[3] - this.portalRegion[3];
            this.portal.observedRegionIntersects(this.intersection);
        }
    }
}

