/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.zvtm.engine.portals;

import fr.inria.zvtm.engine.Camera;
import fr.inria.zvtm.engine.portals.CameraPortal;
import fr.inria.zvtm.glyphs.Glyph;
import java.awt.Color;
import java.awt.Graphics2D;
import java.util.Vector;

public class DraggableCameraPortal
extends CameraPortal {
    Color barColor = Color.RED;
    int barHeight = 10;

    public DraggableCameraPortal(int x, int y, int w, int h, Camera c) {
        super(x, y, w, h, c);
    }

    public void setDragBarColor(Color bc) {
        this.barColor = bc;
    }

    public Color getDragBarColor() {
        return this.barColor;
    }

    public void setDragBarHeight(int bh) {
        this.barHeight = bh;
    }

    public int getDragBarHeight() {
        return this.barHeight;
    }

    public boolean coordInsideBar(int cx, int cy) {
        return cx >= this.x && cx <= this.x + this.w && cy >= this.y && cy <= this.y + this.barHeight;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics2D g2d, int viewWidth, int viewHeight) {
        if (!this.visible) {
            return;
        }
        g2d.setClip(this.x, this.y, this.w, this.h);
        if (this.bkgColor != null) {
            g2d.setColor(this.bkgColor);
            g2d.fillRect(this.x, this.y, this.w, this.h);
        }
        this.standardStroke = g2d.getStroke();
        this.standardTransform = g2d.getTransform();
        this.drawnGlyphs = this.cameraSpace.getDrawnGlyphs(this.camIndex);
        Vector vector = this.drawnGlyphs;
        synchronized (vector) {
            this.drawnGlyphs.removeAllElements();
            this.duncoef = (this.camera.focal + this.camera.altitude) / this.camera.focal;
            this.viewWC = this.camera.vx - (double)(this.w / 2) * this.duncoef;
            this.viewNC = this.camera.vy + (double)(this.h / 2) * this.duncoef;
            this.viewEC = this.camera.vx + (double)(this.w / 2) * this.duncoef;
            this.viewSC = this.camera.vy - (double)(this.h / 2) * this.duncoef;
            this.gll = this.cameraSpace.getDrawingList();
            for (int i = 0; i < this.gll.length; ++i) {
                if (this.gll[i] == null) continue;
                Glyph glyph = this.gll[i];
                synchronized (glyph) {
                    if (this.gll[i].visibleInViewport(this.viewWC, this.viewNC, this.viewEC, this.viewSC, this.camera)) {
                        this.gll[i].project(this.camera, this.size);
                        if (this.gll[i].isVisible()) {
                            this.gll[i].draw(g2d, this.w, this.h, this.camIndex, this.standardStroke, this.standardTransform, this.x, this.y);
                        }
                        this.cameraSpace.drewGlyph(this.gll[i], this.camIndex);
                    }
                    continue;
                }
            }
        }
        g2d.setClip(0, 0, viewWidth, viewHeight);
        g2d.setColor(this.barColor);
        g2d.fillRect(this.x, this.y, this.w, this.barHeight);
        if (this.borderColor != null) {
            g2d.setColor(this.borderColor);
            g2d.drawRect(this.x, this.y, this.w, this.h);
        }
    }
}

