/*
 * Decompiled with CFR 0.152.
 */
package net.claribole.zgrviewer;

import fr.inria.zvtm.svg.SVGReader;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.StringTokenizer;
import javax.swing.JOptionPane;
import net.claribole.zgrviewer.ConfigManager;
import net.claribole.zgrviewer.GraphicsManager;
import net.claribole.zgrviewer.ProcessOutputConsumer;
import net.claribole.zgrviewer.Utils;
import org.w3c.dom.Document;

class DOTManager {
    static final short DOT_PROGRAM = 0;
    static final short NEATO_PROGRAM = 1;
    static final short CIRCO_PROGRAM = 2;
    static final short TWOPI_PROGRAM = 3;
    static final short SVG_FILE = 4;
    short lastProgramUsed = 0;
    ConfigManager cfgMngr;
    GraphicsManager grMngr;
    File dotF;
    File svgF;

    DOTManager(GraphicsManager gm, ConfigManager cm) {
        this.grMngr = gm;
        this.cfgMngr = cm;
    }

    void load(File f, short prg, boolean parser) {
        this.grMngr.gp.setMessage("Resetting...");
        this.grMngr.gp.setProgress(10);
        this.grMngr.gp.setVisible(true);
        try {
            this.svgF = Utils.createTempFile(ConfigManager.m_TmpDir.toString(), "zgrv", parser ? ".dot" : ".svg");
            this.dotF = f;
            this.callGraphViz(prg, parser);
            this.grMngr.gp.setMessage("Deleting Temp File...");
            this.grMngr.gp.setProgress(100);
            this.grMngr.gp.setVisible(false);
        }
        catch (Exception ex) {
            this.grMngr.gp.setVisible(false);
            JOptionPane.showMessageDialog(this.grMngr.mainView.getFrame(), "An error occured while loading from " + f.toString());
        }
    }

    private void callGraphViz(short prg, boolean parser) throws Exception {
        try {
            this.grMngr.gp.setMessage("Preparing " + (parser ? "Augmented DOT" : "SVG") + " Temp File");
            this.grMngr.gp.setProgress(10);
            if (!this.generateSVGFile(this.dotF.getAbsolutePath(), this.svgF.getAbsolutePath(), prg)) {
                this.deleteTempFiles();
                return;
            }
            this.displaySVG(this.dotF.getAbsoluteFile().getParentFile());
            if (ConfigManager.DELETE_TEMP_FILES) {
                this.deleteTempFiles();
            }
        }
        catch (Exception e) {
            System.err.println("Exception generating graph: " + e.getMessage() + "\n");
            e.printStackTrace();
            throw new Exception();
        }
    }

    void deleteTempFiles() {
        if (this.svgF != null) {
            this.svgF.delete();
        }
    }

    protected String getProgram(short prg) {
        switch (prg) {
            case 0: {
                return ConfigManager.m_DotPath.toString();
            }
            case 1: {
                return ConfigManager.m_NeatoPath.toString();
            }
            case 3: {
                return ConfigManager.m_TwopiPath.toString();
            }
            case 2: {
                return ConfigManager.m_CircoPath.toString();
            }
        }
        return ConfigManager.m_DotPath.toString();
    }

    private boolean generateDOTFile(String dotFilePath, String tmpFilePath, short prg) {
        String[] cmdArray = new String[ConfigManager.FORCE_SILENT ? 7 : 6];
        cmdArray[0] = this.getProgram(prg);
        cmdArray[1] = "-Tdot";
        if (ConfigManager.FORCE_SILENT) {
            cmdArray[2] = "-q";
            cmdArray[3] = DOTManager.checkOptions(ConfigManager.CMD_LINE_OPTS);
            cmdArray[4] = "-o";
            cmdArray[5] = tmpFilePath;
            cmdArray[6] = dotFilePath;
        } else {
            cmdArray[2] = DOTManager.checkOptions(ConfigManager.CMD_LINE_OPTS);
            cmdArray[3] = "-o";
            cmdArray[4] = tmpFilePath;
            cmdArray[5] = dotFilePath;
        }
        Runtime rt = Runtime.getRuntime();
        this.grMngr.gp.setMessage("Computing Graph Layout (GraphViz)...");
        this.grMngr.gp.setProgress(40);
        try {
            try {
                File execDir = new File(dotFilePath).getParentFile();
                Process p = rt.exec(cmdArray, null, execDir);
                this.executeProcess(p);
            }
            catch (IOException ex) {
                Process p = rt.exec(cmdArray);
                this.executeProcess(p);
            }
        }
        catch (Exception e) {
            System.err.println("Error: generating OutputFile.\n");
            return false;
        }
        return true;
    }

    private boolean generateSVGFile(String dotFilePath, String svgFilePath, short prg) {
        String[] cmdArray = new String[ConfigManager.FORCE_SILENT ? 7 : 6];
        cmdArray[0] = this.getProgram(prg);
        cmdArray[1] = "-Tsvg";
        if (ConfigManager.FORCE_SILENT) {
            cmdArray[2] = "-q";
            cmdArray[3] = DOTManager.checkOptions(ConfigManager.CMD_LINE_OPTS);
            cmdArray[4] = "-o";
            cmdArray[5] = svgFilePath;
            cmdArray[6] = dotFilePath;
        } else {
            cmdArray[2] = DOTManager.checkOptions(ConfigManager.CMD_LINE_OPTS);
            cmdArray[3] = "-o";
            cmdArray[4] = svgFilePath;
            cmdArray[5] = dotFilePath;
        }
        Runtime rt = Runtime.getRuntime();
        this.grMngr.gp.setMessage("Computing Graph Layout (GraphViz)...");
        this.grMngr.gp.setProgress(40);
        try {
            try {
                File execDir = new File(dotFilePath).getParentFile();
                Process p = rt.exec(cmdArray, null, execDir);
                this.executeProcess(p);
            }
            catch (IOException ex) {
                Process p = rt.exec(cmdArray);
                p.waitFor();
            }
        }
        catch (Exception e) {
            System.err.println("Error: generating OutputFile.\n");
            return false;
        }
        return true;
    }

    protected void executeProcess(Process p) throws InterruptedException, IOException {
        ProcessOutputConsumer consumer = new ProcessOutputConsumer(p);
        consumer.start();
        p.waitFor();
        p.destroy();
        consumer.interrupt();
    }

    void loadCustom(String srcFile, String cmdLineExpr) {
        this.grMngr.gp.setMessage("Resetting SVG...");
        this.grMngr.gp.setProgress(10);
        this.grMngr.gp.setVisible(true);
        try {
            this.svgF = Utils.createTempFile(ConfigManager.m_TmpDir.toString(), "zgrv", ".svg");
            if (!this.generateSVGFileFOP(srcFile, this.svgF.getAbsolutePath(), cmdLineExpr)) {
                this.deleteTempFiles();
                return;
            }
            this.displaySVG(new File(srcFile).getParentFile());
            if (ConfigManager.DELETE_TEMP_FILES) {
                this.deleteTempFiles();
            }
            this.grMngr.gp.setMessage("Deleting Temp File...");
            this.grMngr.gp.setProgress(100);
            this.grMngr.gp.setVisible(false);
        }
        catch (Exception ex) {
            this.grMngr.gp.setVisible(false);
            JOptionPane.showMessageDialog(this.grMngr.mainView.getFrame(), "An error occured while loading from " + srcFile);
        }
    }

    private boolean generateSVGFileFOP(String srcFilePath, String svgFilePath, String commandLine) {
        StringTokenizer st = new StringTokenizer(commandLine, " ");
        int nbTokens = st.countTokens();
        String[] cmdArray = new String[nbTokens];
        for (int i = 0; i < nbTokens; ++i) {
            cmdArray[i] = st.nextToken();
            if (cmdArray[i].equals("%s")) {
                cmdArray[i] = srcFilePath;
                continue;
            }
            if (!cmdArray[i].equals("%t")) continue;
            cmdArray[i] = svgFilePath;
        }
        Runtime rt = Runtime.getRuntime();
        this.grMngr.gp.setMessage("Computing layout...");
        this.grMngr.gp.setProgress(40);
        try {
            try {
                File execDir = new File(srcFilePath).getParentFile();
                Process p = rt.exec(cmdArray, null, execDir);
                p.waitFor();
            }
            catch (IOException ex) {
                Process p = rt.exec(cmdArray);
                p.waitFor();
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.grMngr.mainView.getFrame(), "An error occured while running the following command line:\n\n" + Utils.join(cmdArray, " "), "Command line call error", 0);
            System.err.println("Error generating output SVG file.\n");
            return false;
        }
        return true;
    }

    void displaySVG(File sourceDotFileParentDir) {
        this.grMngr.gp.setMessage("Parsing SVG...");
        this.grMngr.gp.setProgress(60);
        Document svgDoc = Utils.parse(this.svgF, false);
        this.grMngr.gp.setMessage("Displaying...");
        this.grMngr.gp.setProgress(80);
        try {
            SVGReader.load(svgDoc, this.grMngr.mSpace, true, this.svgF.toURI().toURL().toString(), sourceDotFileParentDir.toURI().toURL().toString());
            this.grMngr.seekBoundingBox();
            this.grMngr.buildLogicalStructure();
        }
        catch (MalformedURLException ex) {
            JOptionPane.showMessageDialog(this.grMngr.mainView.getFrame(), this.svgF.getAbsolutePath(), "SVG parsing error", 0);
            System.err.println("Error loading SVG file.\n");
        }
    }

    static String checkOptions(String options) {
        int i = options.indexOf("-T");
        if (i != -1) {
            String res = options.substring(0, i);
            while (i < options.length() && options.charAt(i) != ' ') {
                ++i;
            }
            res = res + options.substring(i);
            return res;
        }
        return options;
    }
}

