/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.efm.execution.configuration.common.ui.page.overview;

import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.efm.execution.configuration.common.ui.api.AbstractConfigurationPage;
import org.eclipse.efm.execution.configuration.common.ui.api.AbstractConfigurationProfile;
import org.eclipse.efm.execution.configuration.common.ui.api.IWidgetToolkit;
import org.eclipse.efm.execution.configuration.common.ui.editors.BooleanFieldEditor;
import org.eclipse.efm.execution.configuration.common.ui.editors.IntegerFieldEditor;
import org.eclipse.efm.execution.configuration.common.ui.editors.table.TraceElementTableConfigProvider;
import org.eclipse.efm.execution.configuration.common.ui.editors.table.TraceElementTableViewer;
import org.eclipse.efm.execution.core.workflow.common.TraceElementKind;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;

public class OverviewBehaviorSelectionConfigurationProfile
extends AbstractConfigurationProfile {
    private TraceElementTableViewer fTraceElementTableViewer;
    private Group groupTraceSequenceOption;
    private Group groupOptionSelectionHeuristic;
    private Group groupExplorationHeuristic;
    private IntegerFieldEditor fHoJLocalHeight;
    private IntegerFieldEditor fHoJTrialLimit;
    private Group groupHitOrJumpHeuristic;
    private IntegerFieldEditor fHoJHitCount;
    private IntegerFieldEditor fHoJJumpCount;

    public OverviewBehaviorSelectionConfigurationProfile(AbstractConfigurationPage configurationPage) {
        super(configurationPage);
    }

    @Override
    public String getSectionTitle() {
        return "Behavior Selection";
    }

    @Override
    public String getSectionDescription() {
        return "Behavior Selection, configuration section";
    }

    private TraceElementTableConfigProvider getTableConfig(Font font) {
        PixelConverter pixelConverter = new PixelConverter(font);
        return new TraceElementTableConfigProvider("org.eclipse.efm.execution.core.ATTR_BEHAVIOR_ANALYSIS_ELEMENT_NAME_LIST", "// Sequence of elements (separated by newline or semicolon) \ncharacterizing the desired behavior.", "Trace Sequence", "Select a list of elements to characterize the behavior to be find.\nThe list can be a set of following elements:\n\t- transition =\"a-transition-name\"\n\t- state  =\"a-state-name\"\n\t- input  =\"an_input_port_or_signal_used_in_a_statement\"\n\t_ output =\"an_output_port_or_signal_used_in_a_statement\"\n\t_ com =\"a_com_input_or_output_port_or_signal_used_in_a_statement\"\nAll items must be separated by newline or semicolon.", true, "Nature", pixelConverter.convertWidthInCharsToPixels(16), "Element", pixelConverter.convertWidthInCharsToPixels(48), new TraceElementKind[]{TraceElementKind.TRANSITION, TraceElementKind.INPUT, TraceElementKind.OUTPUT, TraceElementKind.MACHINE, TraceElementKind.STATE, TraceElementKind.STATEMACHINE, TraceElementKind.ASSIGN, TraceElementKind.DELTA, TraceElementKind.TIME, TraceElementKind.VARIABLE, TraceElementKind.NEWFRESH, TraceElementKind.COM, TraceElementKind.INOUT, TraceElementKind.INPUT_ENV, TraceElementKind.OUTPUT_ENV, TraceElementKind.INPUT_RDV, TraceElementKind.OUTPUT_RDV, TraceElementKind.RUNNABLE, TraceElementKind.ROUTINE, TraceElementKind.CONDITION, TraceElementKind.DECISION, TraceElementKind.FORMULA}, TraceElementKind.TRANSITION);
    }

    @Override
    protected void createContent(Composite parent, IWidgetToolkit widgetToolkit) {
        parent.setToolTipText("Select a list of elements to characterize the behavior to be find.\nThe list can be a set of following elements:\n\t- transition =\"a-transition-name\"\n\t- state  =\"a-state-name\"\n\t- input  =\"an_input_port_or_signal_used_in_a_statement\"\n\t_ output =\"an_output_port_or_signal_used_in_a_statement\"\n\t_ com =\"a_com_input_or_output_port_or_signal_used_in_a_statement\"\nAll items must be separated by newline or semicolon.");
        Composite container = widgetToolkit.createComposite(parent, 2, 1, 1808);
        this.fTraceElementTableViewer = new TraceElementTableViewer(this, container, widgetToolkit, this.getTableConfig(parent.getFont()));
        this.groupOptionSelectionHeuristic = widgetToolkit.createGroup(container, "&Options && Selection Heuristic ", 1, 1, 1808);
        this.groupTraceSequenceOption = widgetToolkit.createGroup((Composite)this.groupOptionSelectionHeuristic, "&Sequence Option ", 1, 1, 1808);
        Composite compScheduler = widgetToolkit.createComposite((Composite)this.groupTraceSequenceOption, 1, 1, 768);
        BooleanFieldEditor fieldEditor = new BooleanFieldEditor(this.fConfigurationPage, "org.eclipse.efm.execution.core.ATTR_BEHAVIOR_SELECTION_HOJ_SCHEDULER_ORDERED", "&Ordered", compScheduler, true);
        fieldEditor.setToolTipText("Search ordered traces");
        this.addField(fieldEditor);
        compScheduler = widgetToolkit.createComposite((Composite)this.groupTraceSequenceOption, 1, 1, 768);
        fieldEditor = new BooleanFieldEditor(this.fConfigurationPage, "org.eclipse.efm.execution.core.ATTR_BEHAVIOR_SELECTION_HOJ_HIT_CONSECUTIVE", "&Consecutive", compScheduler, false);
        fieldEditor.setToolTipText("Search ordered traces with consecutive observables");
        this.addField(fieldEditor);
        this.groupExplorationHeuristic = widgetToolkit.createGroup((Composite)this.groupOptionSelectionHeuristic, "&Local Exploration Limit ", 1, 1, 1808);
        Composite comp = widgetToolkit.createComposite((Composite)this.groupExplorationHeuristic, 1, 1, 768);
        this.fHoJLocalHeight = new IntegerFieldEditor(this.fConfigurationPage, "org.eclipse.efm.execution.core.ATTR_BEHAVIOR_SELECTION_HOJ_JUMP_HEIGHT", "&Height :", comp, 6);
        this.fHoJLocalHeight.setToolTipText("Local exploration height before the next selection by HIT or JUMP");
        this.addField(this.fHoJLocalHeight);
        this.fHoJTrialLimit = new IntegerFieldEditor(this.fConfigurationPage, "org.eclipse.efm.execution.core.ATTR_BEHAVIOR_SELECTION_HOJ_JUMP_TRIALS_LIMIT", "&Trials :", comp, -1);
        this.fHoJTrialLimit.setToolTipText("Local exploration trials number for the Trace Sequence Coverage");
        this.addField(this.fHoJTrialLimit);
        this.groupHitOrJumpHeuristic = widgetToolkit.createGroup((Composite)this.groupOptionSelectionHeuristic, "&Hit or Jump Selection Count ", 1, 1, 1808);
        comp = widgetToolkit.createComposite((Composite)this.groupHitOrJumpHeuristic, 1, 1, 768);
        this.fHoJHitCount = new IntegerFieldEditor(this.fConfigurationPage, "org.eclipse.efm.execution.core.ATTR_BEHAVIOR_SELECTION_HOJ_HIT_COUNT", "&Hit :", comp, 1);
        this.fHoJHitCount.setToolTipText("Number of paths to choose when HIT (i.e. new properties have been covered)");
        this.addField(this.fHoJHitCount);
        this.fHoJJumpCount = new IntegerFieldEditor(this.fConfigurationPage, "org.eclipse.efm.execution.core.ATTR_BEHAVIOR_SELECTION_HOJ_JUMP_COUNT", "&Jump :", comp, 1);
        this.fHoJJumpCount.setToolTipText("Number of paths to choose when JUMP (i.e. no new property covered)");
        this.addField(this.fHoJJumpCount);
    }

    @Override
    protected void setDefaultsImpl(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.eclipse.efm.execution.core.ATTR_BEHAVIOR_SELECTION_HOJ_JUMP_HEIGHT", 6);
        configuration.setAttribute("org.eclipse.efm.execution.core.ATTR_BEHAVIOR_SELECTION_HOJ_JUMP_TRIALS_LIMIT", -1);
        configuration.setAttribute("org.eclipse.efm.execution.core.ATTR_BEHAVIOR_SELECTION_HOJ_HIT_COUNT", 1);
        configuration.setAttribute("org.eclipse.efm.execution.core.ATTR_BEHAVIOR_SELECTION_HOJ_JUMP_COUNT", 1);
        configuration.setAttribute("org.eclipse.efm.execution.core.ATTR_BEHAVIOR_ANALYSIS_ELEMENT_NAME_LIST", "// Sequence of elements (separated by newline or semicolon) \ncharacterizing the desired behavior.");
    }

    @Override
    protected void initializeFromImpl(ILaunchConfiguration configuration) {
        this.fTraceElementTableViewer.initializeFromImpl(configuration);
    }

    @Override
    protected void performApplyImpl(ILaunchConfigurationWorkingCopy configuration) {
        this.fTraceElementTableViewer.performApplyImpl(configuration);
    }

    @Override
    protected boolean isValidImpl(ILaunchConfiguration launchConfig) {
        if (!this.fTraceElementTableViewer.isValidImpl(launchConfig)) {
            return false;
        }
        if (!this.fHoJLocalHeight.isValid()) {
            this.setErrorMessage("Jump Height is not a valid integer");
            return false;
        }
        if (!this.fHoJTrialLimit.isValid()) {
            this.setErrorMessage("Jump Limit is not a valid integer");
            return false;
        }
        if (!this.fHoJHitCount.isValid()) {
            this.setErrorMessage("Hit Count is not a valid integer");
            return false;
        }
        if (!this.fHoJJumpCount.isValid()) {
            this.setErrorMessage("Jump Count is not a valid integer");
            return false;
        }
        return true;
    }
}

