/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.efm.execution.configuration.common.ui.editors.table;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.function.Predicate;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.efm.execution.configuration.common.ui.api.AbstractConfigurationProfile;
import org.eclipse.efm.execution.configuration.common.ui.api.IWidgetToolkit;
import org.eclipse.efm.execution.configuration.common.ui.editors.table.TraceElementNatureEditingSupport;
import org.eclipse.efm.execution.configuration.common.ui.editors.table.TraceElementSelectionEditingSupport;
import org.eclipse.efm.execution.configuration.common.ui.editors.table.TraceElementTableConfigProvider;
import org.eclipse.efm.execution.configuration.common.ui.editors.table.TraceElementValueEditingSupport;
import org.eclipse.efm.execution.core.workflow.common.TraceElement;
import org.eclipse.efm.execution.core.workflow.common.TraceElementCustomImpl;
import org.eclipse.efm.execution.core.workflow.common.TraceElementKind;
import org.eclipse.efm.execution.core.workflow.common.TraceSpecificationCustomImpl;
import org.eclipse.efm.ui.utils.ImageResources;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.ToolBar;

public class TraceElementTableViewer {
    private final Image IMG_CHECKED = ImageResources.getImage((String)"platform:/plugin/org.eclipse.efm.ui/resources/icons/checked.gif");
    private final Image IMG_UNCHECKED = ImageResources.getImage((String)"platform:/plugin/org.eclipse.efm.ui/resources/icons/unchecked.gif");
    private final Image IMG_ADD = ImageResources.getImage((String)"platform:/plugin/org.eclipse.efm.ui/resources/icons/elcl16/add.gif");
    private TableViewer fTableViewer;
    private final TraceElementTableConfigProvider fTableConfig;
    private int SELECTION_COLUMN_INDEX;
    private int NATURE_COLUMN_INDEX;
    private int VALUE_COLUMN_INDEX;
    protected Action fAddAction;
    protected Action fCopyAction;
    protected Action fEditAction;
    protected Action fRemoveAction;
    protected Action fClearAction;
    protected Action fMovedDownAction;
    protected Action fMovedUpAction;
    protected final AbstractConfigurationProfile fConfigurationProfile;

    public TraceElementTableViewer(AbstractConfigurationProfile configurationProfile, Composite parent, IWidgetToolkit widgetToolkit, TraceElementTableConfigProvider tableConfig) {
        this.fConfigurationProfile = configurationProfile;
        this.fTableConfig = tableConfig;
        this.createControl(parent, widgetToolkit);
    }

    public TableViewer getTableViewer() {
        return this.fTableViewer;
    }

    public TraceElementTableConfigProvider getTableConfig() {
        return this.fTableConfig;
    }

    public void setInput(TraceElement[] traceElements) {
        this.fTableViewer.setInput((Object)traceElements);
        this.addNewElementItemForDoubleClick();
    }

    public void setFocus() {
        this.fTableViewer.getControl().setFocus();
    }

    public List<TraceElement> getTraceElements() {
        ArrayList<TraceElement> traceElements = new ArrayList<TraceElement>();
        TableItem[] tableItemArray = this.fTableViewer.getTable().getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TraceElement traceElement;
            TableItem tableItem = tableItemArray[n2];
            if (tableItem.getData() instanceof TraceElement && (traceElement = (TraceElement)tableItem.getData()).getNature() != TraceElementKind.UNDEFINED) {
                traceElements.add(traceElement);
            }
            ++n2;
        }
        return traceElements;
    }

    protected void createControl(Composite parent, IWidgetToolkit widgetToolkit) {
        Font font = parent.getFont();
        Composite tableComposite = widgetToolkit.createComposite(parent, font, 1, 1, 1808, 0, 0);
        ViewForm viewForm = widgetToolkit.createViewForm(tableComposite, 0x800800);
        viewForm.setToolTipText(this.fTableConfig.TOOLTIP_TEXT);
        Composite labelContainer = widgetToolkit.createComposite((Composite)viewForm, font, 1, 1, 1808, 5, 5);
        widgetToolkit.createLabel(labelContainer, this.fTableConfig.TITLE, 1);
        viewForm.setTopLeft((Control)labelContainer);
        ToolBarManager toolBarManager = new ToolBarManager(0x800000);
        ToolBar toolBar = toolBarManager.createControl((Composite)viewForm);
        toolBar.setBackground(parent.getBackground());
        viewForm.setTopRight((Control)toolBar);
        this.createToolbarActions(toolBarManager);
        Composite viewFormContents = widgetToolkit.createComposite((Composite)viewForm, 0x800000, font, 1, 1, 1808, 5, 5);
        this.createTableViewer(viewFormContents, widgetToolkit);
        viewForm.setContent((Control)viewFormContents);
    }

    protected void createToolbarActions(ToolBarManager tmanager) {
        tmanager.add((IAction)this.getAddAction());
        tmanager.add((IAction)this.getCopyAction());
        tmanager.add((IAction)this.getEditAction());
        tmanager.add((IContributionItem)new Separator());
        tmanager.add((IAction)this.getRemoveAction());
        tmanager.add((IAction)this.getClearAction());
        tmanager.add((IContributionItem)new Separator());
        tmanager.add((IAction)this.getMovedUpAction());
        tmanager.add((IAction)this.getMovedDownAction());
        tmanager.update(true);
    }

    protected void createTableViewer(Composite tableContainer, IWidgetToolkit widgetToolkit) {
        this.fTableViewer = new TableViewer(tableContainer, 68354);
        this.createColumns(tableContainer, tableContainer.getFont());
        Table table = this.fTableViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        GridData gridData = new GridData(4, 4, true, true, 2, 1);
        this.fTableViewer.getControl().setLayoutData((Object)gridData);
        this.fTableViewer.getControl().setToolTipText(this.fTableConfig.TOOLTIP_TEXT);
        this.fTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
    }

    private boolean isSelectedColumn(EventObject event, int column) {
        if (event instanceof MouseEvent) {
            Point point;
            MouseEvent mouseEvent = (MouseEvent)event;
            Table table = this.fTableViewer.getTable();
            TableItem item = table.getItem(point = new Point(mouseEvent.x, mouseEvent.y));
            if (item == null) {
                return false;
            }
            int offset = 0;
            while (offset < table.getColumnCount()) {
                Rectangle rect = item.getBounds(offset);
                if (rect.contains(point)) {
                    return column == offset;
                }
                ++offset;
            }
        }
        return false;
    }

    private void createColumns(Composite tableComposite, Font font) {
        TableViewerColumn viewerColumn;
        this.SELECTION_COLUMN_INDEX = -1;
        this.NATURE_COLUMN_INDEX = 0;
        this.VALUE_COLUMN_INDEX = 1;
        if (this.fTableConfig.CHECKED_BOX_FOR_COLUMN_ZERO) {
            this.SELECTION_COLUMN_INDEX = 0;
            this.NATURE_COLUMN_INDEX = 1;
            this.VALUE_COLUMN_INDEX = 2;
            viewerColumn = this.createTableViewerColumn(this.fTableConfig.SELECTION_TITLE, this.fTableConfig.SELECTION_WIDTH, false, this.SELECTION_COLUMN_INDEX);
            viewerColumn.setEditingSupport((EditingSupport)new TraceElementSelectionEditingSupport(this));
            viewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

                public String getText(Object element) {
                    return null;
                }

                public Image getImage(Object element) {
                    TraceElement traceElement = (TraceElement)element;
                    switch (traceElement.getNature()) {
                        case COMMENT: {
                            return null;
                        }
                        case UNDEFINED: {
                            return TraceElementTableViewer.this.IMG_ADD;
                        }
                    }
                    if (traceElement.isSelected()) {
                        return TraceElementTableViewer.this.IMG_CHECKED;
                    }
                    return TraceElementTableViewer.this.IMG_UNCHECKED;
                }
            });
        }
        viewerColumn = this.createTableViewerColumn(this.fTableConfig.NATURE_TITLE, this.fTableConfig.NATURE_WIDTH, true, this.NATURE_COLUMN_INDEX);
        viewerColumn.setEditingSupport((EditingSupport)new TraceElementNatureEditingSupport(this));
        viewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                TraceElement traceElement = (TraceElement)element;
                switch (traceElement.getNature()) {
                    case COMMENT: {
                        return "<comment>";
                    }
                    case UNDEFINED: {
                        return "Set nature to";
                    }
                }
                return traceElement.getNature().getLiteral();
            }
        });
        viewerColumn = this.createTableViewerColumn(this.fTableConfig.VALUE_TITLE, this.fTableConfig.VALUE_WIDTH, true, this.VALUE_COLUMN_INDEX);
        viewerColumn.setEditingSupport((EditingSupport)new TraceElementValueEditingSupport(this));
        viewerColumn.setLabelProvider((CellLabelProvider)new StyledCellLabelProvider(){

            public void update(ViewerCell cell) {
                TraceElement traceElement = (TraceElement)cell.getElement();
                cell.setText(traceElement.getValue().toString());
                super.update(cell);
            }
        });
    }

    private TableViewerColumn createTableViewerColumn(String title, int bound, boolean resizable, int colNumber) {
        TableViewerColumn viewerColumn = new TableViewerColumn(this.fTableViewer, 0);
        TableColumn column = viewerColumn.getColumn();
        column.setText(title);
        column.setWidth(bound);
        column.setWidth(bound);
        column.setResizable(resizable);
        column.setMoveable(false);
        return viewerColumn;
    }

    public void addNewElementItemForDoubleClick() {
        this.fTableViewer.add((Object)new TraceElementCustomImpl(TraceElementKind.UNDEFINED, (Object)"Add new element"));
    }

    private void addNewfreshElementItem(TraceElement newTraceElement) {
        TraceElementKind nature = this.fTableConfig.DEFAULT_TRACE;
        TableItem[] tableItems = this.fTableViewer.getTable().getItems();
        int index = tableItems.length - 1;
        while (index >= 0) {
            TraceElement traceElement = (TraceElement)tableItems[index].getData();
            switch (traceElement.getNature()) {
                case UNDEFINED: 
                case COMMENT: {
                    break;
                }
                default: {
                    nature = traceElement.getNature();
                    index = -1;
                }
            }
            --index;
        }
        newTraceElement.setNature(nature);
        newTraceElement.setValue((Object)("new_" + nature.getLiteral()));
        this.addNewElementItemForDoubleClick();
        this.fTableViewer.update((Object)newTraceElement, null);
    }

    protected Action getAddAction() {
        if (this.fAddAction == null) {
            this.fAddAction = new Action(){

                public void run() {
                    TraceElementTableViewer.this.handleAddAction();
                }
            };
            this.fAddAction.setText("Add");
            this.fAddAction.setToolTipText("Add new element");
            this.fAddAction.setImageDescriptor(ImageResources.getImageDescriptor((String)"platform:/plugin/org.eclipse.efm.ui/resources/icons/elcl16/list-add.gif"));
            this.fAddAction.setDisabledImageDescriptor(ImageResources.getImageDescriptor((String)"platform:/plugin/org.eclipse.efm.ui/resources/icons/dlcl16/list-add.gif"));
        }
        return this.fAddAction;
    }

    protected void handleAddAction() {
        int selectionIndex = this.fTableViewer.getTable().getSelectionIndex();
        if (selectionIndex >= 0) {
            TraceElement selTraceElement = (TraceElement)this.fTableViewer.getTable().getItem(selectionIndex).getData();
            if (selTraceElement.getNature() != TraceElementKind.UNDEFINED) {
                selTraceElement = null;
                TableItem[] tableItemArray = this.fTableViewer.getTable().getItems();
                int n = tableItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem item = tableItemArray[n2];
                    if (((TraceElement)item.getData()).getNature() == TraceElementKind.UNDEFINED) {
                        selTraceElement = (TraceElement)item.getData();
                    }
                    ++n2;
                }
            }
            if (selTraceElement != null) {
                this.addNewfreshElementItem(selTraceElement);
            } else {
                this.fTableViewer.add((Object)new TraceElementCustomImpl(TraceElementKind.UNDEFINED, (Object)"Add new element"));
            }
        }
    }

    protected Action getCopyAction() {
        if (this.fCopyAction == null) {
            this.fCopyAction = new Action(){

                public void run() {
                    TraceElementTableViewer.this.handleCopyAction();
                }
            };
            this.fCopyAction.setText("Copy");
            this.fCopyAction.setToolTipText("Copy selected elements");
            this.fCopyAction.setImageDescriptor(ImageResources.getImageDescriptor((String)"platform:/plugin/org.eclipse.efm.ui/resources/icons/elcl16/duplicate.png"));
            this.fCopyAction.setDisabledImageDescriptor(ImageResources.getImageDescriptor((String)"platform:/plugin/org.eclipse.efm.ui/resources/icons/elcl16/duplicate.png"));
        }
        return this.fCopyAction;
    }

    protected void handleCopyAction() {
        int selectionIndex = this.fTableViewer.getTable().getSelectionIndex();
        if (selectionIndex >= 0) {
            TraceElement selTraceElement = (TraceElement)this.fTableViewer.getTable().getItem(selectionIndex).getData();
            if (selTraceElement.getNature() == TraceElementKind.UNDEFINED) {
                this.addNewfreshElementItem(selTraceElement);
            } else {
                TableItem[] tableItemArray = this.fTableViewer.getTable().getSelection();
                int n = tableItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem selection = tableItemArray[n2];
                    selTraceElement = (TraceElement)selection.getData();
                    this.fTableViewer.insert((Object)new TraceElementCustomImpl(selTraceElement), selectionIndex + 1);
                    ++n2;
                }
            }
        }
    }

    protected Action getEditAction() {
        if (this.fEditAction == null) {
            this.fEditAction = new Action(){

                public void run() {
                    TraceElementTableViewer.this.handleEditAction();
                }
            };
            this.fEditAction.setText("Edit");
            this.fEditAction.setToolTipText("Edit new element");
            this.fEditAction.setImageDescriptor(ImageResources.getImageDescriptor((String)"platform:/plugin/org.eclipse.efm.ui/resources/icons/elcl16/list-edit.gif"));
            this.fEditAction.setDisabledImageDescriptor(ImageResources.getImageDescriptor((String)"platform:/plugin/org.eclipse.efm.ui/resources/icons/dlcl16/list-edit.gif"));
            this.fEditAction.setEnabled(true);
        }
        return this.fEditAction;
    }

    protected void handleEditAction() {
        TraceElement selTraceElement;
        int selectionIndex = this.fTableViewer.getTable().getSelectionIndex();
        if (selectionIndex >= 0 && (selTraceElement = (TraceElement)this.fTableViewer.getTable().getItem(selectionIndex).getData()).getNature() != TraceElementKind.UNDEFINED) {
            this.fTableViewer.editElement((Object)selTraceElement, this.VALUE_COLUMN_INDEX);
        }
    }

    protected Action getRemoveAction() {
        if (this.fRemoveAction == null) {
            this.fRemoveAction = new Action(){

                public void run() {
                    TraceElementTableViewer.this.handleRemoveAction();
                }
            };
            this.fRemoveAction.setText("Remove");
            this.fRemoveAction.setToolTipText("Remove selected elements");
            this.fRemoveAction.setImageDescriptor(ImageResources.getImageDescriptor((String)"platform:/plugin/org.eclipse.efm.ui/resources/icons/elcl16/list-delete.gif"));
            this.fRemoveAction.setDisabledImageDescriptor(ImageResources.getImageDescriptor((String)"platform:/plugin/org.eclipse.efm.ui/resources/icons/dlcl16/list-delete.gif"));
        }
        return this.fRemoveAction;
    }

    protected void handleRemoveAction() {
        int selectionIndex = this.fTableViewer.getTable().getSelectionIndex();
        if (selectionIndex >= 0) {
            TableItem[] tableItemArray = this.fTableViewer.getTable().getSelection();
            int n = tableItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem selection = tableItemArray[n2];
                this.fTableViewer.remove(selection.getData());
                ++n2;
            }
        }
    }

    protected Action getClearAction() {
        if (this.fClearAction == null) {
            this.fClearAction = new Action(){

                public void run() {
                    TraceElementTableViewer.this.handleClearAction();
                }
            };
            this.fClearAction.setText("RemoveAll");
            this.fClearAction.setToolTipText("Remove all elements");
            this.fClearAction.setImageDescriptor(ImageResources.getImageDescriptor((String)"platform:/plugin/org.eclipse.efm.ui/resources/icons/elcl16/delete.png"));
            this.fClearAction.setDisabledImageDescriptor(ImageResources.getImageDescriptor((String)"platform:/plugin/org.eclipse.efm.ui/resources/icons/dlcl16/delete.png"));
        }
        return this.fClearAction;
    }

    protected void handleClearAction() {
        this.fTableViewer.getTable().getSelectionIndex();
        this.fTableViewer.getTable().removeAll();
        this.addNewElementItemForDoubleClick();
    }

    protected Action getMovedUpAction() {
        if (this.fMovedUpAction == null) {
            this.fMovedUpAction = new Action(){

                public void run() {
                    TraceElementTableViewer.this.handleMovedUpAction();
                }
            };
            this.fMovedUpAction.setText("MovedUp");
            this.fMovedUpAction.setToolTipText("MovedUp selected element");
            this.fMovedUpAction.setImageDescriptor(ImageResources.getImageDescriptor((String)"platform:/plugin/org.eclipse.efm.ui/resources/icons/elcl16/list-moveup.gif"));
            this.fMovedUpAction.setDisabledImageDescriptor(ImageResources.getImageDescriptor((String)"platform:/plugin/org.eclipse.efm.ui/resources/icons/dlcl16/list-moveup.gif"));
        }
        return this.fMovedUpAction;
    }

    protected void handleMovedUpAction() {
        int selectionIndex = this.fTableViewer.getTable().getSelectionIndex();
        if (selectionIndex > 0) {
            TraceElement selTraceElement = (TraceElement)this.fTableViewer.getTable().getItem(selectionIndex).getData();
            this.fTableViewer.remove((Object)selTraceElement);
            this.fTableViewer.insert((Object)selTraceElement, selectionIndex - 1);
            this.fTableViewer.getTable().setSelection(selectionIndex - 1);
        }
    }

    protected Action getMovedDownAction() {
        if (this.fMovedDownAction == null) {
            this.fMovedDownAction = new Action(){

                public void run() {
                    TraceElementTableViewer.this.handleMovedDownAction();
                }
            };
            this.fMovedDownAction.setText("MovedDown");
            this.fMovedDownAction.setToolTipText("MovedDown selected element");
            this.fMovedDownAction.setImageDescriptor(ImageResources.getImageDescriptor((String)"platform:/plugin/org.eclipse.efm.ui/resources/icons/elcl16/list-movedown.gif"));
            this.fMovedDownAction.setDisabledImageDescriptor(ImageResources.getImageDescriptor((String)"platform:/plugin/org.eclipse.efm.ui/resources/icons/dlcl16/list-movedown.gif"));
        }
        return this.fMovedDownAction;
    }

    protected void handleMovedDownAction() {
        TraceElement selTraceElement;
        int selectionIndex = this.fTableViewer.getTable().getSelectionIndex();
        if (selectionIndex >= 0 && (selTraceElement = (TraceElement)this.fTableViewer.getTable().getItem(selectionIndex).getData()).getNature() != TraceElementKind.UNDEFINED && selectionIndex < this.fTableViewer.getTable().getItemCount() - 2) {
            this.fTableViewer.remove((Object)selTraceElement);
            this.fTableViewer.insert((Object)selTraceElement, selectionIndex + 1);
            this.fTableViewer.getTable().setSelection(selectionIndex + 1);
        }
    }

    public void setDefaultsImpl(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute(this.fTableConfig.STORE_KEY, this.fTableConfig.DEFAULT_ATTRIBUTE_VALUE);
    }

    public void initializeFromImpl(ILaunchConfiguration configuration) {
        String specification;
        try {
            specification = configuration.getAttribute(this.fTableConfig.STORE_KEY, "");
        }
        catch (CoreException e) {
            e.printStackTrace();
            specification = null;
        }
        if (specification != null && !specification.isEmpty()) {
            TraceSpecificationCustomImpl traceSpecification = TraceSpecificationCustomImpl.create((String)"trace", (String)specification);
            Predicate<TraceElement> tracePredicate = te -> te.getNature() == TraceElementKind.UNDEFINED;
            traceSpecification.getElement().removeIf(tracePredicate);
            TraceElement[] traceElements = new TraceElement[]{};
            traceElements = new TraceElement[traceSpecification.getElement().size()];
            traceSpecification.getElement().toArray(traceElements);
            this.setInput(traceElements);
        }
    }

    public void performApplyImpl(ILaunchConfigurationWorkingCopy configuration) {
        TraceSpecificationCustomImpl traceSpecification = new TraceSpecificationCustomImpl(this.getTraceElements());
        String strSpecification = traceSpecification.toString();
        configuration.setAttribute(this.fTableConfig.STORE_KEY, strSpecification);
    }

    public boolean isValidImpl(ILaunchConfiguration launchConfig) {
        return true;
    }
}

