/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.efm.execution.configuration.common.ui.editors.table;

import org.eclipse.efm.execution.configuration.common.ui.editors.table.TraceElementTableConfigProvider;
import org.eclipse.efm.execution.configuration.common.ui.editors.table.TraceElementTableViewer;
import org.eclipse.efm.execution.core.workflow.common.TraceElement;
import org.eclipse.efm.execution.core.workflow.common.TraceElementKind;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Composite;

public class TraceElementNatureEditingSupport
extends EditingSupport {
    private final TraceElementTableViewer fTraceElementTableViewer;
    private final TableViewer fTableViewer;
    private final TraceElementTableConfigProvider fTableConfig;
    private final CellEditor fCellEditor;

    public TraceElementNatureEditingSupport(TraceElementTableViewer traceElementTableViewer) {
        super((ColumnViewer)traceElementTableViewer.getTableViewer());
        this.fTraceElementTableViewer = traceElementTableViewer;
        this.fTableViewer = traceElementTableViewer.getTableViewer();
        this.fTableConfig = this.fTraceElementTableViewer.getTableConfig();
        this.fCellEditor = new ComboBoxCellEditor((Composite)this.fTableViewer.getTable(), this.fTableConfig.VALID_NATURES, 8);
    }

    protected CellEditor getCellEditor(Object element) {
        return this.fCellEditor;
    }

    protected boolean canEdit(Object element) {
        return true;
    }

    protected Object getValue(Object element) {
        TraceElementKind nature = ((TraceElement)element).getNature();
        int offset = 0;
        while (offset < this.fTableConfig.VALID_TRACES.length) {
            if (this.fTableConfig.VALID_TRACES[offset].equals((Object)nature)) {
                return offset;
            }
            ++offset;
        }
        return 0;
    }

    protected void setValue(Object element, Object userInputValue) {
        int offset = (Integer)userInputValue;
        if (offset < 0 || offset >= this.fTableConfig.VALID_TRACES.length) {
            offset = 0;
        }
        TraceElement traceElement = (TraceElement)element;
        TraceElementKind previousNature = traceElement.getNature();
        traceElement.setNature(this.fTableConfig.VALID_TRACES[offset]);
        this.fTableViewer.update((Object)traceElement, null);
        if (previousNature == TraceElementKind.UNDEFINED) {
            this.fTraceElementTableViewer.addNewElementItemForDoubleClick();
        }
    }
}

