/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.efm.execution.ui.views.symbexlauncher;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.ILaunchGroup;
import org.eclipse.efm.execution.configuration.common.ui.api.AbstractConfigurationPage;
import org.eclipse.efm.execution.configuration.common.ui.api.ILaunchConfigurationGUIelement;
import org.eclipse.efm.execution.configuration.common.ui.api.IWidgetToolkit;
import org.eclipse.efm.execution.configuration.common.ui.page.debug.DebugConfigurationPage;
import org.eclipse.efm.execution.configuration.common.ui.page.developer.DeveloperTuningConfigurationPage;
import org.eclipse.efm.execution.configuration.common.ui.page.expert.ExpertConfigurationPage;
import org.eclipse.efm.execution.configuration.common.ui.page.overview.OverviewConfigurationPage;
import org.eclipse.efm.execution.configuration.common.ui.page.supervisor.SupervisorConfigurationPage;
import org.eclipse.efm.execution.configuration.common.ui.page.testgen.TestGenerationConfigurationPage;
import org.eclipse.efm.execution.configuration.common.ui.util.GenericCompositeCreator;
import org.eclipse.efm.execution.core.IWorkflowPreferenceConstants;
import org.eclipse.efm.execution.core.SymbexPreferenceUtil;
import org.eclipse.efm.execution.ui.views.symbexlauncher.AbstractSymbexWorkflowView;
import org.eclipse.efm.execution.ui.views.symbexlauncher.FormWidgetToolkit;
import org.eclipse.efm.execution.ui.views.symbexlauncher.LaunchConfigurationManager;
import org.eclipse.efm.ui.utils.ImageResources;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class SymbexWorkflowView
extends AbstractSymbexWorkflowView
implements IWorkflowPreferenceConstants {
    public static final String ID = "org.eclipse.efm.execution.ui.views.SymbexWorkflowView";
    private AbstractConfigurationPage[] fConfigurationPages;
    protected Composite tabbedCompositeMaster;
    protected CTabFolder fTabFolder;
    protected Combo fComboLaunchConfiguration;
    protected LaunchConfigurationManager launchConfigurationManager;
    private CTabItem fOverviewTabItem;
    private Composite fOverviewControl;
    private CTabItem fSupervisorTabItem;
    private Composite fSupervisorControl;
    private CTabItem fTestGenTabItem;
    private Composite fTestGenControl;
    private CTabItem fDebugTabItem;
    private Composite fDebugControl;
    private CTabItem fExpertTabItem;
    private Composite fExpertControl;
    private CTabItem fDeveloperTuningTabItem;
    private Composite fDeveloperTuningControl;
    private Action action_launch_runconf;
    private Action action_launch_debugconf;
    private Action action_opend_runconf;
    private Action action_opend_debugconf;
    private Action action_opend_help;
    private Action action_apply_changes;
    private ILaunchConfigurationWorkingCopy fLastLaunchConfigurationWorkingCopy;

    public String[] getLaunchConfigurationNames() {
        return this.launchConfigurationManager.getNames();
    }

    public void createPartControl(Composite parent) {
        this.parentComposite = parent;
        this.launchConfigurationManager = new LaunchConfigurationManager(this);
        this.makeActions();
        this.setupTopLevelActionBars(new Action[]{this.action_apply_changes, this.action_launch_runconf, this.action_launch_debugconf, this.action_opend_runconf, this.action_opend_debugconf});
        this.setupFormFrame();
        FormWidgetToolkit toolkit = this.getFormWidgetToolkit();
        this.fComboLaunchConfiguration = GenericCompositeCreator.createComposite_combo_text_from_toolkit((FormToolkit)toolkit, (Composite)this.scrollform.getBody(), (String)"Run Configuration :", (int)2);
        this.fComboLaunchConfiguration.setItems(this.launchConfigurationManager.getNames());
        this.tabbedCompositeMaster = toolkit.createComposite(this.scrollform.getBody());
        GridLayout gl = new GridLayout(1, false);
        this.tabbedCompositeMaster.setLayout((Layout)gl);
        GridData gd = new GridData(4, 4, true, true);
        this.tabbedCompositeMaster.setLayoutData((Object)gd);
        this.fTabFolder = toolkit.createTabFolder(this.tabbedCompositeMaster, 0x800080);
        this.createSectionsContent(toolkit);
        this.fComboLaunchConfiguration.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = SymbexWorkflowView.this.fComboLaunchConfiguration.getSelectionIndex();
                SymbexWorkflowView.this.launchConfigurationManager.select(index);
                SymbexWorkflowView.this.initializeFieldValuesFrom(SymbexWorkflowView.this.launchConfigurationManager.getSelection());
                if (index != -1) {
                    SymbexWorkflowView.this.launchConfigurationManager.select(index);
                }
            }
        });
        if (this.launchConfigurationManager.isPopulated()) {
            this.launchConfigurationManager.initializeSelection(0);
            this.fComboLaunchConfiguration.select(this.launchConfigurationManager.getSelectionIndex());
            this.initializeFieldValuesFrom(this.launchConfigurationManager.getSelection());
        }
    }

    public void dispose() {
        this.launchConfigurationManager.dispose();
        super.dispose();
    }

    public void refreshLaunchConfigurationsGUI() {
        int cur_index = this.fComboLaunchConfiguration.getSelectionIndex();
        String cur_name = null;
        if (cur_index != -1) {
            cur_name = this.fComboLaunchConfiguration.getItem(cur_index);
        }
        String[] contents = this.launchConfigurationManager.getNames();
        this.fComboLaunchConfiguration.setItems(contents);
        if (cur_name != null && Arrays.asList(contents).contains(cur_name)) {
            int new_index = Arrays.asList(contents).indexOf(cur_name);
            this.launchConfigurationManager.select(new_index);
            this.fComboLaunchConfiguration.select(new_index);
        } else if (this.launchConfigurationManager.isPopulated()) {
            this.launchConfigurationManager.select(0);
            this.fComboLaunchConfiguration.select(0);
        } else {
            this.fComboLaunchConfiguration.deselectAll();
            this.launchConfigurationManager.select(-1);
        }
        this.refreshGUI();
        this.scheduleUpdateJob();
    }

    public void launchConfigurationChanged(ILaunchConfiguration configuration, int index) {
        if (index >= 0) {
            this.fComboLaunchConfiguration.select(index);
            this.initializeFieldValuesFrom(configuration);
        } else {
            this.fComboLaunchConfiguration.deselectAll();
        }
    }

    private void createSectionsContent(IWidgetToolkit widgetToolkit) {
        ArrayList<AbstractConfigurationPage> confPage = new ArrayList<AbstractConfigurationPage>();
        this.createOverviewTabItem(widgetToolkit, confPage);
        this.createSupervisorTabItem(widgetToolkit, confPage);
        this.createTestGenerationTabItem(widgetToolkit, confPage);
        if (SymbexPreferenceUtil.getBooleanPreference((String)"org.eclipse.efm.execution.core.PREF_DEBUG_OPTIONS")) {
            this.createDebugTabItem(widgetToolkit, confPage);
        }
        if (SymbexPreferenceUtil.getBooleanPreference((String)"org.eclipse.efm.execution.core.PREF_EXPERT_MODE")) {
            this.createExpertTabItem(widgetToolkit, confPage);
        }
        if (SymbexPreferenceUtil.getBooleanPreference((String)"org.eclipse.efm.execution.core.PREF_SYMBEX_DEVELOPER_MODE")) {
            this.createDeveloperTuningTabItem(widgetToolkit, confPage);
        }
        this.fConfigurationPages = confPage.toArray(new AbstractConfigurationPage[confPage.size()]);
        this.fTabFolder.setSelection(this.fOverviewTabItem);
    }

    public AbstractConfigurationPage[] getConfigurationPages() {
        return this.fConfigurationPages;
    }

    private void createOverviewTabItem(IWidgetToolkit widgetToolkit, ArrayList<AbstractConfigurationPage> confPage) {
        this.fOverviewTabItem = new CTabItem(this.fTabFolder, 0);
        this.fOverviewTabItem.setText("Overview");
        ScrolledComposite scrolledComposite = widgetToolkit.createScrolledComposite((Composite)this.fTabFolder);
        OverviewConfigurationPage overviewPage = new OverviewConfigurationPage((ILaunchConfigurationGUIelement)this);
        HashMap<String, Action> firstacts = new HashMap<String, Action>();
        firstacts.put("action_apply_changes", this.action_apply_changes);
        overviewPage.setRegisteredActions(firstacts);
        overviewPage.createControl((Composite)scrolledComposite, widgetToolkit);
        this.fOverviewControl = overviewPage.getControl();
        if (this.fOverviewControl != null) {
            scrolledComposite.setContent((Control)this.fOverviewControl);
            scrolledComposite.setMinSize(this.fOverviewControl.computeSize(-1, -1));
            this.fOverviewTabItem.setControl((Control)scrolledComposite);
        }
        confPage.add((AbstractConfigurationPage)overviewPage);
    }

    private void createSupervisorTabItem(IWidgetToolkit widgetToolkit, ArrayList<AbstractConfigurationPage> confPage) {
        this.fSupervisorTabItem = new CTabItem(this.fTabFolder, 0);
        this.fSupervisorTabItem.setText("Supervisor");
        ScrolledComposite scrolledComposite = widgetToolkit.createScrolledComposite((Composite)this.fTabFolder);
        SupervisorConfigurationPage supervisorPage = new SupervisorConfigurationPage((ILaunchConfigurationGUIelement)this);
        supervisorPage.createControl((Composite)scrolledComposite, widgetToolkit);
        this.fSupervisorControl = supervisorPage.getControl();
        if (this.fSupervisorControl != null) {
            scrolledComposite.setContent((Control)this.fSupervisorControl);
            scrolledComposite.setMinSize(this.fSupervisorControl.computeSize(-1, -1));
            this.fSupervisorTabItem.setControl((Control)scrolledComposite);
        }
        confPage.add((AbstractConfigurationPage)supervisorPage);
    }

    private void createTestGenerationTabItem(IWidgetToolkit widgetToolkit, ArrayList<AbstractConfigurationPage> confPage) {
        this.fTestGenTabItem = new CTabItem(this.fTabFolder, 0);
        this.fTestGenTabItem.setText("Test Generation");
        ScrolledComposite scrolledComposite = widgetToolkit.createScrolledComposite((Composite)this.fTabFolder);
        TestGenerationConfigurationPage testGenPage = new TestGenerationConfigurationPage((ILaunchConfigurationGUIelement)this);
        testGenPage.createControl((Composite)scrolledComposite, widgetToolkit);
        this.fTestGenControl = testGenPage.getControl();
        if (this.fTestGenControl != null) {
            scrolledComposite.setContent((Control)this.fTestGenControl);
            scrolledComposite.setMinSize(this.fTestGenControl.computeSize(-1, -1));
            this.fTestGenTabItem.setControl((Control)scrolledComposite);
        }
        confPage.add((AbstractConfigurationPage)testGenPage);
    }

    private void createDebugTabItem(IWidgetToolkit widgetToolkit, ArrayList<AbstractConfigurationPage> confPage) {
        this.fDebugTabItem = new CTabItem(this.fTabFolder, 0);
        this.fDebugTabItem.setText("Debug");
        ScrolledComposite scrolledComposite = widgetToolkit.createScrolledComposite((Composite)this.fTabFolder);
        DebugConfigurationPage devugPage = new DebugConfigurationPage((ILaunchConfigurationGUIelement)this);
        devugPage.createControl((Composite)scrolledComposite, widgetToolkit);
        this.fDebugControl = devugPage.getControl();
        if (this.fDebugControl != null) {
            scrolledComposite.setContent((Control)this.fDebugControl);
            scrolledComposite.setMinSize(this.fSupervisorControl.computeSize(-1, -1));
            this.fDebugTabItem.setControl((Control)scrolledComposite);
        }
        confPage.add((AbstractConfigurationPage)devugPage);
    }

    private void createExpertTabItem(IWidgetToolkit widgetToolkit, ArrayList<AbstractConfigurationPage> confPage) {
        this.fExpertTabItem = new CTabItem(this.fTabFolder, 0);
        this.fExpertTabItem.setText("Expert");
        ScrolledComposite scrolledComposite = widgetToolkit.createScrolledComposite((Composite)this.fTabFolder);
        ExpertConfigurationPage expertPage = new ExpertConfigurationPage((ILaunchConfigurationGUIelement)this);
        expertPage.createControl((Composite)scrolledComposite, widgetToolkit);
        this.fExpertControl = expertPage.getControl();
        if (this.fExpertControl != null) {
            scrolledComposite.setContent((Control)this.fExpertControl);
            scrolledComposite.setMinSize(this.fExpertControl.computeSize(-1, -1));
            this.fExpertTabItem.setControl((Control)scrolledComposite);
        }
        confPage.add((AbstractConfigurationPage)expertPage);
    }

    private void createDeveloperTuningTabItem(IWidgetToolkit widgetToolkit, ArrayList<AbstractConfigurationPage> confPage) {
        this.fDeveloperTuningTabItem = new CTabItem(this.fTabFolder, 0);
        this.fDeveloperTuningTabItem.setText("Developer");
        ScrolledComposite scrolledComposite = widgetToolkit.createScrolledComposite((Composite)this.fTabFolder);
        DeveloperTuningConfigurationPage developerPage = new DeveloperTuningConfigurationPage((ILaunchConfigurationGUIelement)this);
        developerPage.createControl((Composite)scrolledComposite, widgetToolkit);
        this.fDeveloperTuningControl = developerPage.getControl();
        if (this.fDeveloperTuningControl != null) {
            scrolledComposite.setContent((Control)this.fDeveloperTuningControl);
            scrolledComposite.setMinSize(this.fSupervisorControl.computeSize(-1, -1));
            this.fDeveloperTuningTabItem.setControl((Control)scrolledComposite);
        }
        confPage.add((AbstractConfigurationPage)developerPage);
    }

    private void updateEnableTab(boolean isLaunchConfSelected) {
        this.fOverviewControl.setEnabled(isLaunchConfSelected);
    }

    private void execLaunchConfiguration(ILaunchConfiguration configuration, String mode) {
        this.saveLaunchConfiguration(configuration);
        DebugUITools.launch((ILaunchConfiguration)configuration, (String)mode);
    }

    private void openLaunchConfigurationDialog(ILaunchConfiguration configuration, String mode) {
        this.saveLaunchConfiguration(configuration);
        StructuredSelection selection = new StructuredSelection((Object)configuration);
        ILaunchGroup group = DebugUITools.getLaunchGroup((ILaunchConfiguration)configuration, (String)mode);
        String groupIdentifier = group == null ? "org.eclipse.debug.ui.launchGroup.run" : group.getIdentifier();
        DebugUITools.openLaunchConfigurationDialogOnGroup((Shell)this.scrollform.getShell(), (IStructuredSelection)selection, (String)groupIdentifier, null);
    }

    private void saveLaunchConfiguration(ILaunchConfiguration configuration) {
        try {
            ILaunchConfigurationWorkingCopy rwConfiguration = configuration.getWorkingCopy();
            SymbexPreferenceUtil.setPreference((String)"org.eclipse.efm.execution.core.PREF_LAUNCH_CONFIGURATION_SELECTION", (String)this.launchConfigurationManager.getSelection().getName());
            AbstractConfigurationPage[] abstractConfigurationPageArray = this.fConfigurationPages;
            int n = this.fConfigurationPages.length;
            int n2 = 0;
            while (n2 < n) {
                AbstractConfigurationPage acm = abstractConfigurationPageArray[n2];
                acm.applyUpdatesOnFieldValuesFrom(rwConfiguration);
                ++n2;
            }
            rwConfiguration.doSave();
            if (this.action_apply_changes != null) {
                this.action_apply_changes.setEnabled(false);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    private void makeActions() {
        this.action_apply_changes = new Action(){

            public void run() {
                if (SymbexWorkflowView.this.launchConfigurationManager.hasSelection()) {
                    SymbexWorkflowView.this.saveLaunchConfiguration(SymbexWorkflowView.this.launchConfigurationManager.getSelection());
                }
            }
        };
        this.action_apply_changes.setText("Apply changes on Launch Configuration");
        this.action_apply_changes.setToolTipText("Apply changes on Launch Configuration");
        this.action_apply_changes.setImageDescriptor(ImageResources.getImageDescriptor((String)"platform:/plugin/org.eclipse.efm.ui/resources/icons/save.gif"));
        this.action_apply_changes.setEnabled(false);
        this.action_launch_runconf = new Action(){

            public void run() {
                if (SymbexWorkflowView.this.launchConfigurationManager.hasSelection()) {
                    SymbexWorkflowView.this.execLaunchConfiguration(SymbexWorkflowView.this.launchConfigurationManager.getSelection(), "run");
                } else {
                    SymbexWorkflowView.this.showMessage("No Launch Configuration selected");
                }
            }
        };
        this.action_launch_runconf.setText("Launch Run Configuration");
        this.action_launch_runconf.setToolTipText("Launch Selected Run Configuration");
        this.action_launch_runconf.setImageDescriptor(ImageResources.getImageDescriptor((String)"platform:/plugin/org.eclipse.efm.ui/resources/icons/run_exc.png"));
        this.action_launch_debugconf = new Action(){

            public void run() {
                if (SymbexWorkflowView.this.launchConfigurationManager.hasSelection()) {
                    SymbexWorkflowView.this.execLaunchConfiguration(SymbexWorkflowView.this.launchConfigurationManager.getSelection(), "debug");
                } else {
                    SymbexWorkflowView.this.showMessage("No Launch Configuration selected");
                }
            }
        };
        this.action_launch_debugconf.setText("Launch Debug Configuration");
        this.action_launch_debugconf.setToolTipText("Launch Selected Debug Configuration");
        this.action_launch_debugconf.setImageDescriptor(ImageResources.getImageDescriptor((String)"platform:/plugin/org.eclipse.efm.ui/resources/icons/debug_exc.png"));
        this.action_opend_runconf = new Action(){

            public void run() {
                if (SymbexWorkflowView.this.launchConfigurationManager.hasSelection()) {
                    SymbexWorkflowView.this.openLaunchConfigurationDialog(SymbexWorkflowView.this.launchConfigurationManager.getSelection(), "run");
                } else {
                    SymbexWorkflowView.this.showMessage("No Launch Configuration selected");
                }
            }
        };
        this.action_opend_runconf.setText("Open Run Configurations...");
        this.action_opend_runconf.setToolTipText("Open the Run Configurations Dialog");
        this.action_opend_runconf.setImageDescriptor(ImageResources.getImageDescriptor((String)"platform:/plugin/org.eclipse.efm.ui/resources/icons/run_dial.png"));
        this.action_opend_debugconf = new Action(){

            public void run() {
                if (SymbexWorkflowView.this.launchConfigurationManager.hasSelection()) {
                    SymbexWorkflowView.this.openLaunchConfigurationDialog(SymbexWorkflowView.this.launchConfigurationManager.getSelection(), "debug");
                } else {
                    SymbexWorkflowView.this.showMessage("No Launch Configuration selected");
                }
            }
        };
        this.action_opend_debugconf.setText("Open Debug Configuration...");
        this.action_opend_debugconf.setToolTipText("Open the Debug Configuration Dialog");
        this.action_opend_debugconf.setImageDescriptor(ImageResources.getImageDescriptor((String)"platform:/plugin/org.eclipse.efm.ui/resources/icons/debug_dial.png"));
        this.action_opend_help = new Action(){

            public void run() {
            }
        };
        this.action_opend_help.setText("Open Diversity Help");
        this.action_opend_help.setToolTipText("Open the Diversity Help");
        this.action_opend_help.setImageDescriptor(ImageResources.getImageDescriptor((String)"platform:/plugin/org.eclipse.efm.ui/resources/icons/help.png"));
    }

    public void initializeFieldValuesFrom(ILaunchConfiguration configuration) {
        AbstractConfigurationPage[] abstractConfigurationPageArray = this.fConfigurationPages;
        int n = this.fConfigurationPages.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractConfigurationPage acm = abstractConfigurationPageArray[n2];
            acm.initializeFieldValuesFrom(configuration);
            ++n2;
        }
        this.scheduleUpdateJob();
    }

    public void refreshGUI() {
        if (this.launchConfigurationManager.hasSelection()) {
            ILaunchConfiguration selectedLC = this.launchConfigurationManager.getSelection();
            this.updateEnableTab(true);
            if (this.action_apply_changes != null) {
                this.action_apply_changes.setEnabled(true);
            }
            try {
                ILaunchConfigurationWorkingCopy newcopy = selectedLC.getWorkingCopy();
                if (this.fLastLaunchConfigurationWorkingCopy == null || !this.fLastLaunchConfigurationWorkingCopy.contentsEqual((ILaunchConfiguration)newcopy)) {
                    this.fLastLaunchConfigurationWorkingCopy = newcopy;
                    System.err.println("++++---- Biopp");
                    AbstractConfigurationPage[] abstractConfigurationPageArray = this.fConfigurationPages;
                    int n = this.fConfigurationPages.length;
                    int n2 = 0;
                    while (n2 < n) {
                        AbstractConfigurationPage acm = abstractConfigurationPageArray[n2];
                        acm.initializeFieldValuesFrom(selectedLC);
                        ++n2;
                    }
                }
            }
            catch (CoreException e) {
                this.setErrorMessage("could not get launch configuration working copy");
                e.printStackTrace();
            }
        } else {
            this.fTabFolder.setSelection(this.fOverviewTabItem);
            this.updateEnableTab(false);
        }
    }

    public void updateGUI() {
        this.refreshGUI();
    }

    public void scheduleUpdateJob() {
        this.scrollform.reflow(true);
        this.tabbedCompositeMaster.layout();
        this.fTabFolder.layout();
        this.tabbedCompositeMaster.layout();
        this.scrollform.reflow(true);
    }

    @Override
    public void setWarningMessage(String warningMessage) {
        CTabItem selectedTabItem = this.fTabFolder.getSelection();
        if (selectedTabItem != null) {
            if (warningMessage != null) {
                selectedTabItem.setToolTipText(warningMessage);
                selectedTabItem.setImage(ImageResources.getImage((String)"platform:/plugin/org.eclipse.efm.ui/resources/icons/warning_st_obj.png"));
            } else {
                selectedTabItem.setImage(null);
            }
        }
        super.setWarningMessage(warningMessage);
    }

    @Override
    public void setErrorMessage(String errorMessage) {
        CTabItem selectedTabItem = this.fTabFolder.getSelection();
        if (selectedTabItem != null) {
            if (errorMessage != null) {
                selectedTabItem.setToolTipText(errorMessage);
                selectedTabItem.setImage(ImageResources.getImage((String)"platform:/plugin/org.eclipse.efm.ui/resources/icons/error_st_obj.gif"));
            } else {
                selectedTabItem.setImage(null);
            }
        }
        super.setErrorMessage(errorMessage);
    }
}

