/*
 * Decompiled with CFR 0.152.
 */
package net.claribole.zgrviewer;

import fr.inria.zvtm.engine.VirtualSpace;
import fr.inria.zvtm.glyphs.ClosedShape;
import fr.inria.zvtm.glyphs.Glyph;
import fr.inria.zvtm.glyphs.RectangularShape;
import fr.inria.zvtm.svg.Metadata;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import net.claribole.zgrviewer.LEdge;
import net.claribole.zgrviewer.LElem;
import net.claribole.zgrviewer.LGraph;
import net.claribole.zgrviewer.LNode;

public class LogicalStructure {
    static final String GRAPH_PREFIX = "graph";
    static final String NODE_PREFIX = "node";
    static final String EDGE_PREFIX = "edge";
    LGraph[] graphs;
    LNode[] nodes;
    LEdge[] edges;

    public static LogicalStructure build(Vector glyphs, VirtualSpace mSpace) {
        Hashtable<String, Vector> title2node = new Hashtable<String, Vector>();
        Hashtable title2edgeGroup = new Hashtable();
        Hashtable<String, Vector> title2graph = new Hashtable<String, Vector>();
        int edgeCount = 0;
        for (int i = 0; i < glyphs.size(); ++i) {
            Vector v;
            String title;
            Glyph g = (Glyph)glyphs.elementAt(i);
            Metadata md = (Metadata)g.getOwner();
            if (md == null || (title = md.getTitle()) == null) continue;
            String cagid = md.getClosestAncestorGroupID();
            String cgac = md.getClosestAncestorGroupClass();
            if (cgac.equals(EDGE_PREFIX) || cagid.startsWith(EDGE_PREFIX)) {
                Hashtable<String, Vector> t;
                if (title2edgeGroup.containsKey(title)) {
                    t = (Hashtable<String, Vector>)title2edgeGroup.get(title);
                    if (t.containsKey(cagid)) {
                        v = (Vector)t.get(cagid);
                        v.add(g);
                        continue;
                    }
                    v = new Vector();
                    v.add(g);
                    t.put(cagid, v);
                    ++edgeCount;
                    continue;
                }
                v = new Vector();
                v.add(g);
                t = new Hashtable<String, Vector>(3);
                t.put(cagid, v);
                title2edgeGroup.put(title, t);
                ++edgeCount;
                continue;
            }
            if (cgac.equals(NODE_PREFIX) || cagid.startsWith(NODE_PREFIX)) {
                if (title2node.containsKey(title)) {
                    v = (Vector)title2node.get(title);
                    v.add(g);
                    continue;
                }
                v = new Vector();
                v.add(g);
                title2node.put(title, v);
                continue;
            }
            if (!cagid.startsWith(GRAPH_PREFIX) && !cgac.equals(GRAPH_PREFIX)) continue;
            if (title2graph.containsKey(title)) {
                v = (Vector)title2graph.get(title);
                v.add(g);
                continue;
            }
            v = new Vector();
            v.add(g);
            title2graph.put(title, v);
        }
        LogicalStructure res = new LogicalStructure(title2node, title2edgeGroup, edgeCount, title2graph, mSpace);
        title2edgeGroup.clear();
        title2node.clear();
        title2graph.clear();
        return res.isEmpty() ? null : res;
    }

    LogicalStructure(Hashtable title2node, Hashtable title2edgeGroup, int edgeCount, Hashtable title2graph, VirtualSpace mSpace) {
        String title;
        this.nodes = new LNode[title2node.size()];
        int i = 0;
        Enumeration e = title2node.keys();
        while (e.hasMoreElements()) {
            title = (String)e.nextElement();
            this.nodes[i] = new LNode(title, (Vector)title2node.get(title));
            ++i;
        }
        i = 0;
        this.edges = new LEdge[edgeCount];
        Enumeration e2 = title2edgeGroup.keys();
        while (e2.hasMoreElements()) {
            title = (String)e2.nextElement();
            Hashtable group2edge = (Hashtable)title2edgeGroup.get(title);
            Enumeration e22 = group2edge.elements();
            while (e22.hasMoreElements()) {
                this.edges[i] = new LEdge(title, (Vector)e22.nextElement());
                ++i;
            }
        }
        for (int j = 0; j < this.edges.length; ++j) {
            int id = this.edges[j].title.indexOf("->");
            if (id != -1) {
                this.edges[j].setDirected(true);
                this.edges[j].setTail(this.getNode(this.edges[j].title.substring(0, id)));
                this.edges[j].setHead(this.getNode(this.edges[j].title.substring(id + 2)));
                continue;
            }
            id = this.edges[j].title.indexOf("--");
            if (id == -1) continue;
            this.edges[j].setDirected(false);
            this.edges[j].setTail(this.getNode(this.edges[j].title.substring(0, id)));
            this.edges[j].setHead(this.getNode(this.edges[j].title.substring(id + 2)));
        }
        this.graphs = new LGraph[title2graph.size()];
        i = 0;
        Enumeration e3 = title2graph.keys();
        while (e3.hasMoreElements()) {
            title = (String)e3.nextElement();
            this.graphs[i] = new LGraph(title, (Vector)title2graph.get(title), mSpace);
            ++i;
        }
        for (LGraph graph : this.graphs) {
            ClosedShape graphBox_g = null;
            RectangularShape graphBox_rs = null;
            if (graph.getBoxType() != 0) {
                graphBox_g = graph.getBox();
                graphBox_rs = (RectangularShape)((Object)graphBox_g);
            }
            if (graphBox_g == null) continue;
            for (LNode lNode : this.nodes) {
                ClosedShape nodeShape = lNode.getShape();
                if (nodeShape.vx < graphBox_g.vx - graphBox_rs.getWidth() / 2.0 || nodeShape.vx > graphBox_g.vx + graphBox_rs.getWidth() / 2.0 || nodeShape.vy < graphBox_g.vy - graphBox_rs.getHeight() / 2.0 || nodeShape.vy > graphBox_g.vy + graphBox_rs.getHeight() / 2.0) continue;
                graph.addChildNode(lNode);
            }
        }
        for (LGraph graphA : this.graphs) {
            if (graphA.getBoxType() == 0) continue;
            ClosedShape graphABox_g = graphA.getBox();
            RectangularShape graphABox_rs = (RectangularShape)((Object)graphABox_g);
            for (LElem lElem : this.graphs) {
                if (graphA == lElem || ((LGraph)lElem).getBoxType() == 0) continue;
                ClosedShape graphBBox_g = ((LGraph)lElem).getBox();
                RectangularShape graphBBox_rs = (RectangularShape)((Object)graphBBox_g);
                if (graphABox_g.vx - graphABox_rs.getWidth() / 2.0 < graphBBox_g.vx - graphBBox_rs.getWidth() / 2.0 || graphABox_g.vx + graphABox_rs.getWidth() / 2.0 > graphBBox_g.vx + graphBBox_rs.getWidth() / 2.0 || graphABox_g.vy - graphABox_rs.getHeight() / 2.0 < graphBBox_g.vy - graphBBox_rs.getHeight() / 2.0 || graphABox_g.vy + graphABox_rs.getHeight() / 2.0 > graphBBox_g.vy + graphBBox_rs.getHeight() / 2.0) continue;
                ((LGraph)lElem).addSubgraph(graphA);
            }
        }
    }

    public void addEdge(LEdge e) {
        LEdge[] nedges = new LEdge[this.edges.length + 1];
        System.arraycopy(this.edges, 0, nedges, 0, this.edges.length);
        nedges[this.edges.length] = e;
        this.edges = nedges;
    }

    public void removeEdge(LEdge e) {
        int index = -1;
        for (int i = 0; i < this.edges.length; ++i) {
            if (this.edges[i] != e) continue;
            index = i;
            break;
        }
        if (index != -1) {
            LEdge[] nedges = new LEdge[this.edges.length - 1];
            System.arraycopy(this.edges, 0, nedges, 0, index);
            System.arraycopy(this.edges, index + 1, nedges, index, this.edges.length - index - 1);
            this.edges = nedges;
        }
        e.tail.removeArc(e);
        e.head.removeArc(e);
    }

    public LNode[] getAllNodes() {
        return this.nodes;
    }

    public LEdge[] getAllEdges() {
        return this.edges;
    }

    public LGraph[] getAllGraphs() {
        return this.graphs;
    }

    public HashMap getGraphMap() {
        HashMap<String, LGraph> res = new HashMap<String, LGraph>(this.graphs.length);
        for (LGraph g : this.graphs) {
            res.put(g.getTitle(), g);
        }
        return res;
    }

    public LNode getNode(String title) {
        int i;
        Object res = null;
        for (i = 0; i < this.nodes.length; ++i) {
            if (!this.nodes[i].title.equals(title)) continue;
            return this.nodes[i];
        }
        if (title.indexOf(":") != -1) {
            title = title.substring(0, title.indexOf(":"));
            for (i = 0; i < this.nodes.length; ++i) {
                if (!this.nodes[i].title.equals(title)) continue;
                return this.nodes[i];
            }
        }
        return null;
    }

    boolean isEmpty() {
        return this.nodes.length == 0 || this.edges.length == 0;
    }

    public String toString() {
        int i;
        String res = "";
        for (i = 0; i < this.nodes.length; ++i) {
            res = res + this.nodes[i].toString() + "\n";
        }
        for (i = 0; i < this.edges.length; ++i) {
            res = res + this.edges[i].toString() + "\n";
        }
        return res;
    }

    public static LNode getNode(Glyph g) {
        Object o;
        Object v0 = o = g != null ? g.getOwner() : null;
        if (o != null) {
            return o instanceof LNode ? (LNode)o : null;
        }
        return null;
    }

    public static LEdge getEdge(Glyph g) {
        Object o;
        Object v0 = o = g != null ? g.getOwner() : null;
        if (o != null) {
            return o instanceof LEdge ? (LEdge)o : null;
        }
        return null;
    }
}

