/*
 * Decompiled with CFR 0.152.
 */
package net.claribole.zgrviewer;

import fr.inria.zvtm.engine.VirtualSpace;
import fr.inria.zvtm.glyphs.ClosedShape;
import fr.inria.zvtm.glyphs.DPath;
import fr.inria.zvtm.glyphs.Glyph;
import fr.inria.zvtm.glyphs.VRectangle;
import fr.inria.zvtm.glyphs.VRoundRect;
import fr.inria.zvtm.glyphs.VSegment;
import fr.inria.zvtm.glyphs.VText;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.util.Vector;
import net.claribole.zgrviewer.LElem;
import net.claribole.zgrviewer.LNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LGraph
extends LElem {
    public static final short BOX_TYPE_NONE = 0;
    public static final short BOX_TYPE_RECT = 1;
    public static final short BOX_TYPE_ROUND_RECT = 2;
    Vector<LNode> nodes = new Vector(1);
    Vector<LGraph> subgraphs = new Vector(1);

    LGraph(String title, Vector<Glyph> gls, VirtualSpace mSpace) {
        this.title = title;
        VRoundRect aRoundedBoxIndeed = null;
        if (gls.size() == 8 && (gls.firstElement() instanceof VSegment || gls.firstElement() instanceof DPath)) {
            aRoundedBoxIndeed = this.attemptRoundedBoxReconstruction(gls);
            this.glyphs = new Glyph[]{aRoundedBoxIndeed};
            mSpace.addGlyph(aRoundedBoxIndeed);
            mSpace.above(aRoundedBoxIndeed, gls.lastElement());
            aRoundedBoxIndeed.setOwner(this);
            for (Glyph g : gls) {
                mSpace.removeGlyph(g);
            }
        }
        if (aRoundedBoxIndeed == null) {
            this.glyphs = new Glyph[gls.size()];
            for (int i = 0; i < this.glyphs.length; ++i) {
                this.glyphs[i] = gls.elementAt(i);
                this.glyphs[i].setOwner(this);
            }
        }
    }

    VRoundRect attemptRoundedBoxReconstruction(Vector<Glyph> gls) {
        Vector<VSegment> sides = new Vector<VSegment>(4);
        Vector<Glyph> corners = new Vector<Glyph>(4);
        for (Glyph gl : gls) {
            if (gl instanceof DPath) {
                corners.add(gl);
                continue;
            }
            if (!(gl instanceof VSegment)) continue;
            sides.add((VSegment)gl);
        }
        if (sides.size() == 4 && corners.size() == 4) {
            try {
                VSegment westSide = (VSegment)sides.firstElement();
                VSegment eastSide = (VSegment)sides.firstElement();
                VSegment northSide = (VSegment)sides.firstElement();
                VSegment southSide = (VSegment)sides.firstElement();
                for (int i = 1; i < sides.size(); ++i) {
                    VSegment candidateSide = (VSegment)sides.elementAt(i);
                    if (candidateSide.vx < westSide.vx) {
                        westSide = candidateSide;
                    }
                    if (candidateSide.vx > eastSide.vx) {
                        eastSide = candidateSide;
                    }
                    if (candidateSide.vy > northSide.vy) {
                        northSide = candidateSide;
                    }
                    if (!(candidateSide.vy < southSide.vy)) continue;
                    southSide = candidateSide;
                }
                Point2D.Double[] nsep = northSide.getEndPoints();
                double cornerRadius = 2.0 * (eastSide.vx - Math.max(nsep[0].x, nsep[1].x));
                VRoundRect ng = new VRoundRect((westSide.vx + eastSide.vx) / 2.0, (northSide.vy + southSide.vy) / 2.0, 0, eastSide.vx - westSide.vx, northSide.vy - southSide.vy, Color.WHITE, westSide.getColor(), 1.0f, cornerRadius, cornerRadius);
                ng.setFilled(false);
                ng.setStroke(westSide.getStroke());
                return ng;
            }
            catch (Exception ex) {
                System.err.println("ZGRViewer: WARNING: attempt at constructing rounded subgraph box failed for " + this.title);
                return null;
            }
        }
        return null;
    }

    public short getBoxType() {
        for (Glyph g : this.glyphs) {
            if (g instanceof VRoundRect) {
                return 2;
            }
            if (!(g instanceof VRectangle)) continue;
            return 1;
        }
        return 0;
    }

    @Override
    public Glyph[] getGlyphs() {
        return this.glyphs;
    }

    public ClosedShape getBox() {
        ClosedShape res = null;
        for (Glyph g : this.glyphs) {
            if (!(g instanceof ClosedShape) || res != null && !(g.getSize() > res.getSize())) continue;
            res = (ClosedShape)g;
        }
        return res;
    }

    public VText[] getLabels() {
        Vector<VText> labels = new Vector<VText>(2);
        for (Glyph g : this.glyphs) {
            if (!(g instanceof VText)) continue;
            labels.add((VText)g);
        }
        return labels.toArray(new VText[labels.size()]);
    }

    public void addChildNode(LNode n) {
        if (!this.nodes.contains(n)) {
            this.nodes.add(n);
        }
    }

    public LNode[] getChildNodes() {
        return this.nodes.toArray(new LNode[this.nodes.size()]);
    }

    public String toString() {
        String res = "subgraph " + this.title + " - subgraphs[";
        for (LGraph subgraph : this.subgraphs) {
            res = res + subgraph.getTitle() + ", ";
        }
        res = res + "] - nodes[";
        for (LNode node : this.nodes) {
            res = res + node.getTitle() + ", ";
        }
        res = res + "]";
        return res;
    }

    public void addSubgraph(LGraph g) {
        if (!this.subgraphs.contains(g)) {
            this.subgraphs.add(g);
        }
    }

    public LGraph[] getSubgraphs() {
        return this.subgraphs.toArray(new LGraph[this.subgraphs.size()]);
    }
}

