/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.efm.execution.configuration.common.ui.page.overview;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.efm.execution.configuration.common.ui.api.AbstractConfigurationPage;
import org.eclipse.efm.execution.configuration.common.ui.api.AbstractConfigurationProfile;
import org.eclipse.efm.execution.configuration.common.ui.api.IWidgetToolkit;
import org.eclipse.efm.execution.configuration.common.ui.editors.BooleanFieldEditor;
import org.eclipse.efm.execution.core.workflow.common.GraphExplorationStrategyKind;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;

public class OverviewExplorationConfigurationProfile
extends AbstractConfigurationProfile {
    private Group groupAnalyzeStrategy;
    private Button fBFSButton = null;
    private Button fDFSButton = null;
    private Button fRFSButton = null;
    private Button fALLButton = null;
    private GraphExplorationStrategyKind fAnalyzeStrategy = GraphExplorationStrategyKind.BREADTH_FIRST_SEARCH;
    private Group fGroupInclusionCriterion;
    private BooleanFieldEditor fApplyInclusionBooleanField;
    private Composite fLoopDetectionTrivialComposite;
    private TabListener fListener = new TabListener();

    public OverviewExplorationConfigurationProfile(AbstractConfigurationPage configurationPage) {
        super(configurationPage);
    }

    @Override
    public String getSectionTitle() {
        return "Model Exploration";
    }

    @Override
    public String getSectionDescription() {
        return "Choose an exploration strategy and set a limitation in Supervisor Tab";
    }

    public void handleBFSButtonSelected() {
        if (this.fBFSButton.getSelection()) {
            this.fAnalyzeStrategy = GraphExplorationStrategyKind.BREADTH_FIRST_SEARCH;
        }
        this.fConfigurationPage.propagateGUIupdate();
    }

    public void handleDFSButtonSelected() {
        if (this.fDFSButton.getSelection()) {
            this.fAnalyzeStrategy = GraphExplorationStrategyKind.DEPTH_FIRST_SEARCH;
        }
        this.fConfigurationPage.propagateGUIupdate();
    }

    public void handleRFSButtonSelected() {
        if (this.fRFSButton.getSelection()) {
            this.fAnalyzeStrategy = GraphExplorationStrategyKind.RANDOM_FIRST_SEARCH;
        }
        this.fConfigurationPage.propagateGUIupdate();
    }

    public void handleALLButtonSelected() {
        if (this.fALLButton.getSelection()) {
            this.fAnalyzeStrategy = GraphExplorationStrategyKind.ALL;
        }
        this.fConfigurationPage.propagateGUIupdate();
    }

    @Override
    protected void createContent(Composite parent, IWidgetToolkit widgetToolkit) {
        this.createAnalyzeStrategy(parent, widgetToolkit);
        this.createControlInclusionCriterion(parent, widgetToolkit);
    }

    private void createControlInclusionCriterion(Composite parent, IWidgetToolkit widgetToolkit) {
        this.fGroupInclusionCriterion = widgetToolkit.createGroup(parent, "Inclusion Criterion", 1, 2, 768);
        Composite comp = widgetToolkit.createComposite((Composite)this.fGroupInclusionCriterion, 2, 1, 768);
        this.fApplyInclusionBooleanField = new BooleanFieldEditor(this.fConfigurationPage, "org.eclipse.efm.execution.core.ATTR_ENABLED_REDUNDANCY_INCLUSION_CRITERION", "&Apply Inclusion", comp, false);
        this.addField(this.fApplyInclusionBooleanField);
        this.fLoopDetectionTrivialComposite = widgetToolkit.createComposite((Composite)this.fGroupInclusionCriterion, 2, 1, 768);
        BooleanFieldEditor loopDetectionTrivialBooleanField = new BooleanFieldEditor(this.fConfigurationPage, "org.eclipse.efm.execution.core.ATTR_ENABLED_REDUNDANCY_LOOP_DETECTION_TRIVIAL", "&Loop Detection Trivial", this.fLoopDetectionTrivialComposite, false);
        this.addField(loopDetectionTrivialBooleanField);
        this.fApplyInclusionBooleanField.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OverviewExplorationConfigurationProfile.this.handleEnablingRedundancyDetection();
            }
        });
    }

    private void handleEnablingRedundancyDetection() {
        this.fConfigurationPage.setVisibleAndEnabled(this.fLoopDetectionTrivialComposite, !this.fApplyInclusionBooleanField.getBooleanValue());
    }

    protected void createAnalyzeStrategy(Composite parent, IWidgetToolkit widgetToolkit) {
        this.groupAnalyzeStrategy = widgetToolkit.createGroup(parent, "&Analyze Strategy", 4, 1, 768);
        this.fBFSButton = widgetToolkit.createRadioButton((Composite)this.groupAnalyzeStrategy, "&BFS");
        this.fBFSButton.addSelectionListener((SelectionListener)this.fListener);
        this.fBFSButton.setToolTipText("Breadth First Search");
        this.fDFSButton = widgetToolkit.createRadioButton((Composite)this.groupAnalyzeStrategy, "&DFS");
        this.fDFSButton.addSelectionListener((SelectionListener)this.fListener);
        this.fDFSButton.setToolTipText("Depth First Search");
        this.fRFSButton = widgetToolkit.createRadioButton((Composite)this.groupAnalyzeStrategy, "&RFS");
        this.fRFSButton.addSelectionListener((SelectionListener)this.fListener);
        this.fRFSButton.setToolTipText("Random First Search");
        this.fALLButton = widgetToolkit.createRadioButton((Composite)this.groupAnalyzeStrategy, "&ALL");
        this.fALLButton.addSelectionListener((SelectionListener)this.fListener);
        this.fALLButton.setToolTipText("SEARCH IN ALL");
    }

    @Override
    protected void setDefaultsImpl(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.eclipse.efm.execution.core.ATTR_SPECIFICATION_ANALYZE_STRATEGY", GraphExplorationStrategyKind.BREADTH_FIRST_SEARCH.getLiteral());
        configuration.setAttribute("org.eclipse.efm.execution.core.ATTR_ENABLED_REDUNDANCY_INCLUSION_CRITERION", false);
        configuration.setAttribute("org.eclipse.efm.execution.core.ATTR_ENABLED_REDUNDANCY_LOOP_DETECTION_TRIVIAL", true);
    }

    @Override
    protected void initializeFromImpl(ILaunchConfiguration configuration) {
        block8: {
            GraphExplorationStrategyKind oldAnalyzeStrategy = this.fAnalyzeStrategy;
            try {
                try {
                    this.fAnalyzeStrategy = GraphExplorationStrategyKind.get((String)configuration.getAttribute("org.eclipse.efm.execution.core.ATTR_SPECIFICATION_ANALYZE_STRATEGY", GraphExplorationStrategyKind.BREADTH_FIRST_SEARCH.getLiteral()));
                }
                catch (CoreException e) {
                    e.printStackTrace();
                    if (this.fAnalyzeStrategy == null) {
                        this.fAnalyzeStrategy = oldAnalyzeStrategy != null ? oldAnalyzeStrategy : GraphExplorationStrategyKind.BREADTH_FIRST_SEARCH;
                    }
                    break block8;
                }
            }
            catch (Throwable throwable) {
                if (this.fAnalyzeStrategy == null) {
                    this.fAnalyzeStrategy = oldAnalyzeStrategy != null ? oldAnalyzeStrategy : GraphExplorationStrategyKind.BREADTH_FIRST_SEARCH;
                }
                throw throwable;
            }
            if (this.fAnalyzeStrategy == null) {
                this.fAnalyzeStrategy = oldAnalyzeStrategy != null ? oldAnalyzeStrategy : GraphExplorationStrategyKind.BREADTH_FIRST_SEARCH;
            }
        }
        this.initializeAnalyzeStrategy();
        this.handleEnablingRedundancyDetection();
    }

    private void initializeAnalyzeStrategy() {
        this.fBFSButton.setSelection(false);
        this.fDFSButton.setSelection(false);
        this.fRFSButton.setSelection(false);
        this.fALLButton.setSelection(false);
        switch (this.fAnalyzeStrategy) {
            case BREADTH_FIRST_SEARCH: {
                this.fBFSButton.setSelection(true);
                break;
            }
            case DEPTH_FIRST_SEARCH: {
                this.fDFSButton.setSelection(true);
                break;
            }
            case RANDOM_FIRST_SEARCH: {
                this.fRFSButton.setSelection(true);
                break;
            }
            case ALL: {
                this.fALLButton.setSelection(true);
                break;
            }
            default: {
                this.fBFSButton.setSelection(true);
                this.fAnalyzeStrategy = GraphExplorationStrategyKind.BREADTH_FIRST_SEARCH;
            }
        }
    }

    @Override
    protected void performApplyImpl(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.eclipse.efm.execution.core.ATTR_SPECIFICATION_ANALYZE_STRATEGY", this.fAnalyzeStrategy.getLiteral());
    }

    @Override
    protected boolean isValidImpl(ILaunchConfiguration launchConfig) {
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void handleConfigurationPropertyChange(PropertyChangeEvent event) {
        switch (event.getProperty()) {
            case "org.eclipse.efm.execution.core.ATTR_SPECIFICATION_MODEL_ANALYSIS_PROFILE": {
                switch (event.getNewValue().toString()) {
                    case "Transition Coverage": 
                    case "Test Offline": 
                    case "Behavior Selection": {
                        this.fDFSButton.setSelection(false);
                        this.fRFSButton.setSelection(false);
                        this.fALLButton.setSelection(false);
                        this.fBFSButton.setSelection(true);
                        return;
                    }
                    default: {
                        return;
                    }
                    case "Exploration": 
                }
                return;
            }
        }
    }

    private final class TabListener
    extends SelectionAdapter {
        private TabListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            Object source = e.getSource();
            if (source == OverviewExplorationConfigurationProfile.this.fBFSButton) {
                OverviewExplorationConfigurationProfile.this.handleBFSButtonSelected();
            } else if (source == OverviewExplorationConfigurationProfile.this.fDFSButton) {
                OverviewExplorationConfigurationProfile.this.handleDFSButtonSelected();
            } else if (source == OverviewExplorationConfigurationProfile.this.fRFSButton) {
                OverviewExplorationConfigurationProfile.this.handleRFSButtonSelected();
            } else if (source == OverviewExplorationConfigurationProfile.this.fALLButton) {
                OverviewExplorationConfigurationProfile.this.handleALLButtonSelected();
            }
        }
    }
}

