/*
 * Decompiled with CFR 0.152.
 */
package ecore4regutils;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Collections;
import java.util.Map;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;

public class Orchestration {
    public static String resourceURI = "";
    public static ResourceSet resSet = null;
    public static boolean isSetUp = false;
    public static Path filePath = Path.of("logfile.txt", new String[0]);

    public static void main(String[] args) {
        try {
            Class<?> inputPackageClass = Class.forName("input_tables.Input_tablesPackage");
            Field[] fields = inputPackageClass.getDeclaredFields();
            System.out.println("class = " + inputPackageClass.getName());
            Field[] fieldArray = fields;
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                Field f = fieldArray[n2];
                System.out.println(f.getName());
                ++n2;
            }
            Field field = inputPackageClass.getDeclaredField("eNS_URI");
            Field field2 = inputPackageClass.getDeclaredField("eINSTANCE");
            field.setAccessible(true);
            field2.setAccessible(true);
            Object nsuri = field.get(inputPackageClass);
            Object iPackage = field2.get(inputPackageClass);
            Class<?> outputPackageClass = Class.forName("output_tables.Output_tablesPackage");
            Field[] fields2 = outputPackageClass.getDeclaredFields();
            System.out.println("class = " + outputPackageClass.getName());
            Field[] fieldArray2 = fields2;
            int n3 = fields2.length;
            int n4 = 0;
            while (n4 < n3) {
                Field f2 = fieldArray2[n4];
                System.out.println(f2.getName());
                ++n4;
            }
            Field field3 = outputPackageClass.getDeclaredField("eNS_URI");
            Field field4 = outputPackageClass.getDeclaredField("eINSTANCE");
            field3.setAccessible(true);
            field4.setAccessible(true);
            Object nsuri2 = field3.get(outputPackageClass);
            Object iPackage2 = field4.get(outputPackageClass);
            EPackage.Registry.INSTANCE.put((Object)((String)nsuri), iPackage);
            EPackage.Registry.INSTANCE.put((Object)((String)nsuri2), iPackage2);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        String fullResourceURI = args[0];
        EObject theObject = Orchestration.loadObject(fullResourceURI);
        Orchestration.setup(theObject);
    }

    public static void setup(EObject theObject) {
        isSetUp = true;
        try {
            String platformURI = theObject.eResource().getURI().toFileString();
            String fileSeparator = FileSystems.getDefault().getSeparator();
            resourceURI = platformURI.substring(0, platformURI.lastIndexOf(fileSeparator));
            Files.writeString(filePath, (CharSequence)("resourceURI.toPlatformString2()= " + resourceURI + "\n"), StandardOpenOption.CREATE);
        }
        catch (Exception e) {
            try {
                Files.writeString(filePath, (CharSequence)("resourceURI toPlatformString2 FAILED " + e.toString() + "\n"), new OpenOption[0]);
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            e.printStackTrace();
        }
        Resource.Factory.Registry reg = Resource.Factory.Registry.INSTANCE;
        Map m = reg.getExtensionToFactoryMap();
        m.put("xmi", new XMIResourceFactoryImpl());
        resSet = new ResourceSetImpl();
        EList operations = theObject.eClass().getEOperations();
        for (EOperation eOperation : operations) {
            BasicEList params = new BasicEList();
            if (!eOperation.getName().equals("init")) continue;
            try {
                theObject.eInvoke(eOperation, (EList)params);
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        Orchestration.persistObject(theObject);
        Orchestration.persistObjectAsCSV(theObject);
        TreeIterator contents = theObject.eAllContents();
        while (contents.hasNext()) {
            EObject o = (EObject)contents.next();
            operations = o.eClass().getEAllOperations();
            System.out.println(String.valueOf(o.eClass().getName()) + " {");
            for (EOperation eOperation : operations) {
                BasicEList params = new BasicEList();
                if (eOperation.getName().equals("init") || eOperation.getName().contains("_regscenario")) continue;
                try {
                    Object result = o.eInvoke(eOperation, (EList)params);
                    System.out.println(result);
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
            System.out.println("}\n");
        }
    }

    public static void init(EObject theObject) {
        if (!isSetUp) {
            Orchestration.setup(theObject);
        } else {
            if (resSet == null) {
                resSet = new ResourceSetImpl();
            }
            EClass eclass = theObject.eClass();
            EList references = eclass.getEAllReferences();
            for (EReference eReference : references) {
                if (eReference.isContainment()) continue;
                EObject newObject = Orchestration.findTableInXMIFile(eReference.getEType(), eclass);
                if (newObject != null) {
                    theObject.eSet((EStructuralFeature)eReference, (Object)newObject);
                    Orchestration.persistObjectAsCSV(newObject);
                    continue;
                }
                newObject = Orchestration.createObjectFromReferenceType(eReference);
                EClass newObjectsClass = newObject.eClass();
                EList operations = newObjectsClass.getEOperations();
                for (EOperation eOperation : operations) {
                    BasicEList params = new BasicEList();
                    if (!eOperation.getName().equals("init")) continue;
                    try {
                        newObject.eInvoke(eOperation, (EList)params);
                    }
                    catch (InvocationTargetException e) {
                        e.printStackTrace();
                    }
                }
                Orchestration.persistObject(newObject);
                Orchestration.persistObjectAsCSV(newObject);
                try {
                    Files.writeString(filePath, (CharSequence)("newObject" + newObject + "theObject" + theObject + "eReference" + eReference + "eReference.etype" + eReference), StandardOpenOption.CREATE);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                theObject.eSet((EStructuralFeature)eReference, (Object)newObject);
            }
        }
    }

    private static void persistObject(EObject theObject) {
        Orchestration.createCSVStringForTable(theObject);
        try {
            theObject.eResource().save(Collections.EMPTY_MAP);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void persistObjectAsCSV(EObject theObject) {
        String csvString = Orchestration.createCSVStringForTable(theObject);
        try {
            Files.writeString(Path.of(String.valueOf(resourceURI) + '/' + theObject.eClass().getName() + ".csv", new String[0]), (CharSequence)csvString, StandardOpenOption.CREATE_NEW);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static String createCSVStringForTable(EObject theObject) {
        String csvString = "";
        EClass eClass = theObject.eClass();
        EList sfs = eClass.getEAllStructuralFeatures();
        for (EStructuralFeature eStructuralFeature : sfs) {
            boolean cont;
            if (!(eStructuralFeature instanceof EReference) || !(cont = ((EReference)eStructuralFeature).isContainment())) continue;
            boolean headerCreated = false;
            TreeIterator objectContents = theObject.eAllContents();
            while (objectContents.hasNext()) {
                EObject o = (EObject)objectContents.next();
                if (!headerCreated) {
                    csvString = String.valueOf(csvString) + Orchestration.createCSVHeaderStringForRow(o);
                    headerCreated = true;
                }
                csvString = String.valueOf(csvString) + Orchestration.createCSVStringForRow(o);
            }
        }
        return String.valueOf(csvString) + "\n";
    }

    private static String createCSVStringForRow(EObject theObject) {
        String csvString = "";
        EClass eClass = theObject.eClass();
        EList sfs = eClass.getEAllStructuralFeatures();
        boolean firstItem = true;
        for (EStructuralFeature eStructuralFeature : sfs) {
            String referencedItemString;
            Object referencedItem;
            if (firstItem) {
                referencedItem = theObject.eGet(eStructuralFeature, true);
                referencedItemString = Orchestration.getReferencedItemString(eStructuralFeature, referencedItem);
                csvString = String.valueOf(csvString) + referencedItemString;
                firstItem = false;
                continue;
            }
            referencedItem = theObject.eGet(eStructuralFeature, true);
            referencedItemString = Orchestration.getReferencedItemString(eStructuralFeature, referencedItem);
            csvString = String.valueOf(csvString) + "," + referencedItemString;
        }
        EList ops = eClass.getEAllOperations();
        for (EOperation eOperation : ops) {
            String resultString;
            Object result;
            if (firstItem) {
                if (eOperation.getName().contains("_regscenario_")) continue;
                try {
                    result = theObject.eInvoke(eOperation, null);
                    resultString = "null";
                    if (result != null) {
                        resultString = result.toString();
                    }
                    csvString = String.valueOf(csvString) + resultString;
                    firstItem = false;
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
                continue;
            }
            if (eOperation.getName().contains("_regscenario_")) continue;
            try {
                result = theObject.eInvoke(eOperation, null);
                resultString = "null";
                if (result != null) {
                    resultString = result.toString();
                }
                csvString = String.valueOf(csvString) + "," + resultString;
                firstItem = false;
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return String.valueOf(csvString) + "\n";
    }

    private static String getReferencedItemString(EStructuralFeature eStructuralFeature, Object referencedItem) {
        String returnString = null;
        if (referencedItem == null) {
            returnString = "null";
        } else if (eStructuralFeature instanceof EReference) {
            if (eStructuralFeature.getUpperBound() == 1) {
                EClass eClass = ((EObject)referencedItem).eClass();
                EAttribute idattr = eClass.getEIDAttribute();
                EList features = eClass.getEAllStructuralFeatures();
                for (EStructuralFeature eStructuralFeature2 : features) {
                    Object attributeValue;
                    if (eStructuralFeature2 == idattr && (attributeValue = ((EObject)referencedItem).eGet(eStructuralFeature2)) != null) {
                        returnString = attributeValue.toString();
                    }
                    if (returnString != null) continue;
                    returnString = eStructuralFeature.getName();
                }
            } else {
                returnString = "multiple_" + eStructuralFeature.getName();
            }
        } else {
            returnString = eStructuralFeature instanceof EAttribute && ((EAttribute)eStructuralFeature).getEAttributeType() instanceof EEnum ? String.valueOf(((Enumerator)referencedItem).getLiteral()) + "_" + ((Enumerator)referencedItem).getName() : referencedItem.toString();
        }
        return returnString;
    }

    private static String createCSVHeaderStringForRow(EObject theObject) {
        String csvString = "";
        EClass eClass = theObject.eClass();
        EList sfs = eClass.getEAllStructuralFeatures();
        boolean firstItem = true;
        for (EStructuralFeature eStructuralFeature : sfs) {
            if (firstItem) {
                csvString = String.valueOf(csvString) + eStructuralFeature.getName();
                firstItem = false;
                continue;
            }
            csvString = String.valueOf(csvString) + "," + eStructuralFeature.getName();
        }
        EList ops = eClass.getEAllOperations();
        for (EOperation eOperation : ops) {
            if (firstItem) {
                if (eOperation.getName().contains("_regscenario_")) continue;
                csvString = String.valueOf(csvString) + eOperation.getName();
                firstItem = false;
                continue;
            }
            if (eOperation.getName().contains("_regscenario_")) continue;
            csvString = String.valueOf(csvString) + "," + eOperation.getName();
        }
        return String.valueOf(csvString) + "\n";
    }

    private static EObject createObjectFromReferenceType(EReference eReference) {
        EClass theClass = (EClass)eReference.getEType();
        Resource resource1 = resSet.createResource(URI.createFileURI((String)(String.valueOf(resourceURI) + '/' + theClass.getName() + ".xmi")));
        EObject newObject = theClass.getEPackage().getEFactoryInstance().create(theClass);
        resource1.getContents().add((Object)newObject);
        return newObject;
    }

    private static EObject loadObject(String fullFileURI) {
        Resource.Factory.Registry reg = Resource.Factory.Registry.INSTANCE;
        Map m = reg.getExtensionToFactoryMap();
        m.put("xmi", new XMIResourceFactoryImpl());
        EObject returnVal = null;
        try {
            if (resSet == null) {
                resSet = new ResourceSetImpl();
            }
            Resource resource1 = resSet.getResource(URI.createFileURI((String)fullFileURI), true);
            resource1.load(Collections.EMPTY_MAP);
            returnVal = (EObject)resource1.getContents().get(0);
        }
        catch (Exception e) {
            try {
                Files.writeString(filePath, (CharSequence)e.toString(), StandardOpenOption.CREATE);
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
        try {
            Files.writeString(filePath, (CharSequence)("returnVal" + returnVal), StandardOpenOption.CREATE);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return returnVal;
    }

    private static EObject findTableInXMIFile(EClassifier eClassifier, EClass eclass) {
        try {
            Files.writeString(filePath, (CharSequence)("findTableInXMIFile222" + eClassifier), StandardOpenOption.CREATE);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        EObject returnVal = null;
        eclass.getEPackage();
        Resource.Factory.Registry reg = Resource.Factory.Registry.INSTANCE;
        Map m = reg.getExtensionToFactoryMap();
        m.put("xmi", new XMIResourceFactoryImpl());
        try {
            Resource resource1 = resSet.getResource(URI.createFileURI((String)(String.valueOf(resourceURI) + '/' + eClassifier.getName() + ".xmi")), true);
            resource1.load(Collections.EMPTY_MAP);
            returnVal = (EObject)resource1.getContents().get(0);
        }
        catch (Exception e) {
            try {
                Files.writeString(filePath, (CharSequence)e.toString(), StandardOpenOption.CREATE);
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
        try {
            Files.writeString(filePath, (CharSequence)("returnVal" + returnVal), StandardOpenOption.CREATE);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return returnVal;
    }
}

