/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.event;

import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstant;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.SupportedBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.Window;
import com.gargoylesoftware.htmlunit.javascript.host.event.Event;
import com.gargoylesoftware.htmlunit.javascript.host.event.EventTarget;
import net.sourceforge.htmlunit.corejs.javascript.ScriptRuntime;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import net.sourceforge.htmlunit.corejs.javascript.ScriptableObject;
import net.sourceforge.htmlunit.corejs.javascript.Undefined;

@JsxClass
public class UIEvent
extends Event {
    @JsxConstant(value={SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public static final int SCROLL_PAGE_DOWN = 32768;
    @JsxConstant(value={SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public static final short SCROLL_PAGE_UP = Short.MIN_VALUE;
    private long detail_;
    private Object view_;
    private static final Object NO_VIEW = new Object();

    public UIEvent() {
    }

    @Override
    @JsxConstructor(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public void jsConstructor(String type, ScriptableObject details) {
        super.jsConstructor(type, details);
        this.view_ = NO_VIEW;
        if (details != null && !Undefined.isUndefined((Object)details)) {
            Object view = details.get("view", (Scriptable)details);
            if (view instanceof Window) {
                this.view_ = view;
            } else if (view != Scriptable.NOT_FOUND) {
                throw ScriptRuntime.typeError((String)"View must be a window.");
            }
        }
    }

    public UIEvent(DomNode domNode, String type) {
        super(domNode, type);
    }

    public UIEvent(EventTarget target, String type) {
        super(target, type);
    }

    @JsxGetter
    public long getDetail() {
        return this.detail_;
    }

    protected void setDetail(long detail) {
        this.detail_ = detail;
    }

    @JsxGetter
    public Object getView() {
        if (this.view_ == NO_VIEW) {
            return null;
        }
        if (this.view_ != null) {
            return this.view_;
        }
        return this.getWindow();
    }

    @JsxFunction(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR, SupportedBrowser.IE})
    public void initUIEvent(String type, boolean bubbles, boolean cancelable, Object view, int detail) {
        this.initEvent(type, bubbles, cancelable);
        this.setDetail(detail);
    }
}

