/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit;

import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.StringWebResponse;
import com.gargoylesoftware.htmlunit.WebAssert;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.WebWindowImpl;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.util.UrlUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TopLevelWindow
extends WebWindowImpl {
    private static final Log LOG = LogFactory.getLog(TopLevelWindow.class);
    private WebWindow opener_;

    protected TopLevelWindow(String name, WebClient webClient) {
        super(webClient);
        WebAssert.notNull("name", name);
        this.setName(name);
        this.performRegistration();
    }

    @Override
    public WebWindow getParentWindow() {
        return this;
    }

    @Override
    public WebWindow getTopWindow() {
        return this;
    }

    @Override
    protected boolean isJavaScriptInitializationNeeded(Page page) {
        return this.getScriptableObject() == null || page.getUrl() == UrlUtils.URL_ABOUT_BLANK || !(page.getWebResponse() instanceof StringWebResponse);
    }

    public String toString() {
        return "TopLevelWindow[name=\"" + this.getName() + "\"]";
    }

    public void setOpener(WebWindow opener) {
        this.opener_ = opener;
    }

    public WebWindow getOpener() {
        return this.opener_;
    }

    public void close() {
        this.close(false);
    }

    public void close(boolean ignoreOnbeforeunloadAccepted) {
        Page page = this.getEnclosedPage();
        if (page != null && page.isHtmlPage()) {
            HtmlPage htmlPage = (HtmlPage)page;
            boolean accepted = htmlPage.isOnbeforeunloadAccepted();
            if (!ignoreOnbeforeunloadAccepted && !accepted) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"The registered OnbeforeunloadHandler rejected the window close event.");
                }
                return;
            }
        }
        this.setClosed();
        if (page != null) {
            page.cleanUp();
        }
        this.getJobManager().shutdown();
        this.destroyChildren();
        this.getWebClient().deregisterWebWindow(this);
    }
}

