/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.junit;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jboss.arquillian.core.spi.Validate;
import org.jboss.arquillian.junit.SecurityActions;

class JavaSPILoader {
    private static final String SERVICES = "META-INF/services";

    JavaSPILoader() {
    }

    <T> List<T> all(ClassLoader classLoader, Class<T> serviceClass) {
        Validate.notNull((Object)classLoader, (String)"ClassLoader must be provided");
        Validate.notNull(serviceClass, (String)"ServiceClass must be provided");
        return new ArrayList<T>(this.createInstances(this.load(serviceClass, classLoader)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> Set<Class<? extends T>> load(Class<T> serviceClass, ClassLoader loader) {
        String serviceFile = "META-INF/services/" + serviceClass.getName();
        LinkedHashSet<Class<T>> providers = new LinkedHashSet<Class<T>>();
        LinkedHashSet<Class<T>> vetoedProviders = new LinkedHashSet<Class<T>>();
        try {
            Enumeration<URL> enumeration = loader.getResources(serviceFile);
            while (enumeration.hasMoreElements()) {
                URL url = enumeration.nextElement();
                InputStream is = url.openStream();
                BufferedReader reader = null;
                try {
                    reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                    String line = reader.readLine();
                    while (null != line) {
                        if ((line = this.skipCommentAndTrim(line)).length() > 0) {
                            try {
                                boolean mustBeVetoed = line.startsWith("!");
                                if (mustBeVetoed) {
                                    line = line.substring(1);
                                }
                                Class<T> provider = loader.loadClass(line).asSubclass(serviceClass);
                                if (mustBeVetoed) {
                                    vetoedProviders.add(provider);
                                }
                                if (vetoedProviders.contains(provider)) {
                                    providers.remove(provider);
                                } else {
                                    providers.add(provider);
                                }
                            }
                            catch (ClassCastException e) {
                                throw new IllegalStateException("Service " + line + " does not implement expected type " + serviceClass.getName());
                            }
                        }
                        line = reader.readLine();
                    }
                }
                finally {
                    if (reader == null) continue;
                    reader.close();
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Could not load services for " + serviceClass.getName(), e);
        }
        return providers;
    }

    private String skipCommentAndTrim(String line) {
        int comment = line.indexOf(35);
        if (comment > -1) {
            line = line.substring(0, comment);
        }
        line = line.trim();
        return line;
    }

    private <T> Set<T> createInstances(Set<Class<? extends T>> providers) {
        LinkedHashSet<T> providerImpls = new LinkedHashSet<T>();
        for (Class<T> clazz : providers) {
            providerImpls.add(this.createInstance(clazz));
        }
        return providerImpls;
    }

    private <T> T createInstance(Class<? extends T> serviceImplClass) {
        try {
            return SecurityActions.newInstance(serviceImplClass, new Class[0], new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create a new instance of Service implementation " + serviceImplClass.getName(), e);
        }
    }
}

