/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.mvc.tests.security.csrf.header;

import com.gargoylesoftware.htmlunit.HttpMethod;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebRequest;
import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.util.NameValuePair;
import ee.jakarta.tck.mvc.tests.security.csrf.header.CsrfCustomHeaderApplication;
import ee.jakarta.tck.mvc.tests.security.csrf.header.CsrfHeaderController;
import ee.jakarta.tck.mvc.util.Archives;
import ee.jakarta.tck.mvc.util.MvcMatchers;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
@SpecVersion(spec="mvc", version="1.0")
public class CsrfCustomHeaderTest {
    @ArquillianResource
    private URL baseUrl;
    private WebClient webClient;

    @Deployment(testable=false)
    public static WebArchive createDeployment() {
        return Archives.getMvcArchive(CsrfCustomHeaderApplication.class).addClass(CsrfHeaderController.class).addView("csrf/header/form.jsp").addView("csrf/header/success.jsp").build();
    }

    @Before
    public void before() {
        this.webClient = new WebClient();
        this.webClient.getOptions().setThrowExceptionOnFailingStatusCode(false);
        this.webClient.getOptions().setRedirectEnabled(false);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="cross-site-request-forgery", id="csrf-verify"), @SpecAssertion(section="cross-site-request-forgery", id="csrf-custom-header-name")})
    public void submitValidCustomTokenViaHeader() throws IOException {
        HtmlPage formPage = (HtmlPage)this.webClient.getPage(this.baseUrl.toString() + "mvc/csrf/header/form");
        Assert.assertThat((Object)formPage.getWebResponse().getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
        String token = formPage.getWebResponse().getResponseHeaderValue("X-CSRF-Custom-Header-Name");
        Assert.assertThat((Object)token, MvcMatchers.isNotBlank());
        WebRequest postRequest = new WebRequest(new URL(this.baseUrl.toString() + "mvc/csrf/header/process"));
        postRequest.setHttpMethod(HttpMethod.POST);
        postRequest.setAdditionalHeader("X-CSRF-Custom-Header-Name", token);
        postRequest.setRequestParameters(Collections.singletonList(new NameValuePair("name", "Charlie")));
        WebResponse postResponse = this.webClient.loadWebResponse(postRequest);
        Assert.assertThat((Object)postResponse.getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
        Assert.assertThat((Object)postResponse.getContentAsString(), (Matcher)CoreMatchers.containsString((String)"Hi Charlie!"));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="cross-site-request-forgery", id="csrf-verify"), @SpecAssertion(section="cross-site-request-forgery", id="csrf-custom-header-name")})
    public void submitInvalidCustomTokenViaHeader() throws IOException {
        HtmlPage formPage = (HtmlPage)this.webClient.getPage(this.baseUrl.toString() + "mvc/csrf/header/form");
        Assert.assertThat((Object)formPage.getWebResponse().getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
        WebRequest postRequest = new WebRequest(new URL(this.baseUrl.toString() + "mvc/csrf/header/process"));
        postRequest.setHttpMethod(HttpMethod.POST);
        postRequest.setAdditionalHeader("X-CSRF-Custom-Header-Name", "INVALID-TOKEN");
        postRequest.setRequestParameters(Collections.singletonList(new NameValuePair("name", "David")));
        WebResponse postResponse = this.webClient.loadWebResponse(postRequest);
        Assert.assertThat((Object)postResponse.getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)403));
    }
}

