/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.mvc.tests.binding.base;

import ee.jakarta.tck.mvc.tests.binding.base.BindingBaseForm;
import jakarta.inject.Inject;
import jakarta.mvc.Controller;
import jakarta.mvc.Models;
import jakarta.mvc.binding.BindingError;
import jakarta.mvc.binding.BindingResult;
import jakarta.mvc.binding.ValidationError;
import jakarta.validation.Valid;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;

@Controller
@Path(value="binding/base")
public class BindingBaseController {
    @Inject
    private Models models;
    @Inject
    private BindingResult bindingResult;

    @GET
    public String render() {
        return "binding/base/form.jsp";
    }

    @POST
    public String submit(@BeanParam @Valid BindingBaseForm form) {
        if (this.bindingResult.isFailed()) {
            String message = this.bindingResult.getAllErrors().stream().map(error -> {
                if (error instanceof BindingError) {
                    return "Binding error: " + error.getMessage();
                }
                if (error instanceof ValidationError) {
                    return "Validation error: " + error.getMessage();
                }
                throw new IllegalStateException("Unsupported type: " + error.getClass().getName());
            }).findFirst().orElseThrow(() -> new IllegalStateException("Binding failed but no error found"));
            this.models.put("message", (Object)message);
        } else {
            this.models.put("message", (Object)("You are " + form.getAge() + " years old."));
        }
        return "binding/base/result.jsp";
    }
}

