/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.controls;

import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.EnumSet;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public enum EntryRight {
    ADD("add"),
    DELETE("delete"),
    READ("read"),
    WRITE("write"),
    PROXY("proxy");

    private final String name;

    private EntryRight(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static EntryRight forName(String name) {
        String lowerName = StaticUtils.toLowerCase(name);
        for (EntryRight r : EnumSet.allOf(EntryRight.class)) {
            if (!r.name.equals(lowerName)) continue;
            return r;
        }
        return null;
    }

    public String toString() {
        return this.name;
    }
}

