/*
 * Copyright (c) 2017, 2020 Oracle and/or its affiliates. All rights reserved.
 */


/*
 *  @(#)ValidationEventLocatorImpl.test.xml	1.3 07/01/24 Evgueni Rouban
 * Generated from : api/jakarta_xml/bind/helpers/ValidationEventLocatorImpl/ValidationEventLocatorImpl.test.xml
 *
 * General tests of constructors and methods
 * General tests of constructors and methods.
 */

package javasoft.sqe.tests.api.jakarta.xml.bind.helpers.ValidationEventLocatorImpl;

import jakarta.xml.bind.ValidationEventLocator;
import jakarta.xml.bind.helpers.ValidationEventLocatorImpl;
import java.net.MalformedURLException;
import java.net.URL;
import javasoft.sqe.javatest.Status;
import javasoft.sqe.javatest.lib.MultiTest;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Node;
import org.xml.sax.Locator;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.LocatorImpl;


public class ValidationEventLocatorImplTests extends MultiTest {

    void assertT( boolean val, String msg ){
        if( !val )
            throw new RuntimeException(msg);
    }

    /* standalone interface */
    public static void main(String argv[]) {
        ValidationEventLocatorImplTests test = new ValidationEventLocatorImplTests();
        test.run(argv, System.err, System.out).exit();
    }

    /**
     * Assertion testing
     * for public java.net.URL getURL(),
     * <br><b>pre-conditions</b>: created by constructor ValidationEventLocatorImpl(),
     * Returns null if the name of the XML source as a URL is unavailable..
     * <br><b>Expected output value</b>: null
     */
    public Status Ctor001() {
        ValidationEventLocator vel = new ValidationEventLocatorImpl();

        String result = "";

        if (vel.getColumnNumber() != -1) {
            result += "; getColumnNumber() != -1: " + vel.getColumnNumber();
        }

        if (vel.getLineNumber() != -1) {
            result += "; getLineNumber() != -1: " + vel.getLineNumber();
        }

        if (vel.getNode() != null) {
            result += "; getNode() != null: " + vel.getNode();
        }

        if (vel.getObject() != null) {
            result += "; getObject() != null: " + vel.getObject();
        }

        if (vel.getOffset() != -1) {
            result += "; getOffset() != -1: " + vel.getOffset();
        }

        if (vel.getURL() != null) {
            result += "; getURL() != null: " + vel.getURL();
        }

        if (result.length() > 0) {
            return Status.failed(result.substring(2));
        }

        return Status.passed("OKAY");
    }

    /**
     * Assertion testing
     * for public ValidationEventLocatorImpl(org.xml.sax.Locator loc),
     * Constructs an object from an org.xml.sax.Locator.
     * ColumnNumber and LineNumber are available from the locator..
     * <br><b>Expected results</b>: ColumnNumber and LineNumber are what the locator has
     */
    public Status Ctor002() {
        LocatorImpl locator = new LocatorImpl();
        locator.setColumnNumber(1);
        locator.setLineNumber(2);
        ValidationEventLocator vel = new ValidationEventLocatorImpl(locator);

        String result = "";

        if (vel.getColumnNumber() != 1) {
            result += "; getColumnNumber() != 1: " + vel.getColumnNumber();
        }

        if (vel.getLineNumber() != 2) {
            result += "; getLineNumber() != 2: " + vel.getLineNumber();
        }

        if (result.length() > 0) {
            return Status.failed(result.substring(2));
        }

        return Status.passed("OKAY");
    }

    /**
     * Assertion testing
     * for public ValidationEventLocatorImpl(org.w3c.dom.Node _node),
     * Constructs an object that points to a DOM Node.
     * Node is available..
     * <br><b>Expected results</b>: the node is available
     */
    public Status Ctor003() {
        Node node;

        try {
            node = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        } catch (FactoryConfigurationError fce) {
            return Status.failed(fce.toString());
        } catch (ParserConfigurationException pce) {
            return Status.failed(pce.toString());
        }

        ValidationEventLocator vel = new ValidationEventLocatorImpl(node);

        if (vel.getNode() != node) {
            return Status.failed("getNode() returns " + vel.getNode() + ", expected is " + node);
        }

        return Status.passed("OKAY");
    }

    /**
     * Assertion testing
     * for public ValidationEventLocatorImpl(java.lang.Object _object),
     * Constructs an object that points to a Jakarta XML Binding content object.
     * Object parameter is available..
     * <br><b>Expected results</b>: the object is available
     */
    public Status Ctor004() {
        Object obj = new Object();

        ValidationEventLocator vel = new ValidationEventLocatorImpl(obj);

        if (vel.getObject() != obj) {
            return Status.failed("getObject() returns " + vel.getObject() + ", expected is " + obj);
        }

        return Status.passed("OKAY");
    }

    /**
     * Assertion testing
     * for public ValidationEventLocatorImpl(org.xml.sax.SAXParseException e),
     * Constructs an object from the location information of a SAXParseException.
     * ColumnNumber and LineNumber are available from the SAXParseException..
     * <br><b>Expected results</b>: ColumnNumber and LineNumber are what the exception has
     */
    public Status Ctor005() {
        SAXParseException spe = new SAXParseException("message", "publicId", "systemId", 3, 2);
        ValidationEventLocator vel = new ValidationEventLocatorImpl(spe);

        String result = "";

        if (vel.getColumnNumber() != 2) {
            result += "; getColumnNumber() != 2: " + vel.getColumnNumber();
        }

        if (vel.getLineNumber() != 3) {
            result += "; getLineNumber() != 3: " + vel.getLineNumber();
        }

        if (result.length() > 0) {
            return Status.failed(result.substring(2));
        }

        return Status.passed("OKAY");
    }

    /**
     * Assertion testing
     * for public int getColumnNumber(),
     * <br><b>pre-conditions</b>: the column number is set,
     * Returns the column number if available..
     * <br><b>Expected output value</b>: what set
     */
    public Status Set001() {
        ValidationEventLocatorImpl vel = new ValidationEventLocatorImpl();

        vel.setColumnNumber(3);

        if (vel.getColumnNumber() != 3) {
            return Status.failed("getColumnNumber() != 3: " + vel.getColumnNumber());
        }

        return Status.passed("OKAY");
    }

    /**
     * Assertion testing
     * for public int getLineNumber(),
     * <br><b>pre-conditions</b>: the line number is set,
     * Returns the line number if available..
     * <br><b>Expected output value</b>: what set
     */
    public Status Set002() {
        ValidationEventLocatorImpl vel = new ValidationEventLocatorImpl();

        vel.setLineNumber(2);

        if (vel.getLineNumber() != 2) {
            return Status.failed("getLineNumber() != 2: " + vel.getLineNumber());
        }

        return Status.passed("OKAY");
    }

    /**
     * Assertion testing
     * for public org.w3c.dom.Node getNode(),
     * <br><b>pre-conditions</b>: the node is set,
     * Returns the node if available..
     * <br><b>Expected output value</b>: what set
     */
    public Status Set003() {
        Node node;

        try {
            node = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        } catch (FactoryConfigurationError fce) {
            return Status.failed(fce.toString());
        } catch (ParserConfigurationException pce) {
            return Status.failed(pce.toString());
        }

        ValidationEventLocatorImpl vel = new ValidationEventLocatorImpl();

        vel.setNode(node);

        if (vel.getNode() != node) {
            return Status.failed("getNode() != " + node + ": " + vel.getNode());
        }

        return Status.passed("OKAY");
    }

    /**
     * Assertion testing
     * for public java.lang.Object getObject(),
     * <br><b>pre-conditions</b>: the Jakarta XML Binding content object is set,
     * Returns the Jakarta XML Binding content object if available..
     * <br><b>Expected output value</b>: what set
     */
    public Status Set004() {
        Object object = new Object();

        ValidationEventLocatorImpl vel = new ValidationEventLocatorImpl();

        vel.setObject(object);

        if (vel.getObject() != object) {
            return Status.failed("getObject() != " + object + ": " + vel.getObject());
        }

        return Status.passed("OKAY");
    }

    /**
     * Assertion testing
     * for public int getOffset(),
     * <br><b>pre-conditions</b>: the offset is set,
     * Returns the offset if available..
     * <br><b>Expected output value</b>: what set
     */
    public Status Set005() {
        ValidationEventLocatorImpl vel = new ValidationEventLocatorImpl();

        vel.setOffset(12);

        if (vel.getOffset() != 12) {
            return Status.failed("getOffset() != 12: " + vel.getOffset());
        }

        return Status.passed("OKAY");
    }

    /**
     * Assertion testing
     * for public java.net.URL getURL(),
     * <br><b>pre-conditions</b>: the name of the XML source is set,
     * Returns the name of the XML source if available..
     * <br><b>Expected output value</b>: what set
     */
    public Status Set006() {
        URL url;

        try {
            url = new URL("http://java.sun.com");
        } catch(MalformedURLException e) {
            return Status.failed(e.toString());
        }

        ValidationEventLocatorImpl vel = new ValidationEventLocatorImpl();

        vel.setURL(url);

        if (vel.getURL() != url) {
            return Status.failed("getURL() != " + url + ": " + vel.getURL());
        }

        return Status.passed("OKAY");
    }

    /**
     * Functional tests for ValidationEventLocatorImpl,
     * ValidationEventLocatorImpl(Locator loc) Throws: IllegalArgumentException - if the Locator is null.
     */
    public Status Ctor002a() {
        try {
                new ValidationEventLocatorImpl( (Locator)null );
                return Status.failed( "expected IllegalArgumentException was not thrown" );
            } catch(IllegalArgumentException e) {
                return Status.passed("OK");
            }
            	}

    /**
     * Functional tests for ValidationEventLocatorImpl,
     * ValidationEventLocatorImpl(SAXParseException e) Throws: IllegalArgumentException - if the SAXParseException is null.
     */
    public Status Ctor003a() {
        try {
                new ValidationEventLocatorImpl( (SAXParseException)null );
                return Status.failed( "expected IllegalArgumentException was not thrown" );
            } catch(IllegalArgumentException e) {
                return Status.passed("OK");
            }
            	}

    /**
     * Functional tests for ValidationEventLocatorImpl,
     * ValidationEventLocatorImpl(Node _node) Throws: IllegalArgumentException - if the Node is null.
     */
    public Status Ctor004a() {
        try {
                new ValidationEventLocatorImpl( (Node)null );
                return Status.failed( "expected IllegalArgumentException was not thrown" );
            } catch(IllegalArgumentException e) {
                return Status.passed("OK");
            }
            	}

    /**
     * Functional tests for ValidationEventLocatorImpl,
     * ValidationEventLocatorImpl(Object _object) Throws: IllegalArgumentException - if the Object is null.
     */
    public Status Ctor005a() {
        try {
                new ValidationEventLocatorImpl( (Object)null );
                return Status.failed( "expected IllegalArgumentException was not thrown" );
            } catch(IllegalArgumentException e) {
                return Status.passed("OK");
            }
            	}

    /**
     * Functional tests for ValidationEventLocatorImpl,
     * Null values are allowed..
     */
    public Status SetURL_null() {
        ValidationEventLocatorImpl l = new ValidationEventLocatorImpl();
            l.setURL(null);
            assertT( l.getURL() == null, "getURL() returns unexpectedly non-null value" );
            return Status.passed("OK");
            	}

    /**
     * Functional tests for ValidationEventLocatorImpl,
     * Null values are allowed..
     */
    public Status SetObject_null() {
        ValidationEventLocatorImpl l = new ValidationEventLocatorImpl();
            l.setObject(null);
            assertT( l.getObject() == null, "getObject() returns unexpectedly non-null value" );
            return Status.passed("OK");
            	}

    /**
     * Functional tests for ValidationEventLocatorImpl,
     * Null values are allowed..
     */
    public Status SetNode_null() {
        ValidationEventLocatorImpl l = new ValidationEventLocatorImpl();
            l.setNode(null);
            assertT( l.getNode() == null, "getNode() returns unexpectedly non-null value" );
            return Status.passed("OK");
            	}
}
