/*
 * Copyright (c) 2017, 2020 Oracle and/or its affiliates. All rights reserved.
 */

package javasoft.sqe.tests.negativeinteger.pattern.pattern_1;

import jakarta.xml.bind.*;
import jakarta.xml.bind.TypeConstraintException;
import java.math.BigInteger;
import javasoft.sqe.javatest.Status;
import java.io.PrintWriter;
import javasoft.sqe.tests.api.jakarta.xml.bind.CTTest;

public class pattern1_ValidateCTTests extends CTTest {

    /**
     * Command line starter.
     */
    public static void main(String[] args) {
        pattern1_ValidateCTTests test = new pattern1_ValidateCTTests();
        PrintWriter err = new PrintWriter(System.err, true);
        PrintWriter out = new PrintWriter(System.out, true);
        Status status = test.run(args, err, out);
        err.flush();
        out.flush();
        status.exit();
    }

    final BigInteger[] invalidValues = {new BigInteger("-10"), new BigInteger("-100"), new BigInteger("-1000"), 
                                  new BigInteger("0"), new BigInteger("9"), new BigInteger("10"), new BigInteger("1000")};
    final BigInteger[] validValues = {new BigInteger("-1"), new BigInteger("-9")};
    
    JAXBElement<BigInteger> elemObj;

    Status testInvalid() {
        for (int i = 0; i < invalidValues.length; ++i){
            
                elemObj.setValue(invalidValues[i]);
                Status status = validate(elemObj);
                if (status.isPassed()) {
                    return Status.failed("" + invalidValues[i] + " is unexpectedly valid");
                }
            
        }
        return Status.passed("OK");
    }

    Status testValid() {
        for (int i = 0; i < validValues.length; ++i){
            elemObj.setValue(validValues[i]);
            Status status = validate(elemObj);
            if (!status.isPassed()){
                return Status.failed("" + validValues[i] + " is unexpectedly invalid");
            }
        }
        return Status.passed("OKAY");
    }

    public Status Validate001( ) {
        String xmlDocName = "pattern-1-1.xml";
        elemObj = (JAXBElement<BigInteger>)unmarshal(xmlDocName);
        return testValid();
    }

    public Status Validate002( ) {
        String xmlDocName = "pattern-1-1.xml";
        elemObj = (JAXBElement<BigInteger>)unmarshal(xmlDocName);
        return testInvalid();
    }

    public Status Validate003( ) {
        elemObj = (JAXBElement<BigInteger>)(new ObjectFactory()).createNISTSchemaNegativeIntegerPattern1(new BigInteger("-5"));
        
        return testValid();
    }

    public Status Validate004( ) {
        elemObj = (JAXBElement<BigInteger>)(new ObjectFactory()).createNISTSchemaNegativeIntegerPattern1(new BigInteger("-5"));
        
        return testInvalid();
    }


}

