/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds;

import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public enum AlertSeverity {
    INFO("info"),
    WARNING("warning"),
    ERROR("error"),
    FATAL("fatal");

    private final String name;

    private AlertSeverity(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static AlertSeverity forName(String name) {
        String lowerName = StaticUtils.toLowerCase(name);
        if (lowerName.equals("error")) {
            return ERROR;
        }
        if (lowerName.equals("fatal")) {
            return FATAL;
        }
        if (lowerName.equals("info")) {
            return INFO;
        }
        if (lowerName.equals("warning")) {
            return WARNING;
        }
        return null;
    }

    public String toString() {
        return this.name;
    }
}

