/*
 * Decompiled with CFR 0.152.
 */
package jdk.incubator.http;

import java.util.Optional;
import java.util.concurrent.Flow;
import java.util.function.Consumer;
import jdk.incubator.http.AbstractPushPublisher;

class PushPublisher<T>
extends AbstractPushPublisher<T> {
    Subscription subscription;
    Flow.Subscriber<? super T> subscriber;
    AbstractPushPublisher.SubscriptionState state;
    long demand;

    PushPublisher() {
    }

    @Override
    public void acceptData(Optional<T> optional) {
        AbstractPushPublisher.SubscriptionState subscriptionState = this.state;
        if (subscriptionState == AbstractPushPublisher.SubscriptionState.CANCELLED) {
            return;
        }
        if (subscriptionState == AbstractPushPublisher.SubscriptionState.DONE) {
            throw new IllegalStateException("subscription complete");
        }
        if (!optional.isPresent()) {
            this.subscriber.onComplete();
            this.state = AbstractPushPublisher.SubscriptionState.DONE;
            return;
        }
        if (this.demand == 0L) {
            throw new IllegalStateException("demand == 0");
        }
        --this.demand;
        this.subscriber.onNext(optional.get());
    }

    @Override
    public Consumer<Optional<T>> asDataConsumer() {
        return this::acceptData;
    }

    @Override
    public void subscribe(Flow.Subscriber<? super T> subscriber) {
        this.subscription = new Subscription(subscriber);
        subscriber.onSubscribe(this.subscription);
    }

    @Override
    public void acceptError(Throwable throwable) {
        if (this.state == AbstractPushPublisher.SubscriptionState.DONE) {
            throw new IllegalStateException("subscription complete");
        }
        this.state = AbstractPushPublisher.SubscriptionState.CANCELLED;
        this.subscriber.onError(throwable);
    }

    private class Subscription
    implements Flow.Subscription {
        Subscription(Flow.Subscriber<? super T> subscriber) {
            PushPublisher.this.subscriber = subscriber;
        }

        @Override
        public void request(long l) {
            PushPublisher.this.demand += l;
        }

        @Override
        public void cancel() {
            PushPublisher.this.state = AbstractPushPublisher.SubscriptionState.CANCELLED;
        }
    }
}

