/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.signaturetest.classpath;

import com.sun.tdk.signaturetest.SigTest;
import com.sun.tdk.signaturetest.classpath.Classpath;
import com.sun.tdk.signaturetest.classpath.ClasspathEntry;
import com.sun.tdk.signaturetest.classpath.Release;
import com.sun.tdk.signaturetest.model.ExoticCharTools;
import com.sun.tdk.signaturetest.util.I18NResourceBundle;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class ClasspathImpl
implements Classpath {
    private final Release release;
    private static final String DIRECTORY_ENTRY_IMPL = "com.sun.tdk.signaturetest.classpath.DirectoryEntry";
    private static final String JAR_ENTRY_IMPL = "com.sun.tdk.signaturetest.classpath.JarFileEntry";
    private List errors;
    private int sizeIgnorables;
    private List entries;
    private Iterator iterator;
    private ClasspathEntry currentEntry;
    private static String pathSeparator;
    private static I18NResourceBundle i18n;

    public ClasspathImpl(Release release, String classPath) {
        this.release = release;
        this.init(classPath);
    }

    @Override
    public void init(String classPath) {
        String path;
        this.entries = new ArrayList();
        this.errors = new ArrayList();
        HashSet<String> unique = new HashSet<String>();
        String string = path = classPath == null ? "" : classPath;
        if (!path.equals("") && pathSeparator == null) {
            throw new SecurityException(i18n.getString("ClasspathImpl.error.notdefinepathsep"));
        }
        ClasspathEntry previosEntry = null;
        while (path != null && path.length() > 0) {
            String s;
            int index = path.indexOf(pathSeparator);
            if (index < 0) {
                s = path;
                path = null;
            } else {
                s = path.substring(0, index);
                path = path.substring(index + pathSeparator.length());
            }
            if (unique.contains(s)) {
                this.errors.add(i18n.getString("ClasspathImpl.error.duplicate_entry_found", (Object)s));
                continue;
            }
            unique.add(s);
            ClasspathEntry entry = this.createPathEntry(previosEntry, s);
            if (entry == null || entry.isEmpty()) continue;
            this.entries.add(entry);
            previosEntry = entry;
        }
        this.setListToBegin();
    }

    @Override
    public void close() {
        if (this.entries != null) {
            Iterator e = this.entries.iterator();
            while (e.hasNext()) {
                ((ClasspathEntry)e.next()).close();
            }
            this.entries = null;
            this.iterator = null;
            this.currentEntry = null;
        }
    }

    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    public void printErrors(PrintWriter out) {
        if (out != null) {
            for (int i = 0; i < this.errors.size(); ++i) {
                out.println((String)this.errors.get(i));
            }
        }
    }

    public int getNumErrors() {
        return this.errors.size() - this.sizeIgnorables;
    }

    @Override
    public void setListToBegin() {
        this.iterator = this.entries.iterator();
        this.currentEntry = null;
        if (this.iterator.hasNext()) {
            this.currentEntry = (ClasspathEntry)this.iterator.next();
        }
    }

    @Override
    public boolean hasNext() {
        if (this.currentEntry == null) {
            return false;
        }
        if (this.currentEntry.hasNext()) {
            return true;
        }
        this.currentEntry = null;
        if (this.iterator.hasNext()) {
            this.currentEntry = (ClasspathEntry)this.iterator.next();
            return this.hasNext();
        }
        return false;
    }

    @Override
    public String nextClassName() {
        return this.currentEntry.nextClassName();
    }

    @Override
    public InputStream findClass(String name) throws IOException, ClassNotFoundException {
        InputStream is;
        name = ExoticCharTools.decodeExotic(name);
        assert (name.indexOf(60) == -1 && name.indexOf(62) == -1);
        Iterator e = this.entries.iterator();
        while (e.hasNext()) {
            try {
                return ((ClasspathEntry)e.next()).findClass(name);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        if (this.release != null && (is = this.release.findClass(name)) != null) {
            return is;
        }
        throw new ClassNotFoundException(name);
    }

    protected ClasspathEntry createPathEntry(ClasspathEntry previosEntry, String name) {
        Throwable t = null;
        if (new File(name).isDirectory()) {
            try {
                Class<?> c = Class.forName(DIRECTORY_ENTRY_IMPL);
                Constructor<?> ctor = c.getConstructor(ClasspathEntry.class, String.class);
                return (ClasspathEntry)ctor.newInstance(previosEntry, name);
            }
            catch (InvocationTargetException e) {
                t = e.getTargetException();
            }
            catch (Throwable th) {
                t = th;
            }
        } else {
            try {
                Class<?> c = Class.forName(JAR_ENTRY_IMPL);
                Constructor<?> ctor = c.getConstructor(ClasspathEntry.class, String.class);
                return (ClasspathEntry)ctor.newInstance(previosEntry, name);
            }
            catch (InvocationTargetException e) {
                t = e.getTargetException();
            }
            catch (Throwable th) {
                t = th;
            }
        }
        if (t != null) {
            Object[] invargs = new String[]{name, t.getMessage()};
            this.errors.add(i18n.getString("ClasspathImpl.error.ignoring", invargs));
            ++this.sizeIgnorables;
        }
        return null;
    }

    static {
        block4: {
            i18n = I18NResourceBundle.getBundleForClass(ClasspathImpl.class);
            try {
                Class<?> c = Class.forName("java.io.File");
                Field f = c.getField("pathSeparator");
                pathSeparator = (String)f.get(null);
            }
            catch (Throwable t) {
                try {
                    pathSeparator = System.getProperty("path.separator");
                }
                catch (SecurityException e) {
                    if (!SigTest.debug) break block4;
                    e.printStackTrace();
                }
            }
        }
    }
}

