/*
 * Decompiled with CFR 0.152.
 */
package jdk.incubator.http.internal.websocket;

import java.io.IOException;
import java.net.ProtocolException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Function;
import jdk.incubator.http.WebSocket;
import jdk.incubator.http.internal.common.Log;
import jdk.incubator.http.internal.common.Pair;
import jdk.incubator.http.internal.common.Utils8;
import jdk.incubator.http.internal.websocket.BuilderImpl;
import jdk.incubator.http.internal.websocket.CooperativeHandler;
import jdk.incubator.http.internal.websocket.FailWebSocketException;
import jdk.incubator.http.internal.websocket.MessageStreamConsumer;
import jdk.incubator.http.internal.websocket.OpeningHandshake;
import jdk.incubator.http.internal.websocket.OutgoingMessage;
import jdk.incubator.http.internal.websocket.RawChannel;
import jdk.incubator.http.internal.websocket.Receiver;
import jdk.incubator.http.internal.websocket.StatusCodes;
import jdk.incubator.http.internal.websocket.Transmitter;

final class WebSocketImpl
implements WebSocket {
    private final URI uri;
    private final String subprotocol;
    private final RawChannel channel;
    private final WebSocket.Listener listener;
    private boolean lastMethodInvoked;
    private final AtomicBoolean outstandingSend = new AtomicBoolean();
    private final CooperativeHandler sendHandler = new CooperativeHandler(this::sendFirst);
    private final Queue<Pair<OutgoingMessage, CompletableFuture<WebSocket>>> queue = new ConcurrentLinkedQueue<Pair<OutgoingMessage, CompletableFuture<WebSocket>>>();
    private final OutgoingMessage.Context context = new OutgoingMessage.Context();
    private final Transmitter transmitter;
    private final Receiver receiver;
    private final AtomicBoolean closed = new AtomicBoolean();
    private final Object lock = new Object();
    private final CompletableFuture<?> closeReceived = new CompletableFuture();
    private final CompletableFuture<?> closeSent = new CompletableFuture();

    static CompletableFuture<WebSocket> newInstanceAsync(BuilderImpl builderImpl) {
        OpeningHandshake openingHandshake;
        Function<OpeningHandshake.Result, WebSocket> function = result -> {
            WebSocketImpl webSocketImpl = new WebSocketImpl(builderImpl.getUri(), result.subprotocol, result.channel, builderImpl.getListener());
            webSocketImpl.signalOpen();
            return webSocketImpl;
        };
        try {
            openingHandshake = new OpeningHandshake(builderImpl);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return Utils8.failedFuture(illegalArgumentException);
        }
        return openingHandshake.send().thenApply(function);
    }

    WebSocketImpl(URI uRI, String string, RawChannel rawChannel, WebSocket.Listener listener) {
        this.uri = Objects.requireNonNull(uRI);
        this.subprotocol = Objects.requireNonNull(string);
        this.channel = Objects.requireNonNull(rawChannel);
        this.listener = Objects.requireNonNull(listener);
        this.transmitter = new Transmitter(rawChannel);
        this.receiver = new Receiver(this.messageConsumerOf(listener), rawChannel);
        CompletableFuture.allOf(this.closeReceived, this.closeSent).whenComplete((void_, throwable) -> {
            try {
                rawChannel.close();
            }
            catch (IOException iOException) {
                Log.logError(iOException);
            }
            finally {
                this.closed.set(true);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void signalOpen() {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.listener.onOpen(this);
            }
            catch (Exception exception) {
                this.signalError(exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void signalError(Throwable throwable) {
        Object object = this.lock;
        synchronized (object) {
            if (this.lastMethodInvoked) {
                Log.logError(throwable);
            } else {
                this.lastMethodInvoked = true;
                this.receiver.close();
                try {
                    this.listener.onError(this, throwable);
                }
                catch (Exception exception) {
                    Log.logError(exception);
                }
            }
        }
    }

    private void processClose(int n, String string) {
        boolean bl;
        this.receiver.close();
        try {
            this.channel.shutdownInput();
        }
        catch (IOException iOException) {
            Log.logError(iOException);
        }
        boolean bl2 = bl = !this.closeReceived.complete(null);
        if (bl) {
            throw new InternalError();
        }
        int n2 = n == 1005 || n == 1006 ? 1000 : n;
        CompletionStage<?> completionStage = this.signalClose(n, string);
        if (completionStage == null) {
            completionStage = CompletableFuture.completedFuture(null);
        }
        completionStage.whenComplete((object, throwable2) -> this.enqueueClose(new OutgoingMessage.Close(n2, "")).whenComplete((webSocket, throwable) -> {
            if (throwable != null) {
                Log.logError(throwable);
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletionStage<?> signalClose(int n, String string) {
        Object object = this.lock;
        synchronized (object) {
            if (this.lastMethodInvoked) {
                Log.logTrace("Close: {0}, ''{1}''", n, string);
            } else {
                this.lastMethodInvoked = true;
                this.receiver.close();
                try {
                    return this.listener.onClose(this, n, string);
                }
                catch (Exception exception) {
                    Log.logError(exception);
                }
            }
        }
        return null;
    }

    @Override
    public CompletableFuture<WebSocket> sendText(CharSequence charSequence, boolean bl) {
        return this.enqueueExclusively(new OutgoingMessage.Text(charSequence, bl));
    }

    @Override
    public CompletableFuture<WebSocket> sendBinary(ByteBuffer byteBuffer, boolean bl) {
        return this.enqueueExclusively(new OutgoingMessage.Binary(byteBuffer, bl));
    }

    @Override
    public CompletableFuture<WebSocket> sendPing(ByteBuffer byteBuffer) {
        return this.enqueueExclusively(new OutgoingMessage.Ping(byteBuffer));
    }

    @Override
    public CompletableFuture<WebSocket> sendPong(ByteBuffer byteBuffer) {
        return this.enqueueExclusively(new OutgoingMessage.Pong(byteBuffer));
    }

    @Override
    public CompletableFuture<WebSocket> sendClose(int n, String string) {
        OutgoingMessage.Close close;
        if (!StatusCodes.isLegalToSendFromClient(n)) {
            return Utils8.failedFuture(new IllegalArgumentException("statusCode: " + n));
        }
        try {
            close = new OutgoingMessage.Close(n, string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return Utils8.failedFuture(illegalArgumentException);
        }
        return this.enqueueClose(close);
    }

    private CompletableFuture<WebSocket> enqueueClose(OutgoingMessage.Close close) {
        return this.enqueue(close).whenComplete((webSocket, throwable) -> {
            boolean bl;
            try {
                this.channel.shutdownOutput();
            }
            catch (IOException iOException) {
                Log.logError(iOException);
            }
            boolean bl2 = bl = !this.closeSent.complete(null);
            if (bl) {
                throw new InternalError();
            }
        });
    }

    private CompletableFuture<WebSocket> enqueueExclusively(OutgoingMessage outgoingMessage) {
        if (this.closed.get()) {
            return Utils8.failedFuture(new IllegalStateException("Closed"));
        }
        if (!this.outstandingSend.compareAndSet(false, true)) {
            return Utils8.failedFuture(new IllegalStateException("Outstanding send"));
        }
        return this.enqueue(outgoingMessage).whenComplete((webSocket, throwable) -> this.outstandingSend.set(false));
    }

    private CompletableFuture<WebSocket> enqueue(OutgoingMessage outgoingMessage) {
        CompletableFuture<WebSocket> completableFuture = new CompletableFuture<WebSocket>();
        boolean bl = this.queue.add(Pair.pair(outgoingMessage, completableFuture));
        if (!bl) {
            throw new InternalError();
        }
        this.sendHandler.handle();
        return completableFuture;
    }

    private void sendFirst(Runnable runnable) {
        Pair<OutgoingMessage, CompletableFuture<WebSocket>> pair = this.queue.poll();
        if (pair == null) {
            runnable.run();
            return;
        }
        OutgoingMessage outgoingMessage = (OutgoingMessage)pair.first;
        CompletableFuture completableFuture = (CompletableFuture)pair.second;
        try {
            outgoingMessage.contextualize(this.context);
            Consumer<Exception> consumer = exception -> {
                if (exception == null) {
                    completableFuture.complete(this);
                } else {
                    completableFuture.completeExceptionally((Throwable)exception);
                }
                this.sendHandler.handle();
                runnable.run();
            };
            this.transmitter.send(outgoingMessage, consumer);
        }
        catch (Exception exception2) {
            completableFuture.completeExceptionally(exception2);
        }
    }

    @Override
    public void request(long l) {
        this.receiver.request(l);
    }

    @Override
    public String getSubprotocol() {
        return this.subprotocol;
    }

    @Override
    public boolean isClosed() {
        return this.closed.get();
    }

    @Override
    public void abort() throws IOException {
        try {
            this.channel.close();
        }
        finally {
            this.closed.set(true);
            this.signalClose(1006, "");
        }
    }

    public String toString() {
        return super.toString() + "[" + (this.closed.get() ? "CLOSED" : "OPEN") + "]: " + this.uri + (!this.subprotocol.isEmpty() ? ", subprotocol=" + this.subprotocol : "");
    }

    private MessageStreamConsumer messageConsumerOf(final WebSocket.Listener listener) {
        return new MessageStreamConsumer(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onText(WebSocket.MessagePart messagePart, CharSequence charSequence) {
                WebSocketImpl.this.receiver.acknowledge();
                Object object = WebSocketImpl.this.lock;
                synchronized (object) {
                    try {
                        listener.onText(WebSocketImpl.this, charSequence, messagePart);
                    }
                    catch (Exception exception) {
                        WebSocketImpl.this.signalError(exception);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onBinary(WebSocket.MessagePart messagePart, ByteBuffer byteBuffer) {
                WebSocketImpl.this.receiver.acknowledge();
                Object object = WebSocketImpl.this.lock;
                synchronized (object) {
                    try {
                        listener.onBinary(WebSocketImpl.this, byteBuffer.slice(), messagePart);
                    }
                    catch (Exception exception) {
                        WebSocketImpl.this.signalError(exception);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onPing(ByteBuffer byteBuffer) {
                WebSocketImpl.this.receiver.acknowledge();
                ByteBuffer byteBuffer2 = byteBuffer.slice();
                ByteBuffer byteBuffer3 = (ByteBuffer)ByteBuffer.allocate(byteBuffer.remaining()).put(byteBuffer).flip();
                CompletableFuture completableFuture = WebSocketImpl.this.enqueue(new OutgoingMessage.Pong(byteBuffer3));
                completableFuture.whenComplete((webSocket, throwable) -> {
                    if (throwable != null) {
                        WebSocketImpl.this.signalError(throwable);
                    }
                });
                Object object = WebSocketImpl.this.lock;
                synchronized (object) {
                    try {
                        listener.onPing(WebSocketImpl.this, byteBuffer2);
                    }
                    catch (Exception exception) {
                        WebSocketImpl.this.signalError(exception);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onPong(ByteBuffer byteBuffer) {
                WebSocketImpl.this.receiver.acknowledge();
                Object object = WebSocketImpl.this.lock;
                synchronized (object) {
                    try {
                        listener.onPong(WebSocketImpl.this, byteBuffer.slice());
                    }
                    catch (Exception exception) {
                        WebSocketImpl.this.signalError(exception);
                    }
                }
            }

            @Override
            public void onClose(int n, CharSequence charSequence) {
                WebSocketImpl.this.receiver.acknowledge();
                WebSocketImpl.this.processClose(n, charSequence.toString());
            }

            @Override
            public void onError(Exception exception) {
                if (!(exception instanceof FailWebSocketException)) {
                    WebSocketImpl.this.signalError(exception);
                } else {
                    Exception exception2 = (Exception)new ProtocolException().initCause(exception);
                    int n = ((FailWebSocketException)exception).getStatusCode();
                    WebSocketImpl.this.enqueueClose(new OutgoingMessage.Close(n, "")).whenComplete((webSocket, throwable) -> {
                        if (throwable != null) {
                            exception2.addSuppressed((Throwable)throwable);
                        }
                        try {
                            WebSocketImpl.this.channel.close();
                        }
                        catch (IOException iOException) {
                            exception2.addSuppressed(iOException);
                        }
                        finally {
                            WebSocketImpl.this.closed.set(true);
                        }
                        WebSocketImpl.this.signalError(exception2);
                    });
                }
            }

            @Override
            public void onComplete() {
                WebSocketImpl.this.processClose(1006, "");
            }
        };
    }
}

