/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jaxrpc.ee.sec.secbasic;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.porting.TSURL;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jaxrpc.common.JAXRPC_Util;
import com.sun.ts.tests.jaxrpc.ee.sec.secbasic.HelloGuest;
import com.sun.ts.tests.jaxrpc.ee.sec.secbasic.HelloProtected;
import com.sun.ts.tests.jaxrpc.ee.sec.secbasic.HelloUnprotected;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.xml.rpc.Service;
import javax.xml.rpc.Stub;

public class Client
extends ServiceEETest {
    private String hostname = null;
    private int portnum = 0;
    private String username = "";
    private String password = "";
    private String unauthUsername = "";
    private String unauthPassword = "";
    String vehicle = null;
    private static final String PROTOCOL = "http";
    private static final String HOSTNAME = "localhost";
    private static final int PORTNUM = 8000;
    private static final String WebHostProp = "webServerHost";
    private static final String WebPortProp = "webServerPort";
    private static final String UserNameProp = "user";
    private static final String PasswordProp = "password";
    private static final String unauthUserNameProp = "authuser";
    private static final String unauthPasswordProp = "authpassword";
    private static final String MODEPROP = "platform.mode";
    String modeProperty = null;
    private static final String PKG_NAME = "com.sun.ts.tests.jaxrpc.ee.sec.secbasic.";
    private static final String ENDPOINT1_URL = "secbasic.endpoint.1";
    private static final String ENDPOINT2_URL = "secbasic.endpoint.2";
    private static final String ENDPOINT3_URL = "secbasic.endpoint.3";
    private static final String WSDLLOC1_URL = "secbasic.wsdlloc.1";
    private static final String WSDLLOC2_URL = "secbasic.wsdlloc.2";
    private static final String WSDLLOC3_URL = "secbasic.wsdlloc.3";
    private static final String SERVICE_NAME1 = "BasicAuthServiceTestService1";
    private static final String PORT_NAME1 = "HelloUnprotectedPort";
    private static final String SERVICE_NAME2 = "BasicAuthServiceTestService2";
    private static final String PORT_NAME2 = "HelloProtectedPort";
    private static final String SERVICE_NAME3 = "BasicAuthServiceTestService3";
    private static final String PORT_NAME3 = "HelloGuestPort";
    private Properties props = null;
    private String request = null;
    private String url1 = null;
    private String url2 = null;
    private String url3 = null;
    private TSURL ctsurl = new TSURL();
    private URL wsdlurl1 = null;
    private URL wsdlurl2 = null;
    private URL wsdlurl3 = null;
    HelloUnprotected port1 = null;
    HelloProtected port2noid = null;
    HelloProtected port2validid = null;
    HelloProtected port2invalidid = null;
    HelloProtected port2unauthid = null;
    HelloGuest port3 = null;
    Stub stub1 = null;
    Stub stub2noid = null;
    Stub stub2validid = null;
    Stub stub2invalidid = null;
    Stub stub2unauthid = null;
    Stub stub3 = null;

    private void getTestURLs() throws Exception {
        TestUtil.logMsg((String)"Get URL's used by the test");
        String file = JAXRPC_Util.getURLFromProp(ENDPOINT1_URL);
        this.url1 = this.ctsurl.getURLString(PROTOCOL, this.hostname, this.portnum, file);
        file = JAXRPC_Util.getURLFromProp(ENDPOINT2_URL);
        this.url2 = this.ctsurl.getURLString(PROTOCOL, this.hostname, this.portnum, file);
        file = JAXRPC_Util.getURLFromProp(ENDPOINT3_URL);
        this.url3 = this.ctsurl.getURLString(PROTOCOL, this.hostname, this.portnum, file);
        file = JAXRPC_Util.getURLFromProp(WSDLLOC1_URL);
        this.wsdlurl1 = this.ctsurl.getURL(PROTOCOL, this.hostname, this.portnum, file);
        file = JAXRPC_Util.getURLFromProp(WSDLLOC2_URL);
        this.wsdlurl2 = this.ctsurl.getURL(PROTOCOL, this.hostname, this.portnum, file);
        file = JAXRPC_Util.getURLFromProp(WSDLLOC3_URL);
        this.wsdlurl3 = this.ctsurl.getURL(PROTOCOL, this.hostname, this.portnum, file);
        TestUtil.logMsg((String)("Service Endpoint1 URL: " + this.url1));
        TestUtil.logMsg((String)("Service Endpoint2 URL: " + this.url2));
        TestUtil.logMsg((String)("Service Endpoint3 URL: " + this.url3));
        TestUtil.logMsg((String)("WSDL Location URL1: " + this.wsdlurl1));
        TestUtil.logMsg((String)("WSDL Location URL2: " + this.wsdlurl2));
        TestUtil.logMsg((String)("WSDL Location URL3: " + this.wsdlurl3));
    }

    private void getUnprotectedServiceStubStandalone() throws Exception {
        this.port1 = (HelloUnprotected)JAXRPC_Util.getStub("com.sun.ts.tests.jaxrpc.ee.sec.secbasic.BasicAuthServiceTestService1", "getHelloUnprotectedPort");
        TestUtil.logMsg((String)"Cast stub to base Stub class ...");
        this.stub1 = (Stub)this.port1;
        TestUtil.logMsg((String)("Setting target endpoint to:\n" + this.url1 + " ..."));
        this.stub1._setProperty("javax.xml.rpc.service.endpoint.address", (Object)this.url1);
    }

    private void getProtectedNoIdServiceStubStandalone() throws Exception {
        this.port2noid = (HelloProtected)JAXRPC_Util.getStub("com.sun.ts.tests.jaxrpc.ee.sec.secbasic.BasicAuthServiceTestService2", "getHelloProtectedPort");
        TestUtil.logMsg((String)"Cast stub to base Stub class ...");
        this.stub2noid = (Stub)this.port2noid;
        TestUtil.logMsg((String)("Setting target endpoint to:\n" + this.url2 + " ..."));
        this.stub2noid._setProperty("javax.xml.rpc.service.endpoint.address", (Object)this.url2);
    }

    private void getProtectedValidIdServiceStubStandalone() throws Exception {
        this.port2validid = (HelloProtected)JAXRPC_Util.getStub("com.sun.ts.tests.jaxrpc.ee.sec.secbasic.BasicAuthServiceTestService2", "getHelloProtectedPort");
        TestUtil.logMsg((String)"Cast stub to base Stub class ...");
        this.stub2validid = (Stub)this.port2validid;
        TestUtil.logMsg((String)("Setting target endpoint to:\n" + this.url2 + " ..."));
        this.stub2validid._setProperty("javax.xml.rpc.service.endpoint.address", (Object)this.url2);
    }

    private void getProtectedInvalidIdServiceStubStandalone() throws Exception {
        this.port2invalidid = (HelloProtected)JAXRPC_Util.getStub("com.sun.ts.tests.jaxrpc.ee.sec.secbasic.BasicAuthServiceTestService2", "getHelloProtectedPort");
        TestUtil.logMsg((String)"Cast stub to base Stub class ...");
        this.stub2invalidid = (Stub)this.port2invalidid;
        TestUtil.logMsg((String)("Setting target endpoint to:\n" + this.url2 + " ..."));
        this.stub2invalidid._setProperty("javax.xml.rpc.service.endpoint.address", (Object)this.url2);
    }

    private void getProtectedUnauthIdServiceStubStandalone() throws Exception {
        this.port2unauthid = (HelloProtected)JAXRPC_Util.getStub("com.sun.ts.tests.jaxrpc.ee.sec.secbasic.BasicAuthServiceTestService2", "getHelloProtectedPort");
        TestUtil.logMsg((String)"Cast stub to base Stub class ...");
        this.stub2unauthid = (Stub)this.port2unauthid;
        TestUtil.logMsg((String)("Setting target endpoint to:\n" + this.url2 + " ..."));
        this.stub2unauthid._setProperty("javax.xml.rpc.service.endpoint.address", (Object)this.url2);
    }

    private void getGuestServiceStubStandalone() throws Exception {
        this.port3 = (HelloGuest)JAXRPC_Util.getStub("com.sun.ts.tests.jaxrpc.ee.sec.secbasic.BasicAuthServiceTestService3", "getHelloGuestPort");
        TestUtil.logMsg((String)"Cast stub to base Stub class ...");
        this.stub3 = (Stub)this.port3;
        TestUtil.logMsg((String)("Setting target endpoint to:\n" + this.url3 + " ..."));
        this.stub3._setProperty("javax.xml.rpc.service.endpoint.address", (Object)this.url3);
    }

    private void getUnprotectedServiceStub() throws Exception {
        try {
            InitialContext ic = new InitialContext();
            Service service1 = (Service)ic.lookup("java:comp/env/service/unprotected");
            this.port1 = (HelloUnprotected)service1.getPort(HelloUnprotected.class);
        }
        catch (Throwable t) {
            TestUtil.printStackTrace((Throwable)t);
            throw new EETest.Fault(t.toString());
        }
        this.stub1 = (Stub)this.port1;
    }

    private void getProtectedNoIdServiceStub() throws Exception {
        try {
            InitialContext ic = new InitialContext();
            Service service2noid = (Service)ic.lookup("java:comp/env/service/protectednoid");
            this.port2noid = (HelloProtected)service2noid.getPort(HelloProtected.class);
        }
        catch (Throwable t) {
            TestUtil.printStackTrace((Throwable)t);
            throw new EETest.Fault(t.toString());
        }
        this.stub2noid = (Stub)this.port2noid;
    }

    private void getProtectedValidIdServiceStub() throws Exception {
        try {
            InitialContext ic = new InitialContext();
            Service service2validid = (Service)ic.lookup("java:comp/env/service/protectedvalidid");
            this.port2validid = (HelloProtected)service2validid.getPort(HelloProtected.class);
        }
        catch (Throwable t) {
            TestUtil.printStackTrace((Throwable)t);
            throw new EETest.Fault(t.toString());
        }
        this.stub2validid = (Stub)this.port2validid;
    }

    private void getProtectedInvalidIdServiceStub() throws Exception {
        try {
            InitialContext ic = new InitialContext();
            Service service2invalidid = (Service)ic.lookup("java:comp/env/service/protectedinvalidid");
            this.port2invalidid = (HelloProtected)service2invalidid.getPort(HelloProtected.class);
        }
        catch (Throwable t) {
            TestUtil.printStackTrace((Throwable)t);
            throw new EETest.Fault(t.toString());
        }
        this.stub2invalidid = (Stub)this.port2invalidid;
    }

    private void getProtectedUnauthIdServiceStub() throws Exception {
        try {
            InitialContext ic = new InitialContext();
            Service service2unauthid = (Service)ic.lookup("java:comp/env/service/protectedunauthid");
            this.port2unauthid = (HelloProtected)service2unauthid.getPort(HelloProtected.class);
        }
        catch (Throwable t) {
            TestUtil.printStackTrace((Throwable)t);
            throw new EETest.Fault(t.toString());
        }
        this.stub2unauthid = (Stub)this.port2unauthid;
    }

    private void getGuestServiceStub() throws Exception {
        try {
            InitialContext ic = new InitialContext();
            Service service3 = (Service)ic.lookup("java:comp/env/service/guest");
            this.port3 = (HelloGuest)service3.getPort(HelloGuest.class);
        }
        catch (Throwable t) {
            TestUtil.printStackTrace((Throwable)t);
            throw new EETest.Fault(t.toString());
        }
        this.stub3 = (Stub)this.port3;
    }

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        this.props = p;
        try {
            this.hostname = p.getProperty(WebHostProp);
            this.portnum = Integer.parseInt(p.getProperty(WebPortProp));
            this.username = p.getProperty(UserNameProp);
            this.password = p.getProperty(PasswordProp);
            this.unauthUsername = p.getProperty(unauthUserNameProp);
            this.unauthPassword = p.getProperty(unauthPasswordProp);
            this.modeProperty = p.getProperty(MODEPROP);
            this.vehicle = p.getProperty("vehicle");
            if (this.modeProperty.equals("standalone")) {
                this.getTestURLs();
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"setup failed:", (Throwable)e);
        }
    }

    public void BasicAuthTest1() throws EETest.Fault {
        TestUtil.logTrace((String)"BasicAuthTest1");
        boolean pass = true;
        String expected = "Hello, foo!";
        try {
            if (this.vehicle.equals("appclient")) {
                TestUtil.logMsg((String)"Skipping BasicAuthTest1 NoId test for appclient vehicle");
                return;
            }
            TestUtil.logMsg((String)"Get stub for Protected Service Definition");
            if (this.modeProperty.equals("standalone")) {
                this.getProtectedNoIdServiceStubStandalone();
            } else {
                this.getProtectedNoIdServiceStub();
            }
            TestUtil.logMsg((String)"Invoke RPC method without authenticating");
            TestUtil.logMsg((String)"JAXRPC runtime must throw a RemoteException");
            try {
                String response = this.port2noid.helloProtected("foo");
                TestUtil.logErr((String)"Authorization was allowed - failed");
                TestUtil.logErr((String)"Did not get expected RemoteException");
                pass = false;
            }
            catch (RemoteException e) {
                TestUtil.logMsg((String)"Got expected RemoteException");
                if (e.detail != null) {
                    TestUtil.logMsg((String)e.detail.getMessage());
                }
                TestUtil.logMsg((String)"Authorization was not allowed - passed");
                TestUtil.logMsg((String)"RPC invocation was denied - passed");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("BasicAuthTest1 failed: ", e);
        }
        if (!pass) {
            throw new EETest.Fault("BasicAuthTest1 failed");
        }
    }

    public void BasicAuthTest2() throws EETest.Fault {
        boolean pass;
        block9: {
            TestUtil.logTrace((String)"BasicAuthTest2");
            pass = true;
            String expected = "Hello, foo!";
            try {
                TestUtil.logMsg((String)"Get stub for Protected Service Definition");
                if (this.modeProperty.equals("standalone")) {
                    this.getProtectedValidIdServiceStubStandalone();
                } else {
                    this.getProtectedValidIdServiceStub();
                }
                TestUtil.logMsg((String)"Invoke RPC method authenticating with a valid username/password");
                TestUtil.logMsg((String)"User is in the required security role to access the resource");
                TestUtil.logMsg((String)"JAXRPC runtime must allow access");
                TestUtil.logMsg((String)("Username=" + this.username + ", Password=" + this.password));
                if (this.modeProperty.equals("standalone")) {
                    this.stub2validid._setProperty("javax.xml.rpc.security.auth.username", (Object)this.username);
                    this.stub2validid._setProperty("javax.xml.rpc.security.auth.password", (Object)this.password);
                }
                try {
                    String response = this.port2validid.helloProtected("foo");
                    TestUtil.logMsg((String)"Authorization was allowed - passed");
                    TestUtil.logMsg((String)"RPC invocation was allowed - passed");
                    TestUtil.logMsg((String)"Checking return response");
                    if (!response.equals(expected)) {
                        TestUtil.logErr((String)("Received incorrect response - expected [" + expected + "], received: [" + response + "]"));
                        pass = false;
                        break block9;
                    }
                    TestUtil.logMsg((String)("Received expected response: [" + response + "]"));
                }
                catch (RemoteException e) {
                    TestUtil.logErr((String)"Authorization was not allowed - failed", (Throwable)e);
                    TestUtil.logErr((String)"RPC invocation was denied - failed");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
                TestUtil.printStackTrace((Throwable)e);
                throw new EETest.Fault("BasicAuthTest2 failed: ", e);
            }
        }
        if (!pass) {
            throw new EETest.Fault("BasicAuthTest2 failed");
        }
    }

    public void BasicAuthTest3() throws EETest.Fault {
        TestUtil.logTrace((String)"BasicAuthTest3");
        boolean pass = true;
        String expected = "Hello, foo!";
        try {
            if (this.vehicle.equals("appclient")) {
                TestUtil.logMsg((String)"Skipping BasicAuthTest3 InvalidId test for appclient vehicle");
                return;
            }
            TestUtil.logMsg((String)"Get stub for Protected Service Definition");
            if (this.modeProperty.equals("standalone")) {
                this.getProtectedInvalidIdServiceStubStandalone();
            } else {
                this.getProtectedInvalidIdServiceStub();
            }
            TestUtil.logMsg((String)"Invoke RPC method authenticating with an invalid username/password");
            TestUtil.logMsg((String)"Username=invalid, Password=invalid");
            TestUtil.logMsg((String)"Username=invalid, Password=invalid");
            if (this.modeProperty.equals("standalone")) {
                this.stub2invalidid._setProperty("javax.xml.rpc.security.auth.username", (Object)"invalid");
                this.stub2invalidid._setProperty("javax.xml.rpc.security.auth.password", (Object)"invalid");
            }
            TestUtil.logMsg((String)"JAXRPC runtime must throw a RemoteException");
            try {
                String response = this.port2invalidid.helloProtected("foo");
                TestUtil.logErr((String)"Did not get expected RemoteException");
                TestUtil.logErr((String)"Authorization was allowed - failed");
                TestUtil.logErr((String)"RPC invocation was allowed - failed");
                pass = false;
            }
            catch (RemoteException e) {
                TestUtil.logMsg((String)"Got expected RemoteException");
                if (e.detail != null) {
                    TestUtil.logMsg((String)e.detail.getMessage());
                }
                TestUtil.logMsg((String)"Authorization was not allowed - passed");
                TestUtil.logMsg((String)"RPC invocation was denied - passed");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("BasicAuthTest3 failed: ", e);
        }
        if (!pass) {
            throw new EETest.Fault("BasicAuthTest3 failed");
        }
    }

    public void BasicAuthTest4() throws EETest.Fault {
        TestUtil.logTrace((String)"BasicAuthTest4");
        boolean pass = true;
        String expected = "Hello, foo!";
        try {
            TestUtil.logMsg((String)"Get stub for Protected Service Definition");
            if (this.modeProperty.equals("standalone")) {
                this.getProtectedUnauthIdServiceStubStandalone();
            } else {
                this.getProtectedUnauthIdServiceStub();
            }
            TestUtil.logMsg((String)"Invoke RPC method authenticating with a valid username/password");
            TestUtil.logMsg((String)"User is not in the required security role to access the resource");
            TestUtil.logMsg((String)("Username=" + this.unauthUsername + ", Password=" + this.unauthPassword));
            if (this.modeProperty.equals("standalone")) {
                this.stub2unauthid._setProperty("javax.xml.rpc.security.auth.username", (Object)this.unauthUsername);
                this.stub2unauthid._setProperty("javax.xml.rpc.security.auth.password", (Object)this.unauthPassword);
            }
            TestUtil.logMsg((String)"JAXRPC runtime must throw a RemoteException");
            try {
                String response = this.port2unauthid.helloProtected("foo");
                TestUtil.logErr((String)"Did not get expected RemoteException");
                TestUtil.logErr((String)"Authorization was allowed - failed");
                TestUtil.logErr((String)"RPC invocation was allowed - failed");
                pass = false;
            }
            catch (RemoteException e) {
                TestUtil.logMsg((String)"Got expected RemoteException");
                if (e.detail != null) {
                    TestUtil.logMsg((String)e.detail.getMessage());
                }
                TestUtil.logMsg((String)"Authorization was not allowed - passed");
                TestUtil.logMsg((String)"RPC invocation was denied - passed");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("BasicAuthTest4 failed: ", e);
        }
        if (!pass) {
            throw new EETest.Fault("BasicAuthTest4 failed");
        }
    }

    public void BasicAuthTest5() throws EETest.Fault {
        boolean pass;
        block8: {
            TestUtil.logTrace((String)"BasicAuthTest5");
            pass = true;
            String expected = "Hello, foo!";
            try {
                TestUtil.logMsg((String)"Get stub for Unprotected Service Definition");
                if (this.modeProperty.equals("standalone")) {
                    this.getUnprotectedServiceStubStandalone();
                } else {
                    this.getUnprotectedServiceStub();
                }
                TestUtil.logMsg((String)"Invoke RPC method without authenticating");
                TestUtil.logMsg((String)"JAXRPC runtime must allow access without the need to authenticate user");
                try {
                    String response = this.port1.helloUnprotected("foo");
                    TestUtil.logMsg((String)"Authorization was allowed - passed");
                    TestUtil.logMsg((String)"RPC invocation was allowed - passed");
                    TestUtil.logMsg((String)"Checking return response");
                    if (!response.equals(expected)) {
                        TestUtil.logErr((String)("Received incorrect response - expected [" + expected + "], received: [" + response + "]"));
                        pass = false;
                        break block8;
                    }
                    TestUtil.logMsg((String)("Received expected response: [" + response + "]"));
                }
                catch (RemoteException e) {
                    TestUtil.logErr((String)"Authorization was not allowed - failed", (Throwable)e);
                    TestUtil.logErr((String)"RPC invocation was denied - failed");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
                TestUtil.printStackTrace((Throwable)e);
                throw new EETest.Fault("BasicAuthTest5 failed: ", e);
            }
        }
        if (!pass) {
            throw new EETest.Fault("BasicAuthTest5 failed");
        }
    }

    public void BasicAuthTest6() throws EETest.Fault {
        TestUtil.logTrace((String)"BasicAuthTest6");
        boolean pass = true;
        String expected = "Hello, foo!";
        try {
            TestUtil.logMsg((String)"Get stub for Guest Service Definition");
            if (this.modeProperty.equals("standalone")) {
                this.getGuestServiceStubStandalone();
            } else {
                this.getGuestServiceStub();
            }
            TestUtil.logMsg((String)"Invoke RPC method authenticating with a valid username/password");
            TestUtil.logMsg((String)("Username=" + this.unauthUsername + ", Password=" + this.unauthPassword));
            if (this.modeProperty.equals("standalone")) {
                this.stub3._setProperty("javax.xml.rpc.security.auth.username", (Object)this.unauthUsername);
                this.stub3._setProperty("javax.xml.rpc.security.auth.password", (Object)this.unauthPassword);
            }
            TestUtil.logMsg((String)"JAXRPC runtime must allow access since all users have guest access");
            try {
                String response = this.port3.helloGuest("foo");
                TestUtil.logMsg((String)"Authorization was allowed - passed");
                TestUtil.logMsg((String)"RPC invocation was allowed - passed");
            }
            catch (RemoteException e) {
                TestUtil.logErr((String)"Authorization was not allowed - failed", (Throwable)e);
                TestUtil.logErr((String)"RPC invocation was denied - failed");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("BasicAuthTest6 failed: ", e);
        }
        if (!pass) {
            throw new EETest.Fault("BasicAuthTest6 failed");
        }
    }

    public void cleanup() throws EETest.Fault {
        TestUtil.logMsg((String)"cleanup");
    }
}

