/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.interop.csiv2.ew_ssln_ssln_upn_ccid.reverse;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.porting.TSHttpsURLConnection;
import com.sun.ts.lib.porting.TSLoginContext;
import com.sun.ts.lib.porting.TSURL;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.interop.csiv2.common.CSIv2AppClient;
import com.sun.ts.tests.interop.csiv2.common.CSIv2Log;
import com.sun.ts.tests.interop.csiv2.common.CSIv2Util;
import com.sun.ts.tests.interop.csiv2.common.validation.CSIv2LogValidator;
import com.sun.ts.tests.interop.csiv2.common.validation.IOR4ValidationStrategy;
import com.sun.ts.tests.interop.csiv2.common.validation.ResponseValidationStrategy;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Properties;

public class Client
extends EETest {
    private Properties props = null;
    private TSURL ctsurl = new TSURL();
    private URL url = null;
    private URLConnection urlConn = null;
    private TSHttpsURLConnection ctsHttpsURLConn = null;
    private static final String WEBSERVERHOSTPROP = "webServerHost";
    private static final String WEBSERVERPORTPROP = "securedWebServicePort";
    private String SERVLET = "/interop_csiv2_ew_ssln_ssln_upn_ccid_r_web/CSIv2ServletTest";
    private String webServerHost = "unknown";
    private int webServerPort = 8000;

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logMsg((String)"Setup");
        boolean pass = true;
        this.props = p;
        try {
            this.webServerHost = p.getProperty(WEBSERVERHOSTPROP);
            if (this.webServerHost == null) {
                pass = false;
            } else if (this.webServerHost.equals("")) {
                pass = false;
            }
            try {
                this.webServerPort = Integer.parseInt(p.getProperty(WEBSERVERPORTPROP));
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                pass = false;
            }
            TestUtil.logMsg((String)("webServerHost = " + this.webServerHost));
            TestUtil.logMsg((String)("webServerPort = " + this.webServerPort));
            if (!pass) {
                TestUtil.logErr((String)"Please specify host & port of web server in ts.jte file: webServerHost, securedWebServicePort");
                throw new EETest.Fault("Setup failed:");
            }
            TestUtil.logMsg((String)"Setup ok");
        }
        catch (Exception e) {
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    public void ew_ssln_ssln_upn_ccid_sb_sb_testid4a() throws EETest.Fault {
        boolean pass = true;
        String testName = "ew_ssln_ssln_upn_ccid_sb_sb_testid4a_reverse";
        TestUtil.logMsg((String)testName);
        try {
            TSLoginContext clc = new TSLoginContext();
            clc.login(this.props.getProperty("certLoginUserAlias"), System.getProperty("javax.net.ssl.keyStore"), System.getProperty("javax.net.ssl.keyStorePassword"));
        }
        catch (Exception e) {
            TestUtil.logMsg((String)e.getMessage());
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault(testName + " TSCertLogin failed");
        }
        CSIv2Log log = CSIv2Log.getLog();
        log.purge();
        log.enableLoggingInterceptor(true, true);
        log.startLog();
        log.logStartAssertion(testName);
        ArrayList<String> chain = new ArrayList<String>();
        chain.add("java:comp/env/ejb/LocalSession");
        chain.add("java:comp/env/ejb/RemoteSession");
        TestUtil.logMsg((String)"Client initiated.");
        CSIv2AppClient appClient = new CSIv2AppClient();
        TestUtil.logMsg((String)"LocalSessionBean (RI) ====> RemoteSessionBean (VI).");
        appClient.invoke(chain, this.props);
        TestUtil.logMsg((String)"Client completed.");
        log.logEndAssertion();
        log.endLog();
        log.enableLoggingInterceptor(false, false);
        String logContents = log.getLogContents();
        TestUtil.logMsg((String)"Log contents:");
        TestUtil.logMsg((String)logContents);
        log.purge();
        pass = CSIv2LogValidator.validate(testName, logContents, new IOR4ValidationStrategy(true, 12), null, new ResponseValidationStrategy(true, false));
        if (!pass) {
            throw new EETest.Fault(testName + " failed");
        }
    }

    public void ew_ssln_ssln_upn_ccid_wb_sb_testid4a() throws EETest.Fault {
        boolean pass = true;
        String testName = "ew_ssln_ssln_upn_ccid_wb_sb_testid4a_reverse";
        TestUtil.logMsg((String)testName);
        CSIv2Log log = CSIv2Log.getLog();
        log.purge();
        log.enableLoggingInterceptor(true, true);
        log.startLog();
        log.logStartAssertion(testName);
        TestUtil.logMsg((String)"Client initiated.");
        TestUtil.logMsg((String)"WebClient (RI) ====> RemoteSessionBean (VI).");
        try {
            this.url = this.ctsurl.getURL("https", this.webServerHost, this.webServerPort, this.SERVLET);
            this.props.setProperty("CHAIN", "java:comp/env/ejb/RemoteSession");
            TestUtil.logMsg((String)"Send http request to WebClient");
            this.ctsHttpsURLConn = CSIv2Util.sendPostDataHttps(this.props, this.url);
            TestUtil.logMsg((String)"Get http response from WebClient");
            Properties p = CSIv2Util.getResponseProperties(this.ctsHttpsURLConn);
            String passStr = p.getProperty("TESTRESULT");
            if (passStr.equals("false")) {
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
        }
        TestUtil.logMsg((String)"Client completed.");
        log.logEndAssertion();
        log.endLog();
        log.enableLoggingInterceptor(false, false);
        String logContents = log.getLogContents();
        TestUtil.logMsg((String)"Log contents:");
        TestUtil.logMsg((String)logContents);
        log.purge();
        pass = CSIv2LogValidator.validate(testName, logContents, new IOR4ValidationStrategy(true, 12), null, new ResponseValidationStrategy(true, false));
        if (!pass) {
            throw new EETest.Fault(testName + " failed");
        }
    }

    public void cleanup() throws EETest.Fault {
        TestUtil.logMsg((String)"Cleanup ok");
    }
}

