/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jpa.core.annotations.discriminatorValue;

import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jpa.common.PMClientBase;
import com.sun.ts.tests.jpa.core.annotations.discriminatorValue.PartProduct;
import com.sun.ts.tests.jpa.core.annotations.discriminatorValue.PricedPartProduct2;
import com.sun.ts.tests.jpa.core.annotations.discriminatorValue.Product;
import java.util.Properties;

public class Client
extends PMClientBase {
    @Override
    public void setup(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logTrace((String)"setup");
        try {
            super.setup(args, p);
            this.removeTestData();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception: ", (Throwable)e);
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    private PricedPartProduct2 newPricedPartProduct(String testName) {
        PricedPartProduct2 product = new PricedPartProduct2();
        product.setId(testName);
        product.setName(testName);
        product.setPartNumber(1L);
        product.setPrice(1.0);
        product.setQuantity(1);
        return product;
    }

    private PartProduct newPartProduct(String testName) {
        PartProduct product = new PartProduct();
        product.setId(testName);
        product.setName(testName);
        product.setPartNumber(1L);
        product.setQuantity(1);
        return product;
    }

    private Product newProduct(String testName) {
        Product product = new Product();
        product.setId(testName);
        product.setName(testName);
        product.setQuantity(1);
        return product;
    }

    public void integerDiscriminatorValueTest() throws EETest.Fault {
        boolean pass = false;
        String testName = "integerDiscriminatorValueTest";
        try {
            this.getEntityTransaction().begin();
            PricedPartProduct2 p1 = this.newPricedPartProduct("integerDiscriminatorValueTest");
            this.getEntityManager().persist((Object)p1);
            this.getEntityManager().flush();
            this.clearCache();
            PricedPartProduct2 p2 = (PricedPartProduct2)this.getEntityManager().find(PricedPartProduct2.class, (Object)"integerDiscriminatorValueTest");
            TestUtil.logTrace((String)"finding PricedPartProduct2 with id 'integerDiscriminatorValueTest'");
            if (p1.equals((Object)p2)) {
                TestUtil.logTrace((String)("Received expected PricedPartProduct2:" + p2));
                pass = true;
            } else {
                TestUtil.logErr((String)"Did not get expected result.");
                TestUtil.logErr((String)("Expected:" + p1));
                TestUtil.logErr((String)("Actual:" + p2));
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("integerDiscriminatorValueTest Failed");
        }
    }

    public void discriminatorValueTest() throws EETest.Fault {
        boolean pass1 = false;
        String testName = "discriminatorValueTest";
        try {
            this.getEntityTransaction().begin();
            PartProduct p1 = this.newPartProduct("discriminatorValueTest");
            this.getEntityManager().persist((Object)p1);
            this.getEntityManager().flush();
            this.clearCache();
            PartProduct p2 = (PartProduct)this.getEntityManager().find(PartProduct.class, (Object)"discriminatorValueTest");
            TestUtil.logTrace((String)"finding PartProduct with id 'discriminatorValueTest'");
            if (p1.equals((Object)p2)) {
                TestUtil.logTrace((String)("Received expected PartProduct:" + p2));
                pass1 = true;
            } else {
                TestUtil.logErr((String)"Did not get expected result.");
                TestUtil.logErr((String)("Expected:" + p1));
                TestUtil.logErr((String)("Actual:" + p2));
            }
            Product p3 = this.newProduct("discriminatorValueTest");
            this.getEntityManager().persist((Object)p3);
            this.getEntityManager().flush();
            this.clearCache();
            Product p4 = (Product)this.getEntityManager().find(Product.class, (Object)"discriminatorValueTest");
            TestUtil.logTrace((String)"finding Product with id 'discriminatorValueTest'");
            if (p3.equals((Object)p4)) {
                TestUtil.logTrace((String)("Received expected Product:" + p2));
                pass1 = true;
            } else {
                TestUtil.logErr((String)"Did not get expected result.");
                TestUtil.logErr((String)("Expected:" + p3));
                TestUtil.logErr((String)("Actual:" + p4));
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        if (!pass1) {
            throw new EETest.Fault("discriminatorValueTest Failed");
        }
    }

    @Override
    public void cleanup() throws EETest.Fault {
        TestUtil.logTrace((String)"cleanup");
        this.removeTestData();
        TestUtil.logTrace((String)"cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        TestUtil.logTrace((String)"removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM PRODUCT_TABLE_DISCRIMINATOR").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM PRODUCT_TABLE").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

