/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jsonb;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.tests.jsonb.TypeContainer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.function.BiPredicate;
import java.util.regex.Pattern;
import javax.json.bind.Jsonb;
import javax.json.bind.JsonbBuilder;

public class MappingTester<T> {
    private static final String JSON_PATTERN_PREFIX = "\\{\\s*";
    private static final String JSON_PATTERN_PROPERTY = "\"instance\"\\s*:\\s*";
    private static final String JSON_PATTERN_SUFFIX = "\\s*\\}";
    private static final String JSON_PREFIX = "{ ";
    private static final String JSON_PROPERTY = "\"instance\" : ";
    private static final String JSON_SUFFIX = " }";
    private static final int MAX_BIT_SIZE = 53;
    private static final int MIN_RANGE = -1022;
    private static final int MAX_RANGE = 1023;
    private final Jsonb jsonb = JsonbBuilder.create();
    private final Class<? extends TypeContainer<T>> typeContainerClass;
    private final boolean nillable;
    private T testValue;
    private BiPredicate<T, T> testUnmarshall = (f, s) -> f.equals(s);
    private String fixedRegExp = null;

    public MappingTester(Class<? extends TypeContainer<T>> typeContainerClass) {
        this(typeContainerClass, true);
    }

    public MappingTester(Class<? extends TypeContainer<T>> typeContainerClass, boolean nillable) {
        this.typeContainerClass = typeContainerClass;
        this.nillable = nillable;
    }

    public Status test(T value, String expectedRepresentation) throws EETest.Fault {
        try {
            this.testValue = value;
            return MappingTester.combine(this.testMarshalling(value, expectedRepresentation), this.testMarshallingToStream(value, expectedRepresentation), this.testMarshallingToWriter(value, expectedRepresentation), this.testMarshallingByType(value, expectedRepresentation), this.testMarshallingByTypeToStream(value, expectedRepresentation), this.testMarshallingByTypeToWriter(value, expectedRepresentation), this.testUnmarshallingByClass(value, expectedRepresentation), this.testUnmarshallingByClassFromStream(value, expectedRepresentation), this.testUnmarshallingByClassFromReader(value, expectedRepresentation), this.testUnmarshallingByType(value, expectedRepresentation), this.testUnmarshallingByTypeFromStream(value, expectedRepresentation), this.testUnmarshallingByTypeFromReader(value, expectedRepresentation));
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new EETest.Fault(e.getMessage(), e);
        }
    }

    public static Status combine(Status ... statusValues) throws EETest.Fault {
        if (statusValues.length == 0) {
            throw new EETest.Fault("No status information provided.");
        }
        StringBuilder failures = new StringBuilder();
        for (Status status : statusValues) {
            if (!status.isFailed() && !status.isError()) continue;
            failures.append('{').append(status.getReason()).append('}');
        }
        if (failures.length() == 0) {
            return Status.passed((String)"OK");
        }
        throw new EETest.Fault(failures.toString());
    }

    private String getExpectedJsonString(String expectedRepresentation) {
        if (this.nillable || !expectedRepresentation.isEmpty()) {
            return "\\{\\s*\"instance\"\\s*:\\s*" + this.fixExpectedRepresentation(expectedRepresentation) + JSON_PATTERN_SUFFIX;
        }
        return "\\{\\s*\\s*\\}";
    }

    private String getJsonString(String expectedRepresentation) {
        if (this.nillable || !expectedRepresentation.isEmpty()) {
            return "{ \"instance\" : " + expectedRepresentation + JSON_SUFFIX;
        }
        return "{  }";
    }

    private String fixExpectedRepresentation(String representation) {
        if (this.fixedRegExp != null) {
            return this.fixedRegExp;
        }
        representation = representation.replace("E38", "E[\\+]?\\+38");
        if (!Number.class.isInstance(this.testValue)) {
            representation = Pattern.quote(representation);
        } else if (Long.class.isInstance(this.testValue)) {
            Long longTestValue = (Long)Long.class.cast(this.testValue);
            if (!MappingTester.isIEEE754(BigDecimal.valueOf(longTestValue))) {
                representation = this.quote(representation);
            }
        } else if (BigDecimal.class.isInstance(this.testValue)) {
            if (!MappingTester.isIEEE754((BigDecimal)this.testValue)) {
                representation = this.quote(representation);
            }
        } else if (BigInteger.class.isInstance(this.testValue) && !MappingTester.isIEEE754(new BigDecimal((BigInteger)this.testValue))) {
            representation = this.quote(representation);
        }
        return representation;
    }

    private Status testMarshalling(T value, String expectedRepresentation) throws IllegalAccessException, InstantiationException {
        TypeContainer<T> container = this.typeContainerClass.newInstance();
        container.setInstance(value);
        String jsonString = this.jsonb.toJson(container);
        if (jsonString.matches(this.getExpectedJsonString(expectedRepresentation))) {
            return Status.passed((String)"OK");
        }
        System.out.append("jsonString ").println(jsonString);
        System.out.append("does not match expected ").println(this.getExpectedJsonString(expectedRepresentation));
        return Status.failed((String)("[testMarshalling] - Failed to correctly marshal " + value.getClass().getName() + " property with value " + value));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Status testMarshallingToStream(T value, String expectedRepresentation) throws IllegalAccessException, InstantiationException {
        TypeContainer<T> container = this.typeContainerClass.newInstance();
        container.setInstance(value);
        try (ByteArrayOutputStream stream = new ByteArrayOutputStream();){
            this.jsonb.toJson(container, (OutputStream)stream);
            String jsonString = new String(stream.toByteArray(), StandardCharsets.UTF_8);
            if (jsonString.matches(this.getExpectedJsonString(expectedRepresentation))) {
                Status status2 = Status.passed((String)"OK");
                return status2;
            }
            System.out.append("jsonString ").println(jsonString);
            System.out.append("does not match expected ").println(this.getExpectedJsonString(expectedRepresentation));
            Status status = Status.failed((String)("[testMarshallingToStream] - Failed to correctly marshal " + value.getClass().getName() + " property with value " + value));
            return status;
        }
        catch (IOException e) {
            return Status.error((String)e.getMessage());
        }
    }

    /*
     * Exception decompiling
     */
    private Status testMarshallingToWriter(T value, String expectedRepresentation) throws IllegalAccessException, InstantiationException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Status testMarshallingByType(T value, String expectedRepresentation) throws IllegalAccessException, InstantiationException {
        TypeContainer<T> container = this.typeContainerClass.newInstance();
        container.setInstance(value);
        String jsonString = this.jsonb.toJson(container, TypeContainer.class);
        if (jsonString.matches(this.getExpectedJsonString(expectedRepresentation))) {
            return Status.passed((String)"OK");
        }
        System.out.append("jsonString ").println(jsonString);
        System.out.append("does not match expected ").println(this.getExpectedJsonString(expectedRepresentation));
        return Status.failed((String)("[testMarshallingByType] - Failed to correctly marshal " + value.getClass().getName() + " property with value " + value));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Status testMarshallingByTypeToStream(T value, String expectedRepresentation) throws IllegalAccessException, InstantiationException {
        TypeContainer<T> container = this.typeContainerClass.newInstance();
        container.setInstance(value);
        try (ByteArrayOutputStream stream = new ByteArrayOutputStream();){
            this.jsonb.toJson(container, TypeContainer.class, (OutputStream)stream);
            String jsonString = new String(stream.toByteArray(), StandardCharsets.UTF_8);
            if (jsonString.matches(this.getExpectedJsonString(expectedRepresentation))) {
                Status status2 = Status.passed((String)"OK");
                return status2;
            }
            System.out.append("jsonString ").println(jsonString);
            System.out.append("does not match expected ").println(this.getExpectedJsonString(expectedRepresentation));
            Status status = Status.failed((String)("[testMarshallingByTypeToStream] - Failed to correctly marshal " + value.getClass().getName() + " property with value " + value));
            return status;
        }
        catch (IOException e) {
            return Status.error((String)e.getMessage());
        }
    }

    /*
     * Exception decompiling
     */
    private Status testMarshallingByTypeToWriter(T value, String expectedRepresentation) throws IllegalAccessException, InstantiationException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Status testUnmarshallingByClass(T value, String expectedRepresentation) {
        String jsonString = this.getJsonString(expectedRepresentation);
        TypeContainer typeContainer = (TypeContainer)this.jsonb.fromJson(jsonString, this.typeContainerClass);
        if (this.testUnmarshall(value, typeContainer.getInstance())) {
            return Status.passed((String)"OK");
        }
        System.out.append("value ").println(typeContainer.getInstance());
        System.out.append("does not match expected ").println(value);
        return Status.failed((String)("[testUnmarshallingByClass] - Failed to correctly unmarshal " + value.getClass().getName() + " property with value " + value));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Status testUnmarshallingByClassFromStream(T value, String expectedRepresentation) {
        String jsonString = this.getJsonString(expectedRepresentation);
        try (ByteArrayInputStream stream = new ByteArrayInputStream(jsonString.getBytes(StandardCharsets.UTF_8));){
            TypeContainer typeContainer = (TypeContainer)this.jsonb.fromJson((InputStream)stream, this.typeContainerClass);
            if (this.testUnmarshall(value, typeContainer.getInstance())) {
                Status status2 = Status.passed((String)"OK");
                return status2;
            }
            System.out.append("value ").println(typeContainer.getInstance());
            System.out.append("does not match expected ").println(value);
            Status status = Status.failed((String)("[testUnmarshallingByClassFromStream] - Failed to correctly unmarshal " + value.getClass().getName() + " property with value " + value));
            return status;
        }
        catch (IOException e) {
            return Status.error((String)e.getMessage());
        }
    }

    /*
     * Exception decompiling
     */
    private Status testUnmarshallingByClassFromReader(T value, String expectedRepresentation) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Status testUnmarshallingByType(T value, String expectedRepresentation) {
        String jsonString = this.getJsonString(expectedRepresentation);
        TypeContainer typeContainer = (TypeContainer)this.jsonb.fromJson(jsonString, this.typeContainerClass);
        if (this.testUnmarshall(value, typeContainer.getInstance())) {
            return Status.passed((String)"OK");
        }
        System.out.append("value ").println(typeContainer.getInstance());
        System.out.append("does not match expected ").println(value);
        return Status.failed((String)("[testUnmarshallingByType] - Failed to correctly unmarshal " + value.getClass().getName() + " property with value " + value));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Status testUnmarshallingByTypeFromStream(T value, String expectedRepresentation) {
        String jsonString = this.getJsonString(expectedRepresentation);
        try (ByteArrayInputStream stream = new ByteArrayInputStream(jsonString.getBytes(StandardCharsets.UTF_8));){
            TypeContainer typeContainer = (TypeContainer)this.jsonb.fromJson((InputStream)stream, this.typeContainerClass);
            if (this.testUnmarshall(value, typeContainer.getInstance())) {
                Status status2 = Status.passed((String)"OK");
                return status2;
            }
            System.out.append("value ").println(typeContainer.getInstance());
            System.out.append("does not match expected ").println(value);
            Status status = Status.failed((String)("[testUnmarshallingByTypeFromStream] - Failed to correctly unmarshal " + value.getClass().getName() + " property with value " + value));
            return status;
        }
        catch (IOException e) {
            return Status.error((String)e.getMessage());
        }
    }

    /*
     * Exception decompiling
     */
    private Status testUnmarshallingByTypeFromReader(T value, String expectedRepresentation) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected boolean testUnmarshall(T value, T fromJson) {
        return this.testUnmarshall.test(value, fromJson);
    }

    public MappingTester<T> setUnmarshallTestPredicate(BiPredicate<T, T> testPredicate) {
        this.testUnmarshall = testPredicate;
        return this;
    }

    public MappingTester<T> setMarshallExpectedRegExp(String regExp) {
        this.fixedRegExp = regExp;
        return this;
    }

    private static boolean isIEEE754(BigDecimal value) {
        int scale = value.scale();
        int valBits = value.unscaledValue().abs().bitLength();
        int intBitsScaled = value.toBigInteger().bitLength();
        return valBits <= 53 && intBitsScaled <= 53 && -1022 <= scale && scale <= 1023;
    }

    private String quote(String value) {
        return new StringBuilder(value.length() + 2).append('\"').append(value).append('\"').toString();
    }
}

