/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb.ee.timer.entity.bmp;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.ejb.ee.timer.common.TimerImpl;
import com.sun.ts.tests.ejb.ee.timer.common.TimerInfo;
import com.sun.ts.tests.ejb.ee.timer.entity.bmp.DAOBean;
import com.sun.ts.tests.ejb.ee.timer.helper.FlagStore;
import com.sun.ts.tests.ejb.ee.timer.helper.FlagStoreHome;
import java.io.Serializable;
import java.util.Properties;
import javax.ejb.EJBContext;
import javax.ejb.TimedObject;
import javax.ejb.Timer;
import javax.ejb.TimerHandle;
import javax.ejb.TimerService;
import javax.jms.Queue;
import javax.jms.QueueConnectionFactory;

public class TestBeanEJB
extends DAOBean
implements TimedObject {
    private static final String queueName = "java:comp/env/jms/MyQueue";
    private static final String queueFactoryName = "java:comp/env/jms/MyQueueConnectionFactory";
    private FlagStoreHome flagStoreHome;
    private FlagStore flagStoreRef;
    private static final String role = "Manager";
    private static final String[] expected = new String[]{"true", "true", "true", "true", "true", "true", "false", "false", "false", "false", "false", "false", "false", "true", "true", "true", "true", "true", "true"};
    private static final boolean[] skip = new boolean[]{false, false, false, false, false, false, true, true, true, true, true, true, true, true, false, false, false, false, false};

    public TestBeanEJB() {
        TestUtil.logTrace((String)"TestBeanEJB no arg constructor");
    }

    public void ejbTimeout(Timer timer) {
        String msg;
        int timeoutAction;
        QueueConnectionFactory qcFactory;
        Queue queue;
        TestUtil.logTrace((String)("EJB_TIMEOUT: ejbTimeout called at " + System.currentTimeMillis()));
        try {
            Serializable sz = timer.getInfo();
            if (!(sz instanceof Integer)) {
                TestUtil.logTrace((String)"EJB_TIMEOUT: No action required");
                return;
            }
            TestUtil.logTrace((String)"EJB_TIMEOUT: finding jms resources...");
            queue = (Queue)this.nctx.lookup(queueName);
            qcFactory = (QueueConnectionFactory)this.nctx.lookup(queueFactoryName);
            timeoutAction = (Integer)sz;
            TestUtil.logTrace((String)("EJB_TIMEOUT: timeoutAction is " + timeoutAction + " at " + System.currentTimeMillis()));
        }
        catch (Exception e) {
            TimerImpl.handleException("ejbTimeout initialization", e);
            return;
        }
        switch (timeoutAction) {
            case -1: {
                TestUtil.logTrace((String)"EJB_TIMEOUT: No message sent - return");
                return;
            }
            case 1: {
                msg = "hello from ejbTimeout";
                TestUtil.logTrace((String)"EJB_TIMEOUT: Access OK, sending JMS message");
                break;
            }
            case 2: {
                msg = TimerImpl.accessCheckedMethod(this.nctx) ? "checked method successfully accessed in ejbTimeout" : "checked method access failed in ejbTimeout";
                TestUtil.logTrace((String)"EJB_TIMEOUT: Sending results of attempt to access checked method...");
                break;
            }
            case 3: {
                try {
                    TestUtil.logTrace((String)"EJB_TIMEOUT: finding flag store bean");
                    this.flagStoreHome = (FlagStoreHome)this.nctx.lookup("java:comp/env/ejb/FlagStore", FlagStoreHome.class);
                    this.flagStoreRef = this.flagStoreHome.findByPrimaryKey(new Integer(2));
                    TestUtil.logTrace((String)"EJB_TIMEOUT: checking flag in flag store bean");
                    if (!this.flagStoreRef.getRequiresNewAccessFlag()) {
                        TestUtil.logTrace((String)"EJB_TIMEOUT: flag is false - set it and rollback");
                        this.flagStoreRef.setRequiresNewAccessFlag(true);
                        this.ectx.setRollbackOnly();
                        return;
                    }
                    TestUtil.logTrace((String)"EJB_TIMEOUT: flag is true - send a message");
                    if (this.flagStoreRef != null) {
                        this.flagStoreRef.remove();
                    }
                    msg = "ejbTimeout has been successfully retried";
                }
                catch (Exception e) {
                    TimerImpl.handleException("ejbTimeout retry", e);
                    TestUtil.logTrace((String)"removing flag store bean");
                    if (this.flagStoreRef != null) {
                        try {
                            this.flagStoreRef.remove();
                        }
                        catch (Exception re) {
                            TimerImpl.handleException("exception removing FlagStore bean", e);
                        }
                    }
                    msg = "Retry of ejbTimeout resulted in an exception";
                }
                break;
            }
            case 4: {
                try {
                    TestUtil.logTrace((String)"EJB_TIMEOUT: finding flag store bean");
                    this.flagStoreHome = (FlagStoreHome)this.nctx.lookup("java:comp/env/ejb/FlagStore", FlagStoreHome.class);
                    this.flagStoreRef = this.flagStoreHome.findByPrimaryKey(new Integer(2));
                    TestUtil.logTrace((String)"EJB_TIMEOUT: checking flags in flag store bean");
                    if (!this.flagStoreRef.getRequiresNewAccessFlag()) {
                        if (this.flagStoreRef.getRequiredAccessFlag()) {
                            TestUtil.logErr((String)"EJB_TIMEOUT: Unexpected value of Required flag: true when RequiresNew flag is false");
                            msg = "Transaction rollback failed in ejbTimeout";
                            break;
                        }
                        TestUtil.logTrace((String)"EJB_TIMEOUT: both flags unset, set them and rollback");
                        this.flagStoreRef.setRequiresNewAccessFlag(true);
                        this.flagStoreRef.setRequiredAccessFlag(true);
                        this.ectx.setRollbackOnly();
                        return;
                    }
                    TestUtil.logTrace((String)"EJB_TIMEOUT: RequiresNew flag is true - checking the Required flag");
                    if (this.flagStoreRef.getRequiredAccessFlag()) {
                        TestUtil.logErr((String)"EJB_TIMEOUT: Unexpected value of Required flag: true when RequiresNew flag is true");
                        msg = "Transaction rollback failed in ejbTimeout";
                        break;
                    }
                    if (this.flagStoreRef != null) {
                        this.flagStoreRef.remove();
                    }
                    msg = "Transaction has been successfully rolled back in ejbTimeout";
                }
                catch (Exception e) {
                    TimerImpl.handleException("ejbTimeout rollback", e);
                    TestUtil.logTrace((String)"removing flag store bean");
                    if (this.flagStoreRef != null) {
                        try {
                            this.flagStoreRef.remove();
                        }
                        catch (Exception re) {
                            TimerImpl.handleException("exception removing FlagStore bean", e);
                        }
                    }
                    msg = "Transaction rollback failed in ejbTimeout";
                }
                break;
            }
            case 5: {
                TestUtil.logTrace((String)"EJB_TIMEOUT: Getting timer handle...");
                TimerHandle handle = TimerImpl.getTimerHandleFromEjbTimeout(this.ectx.getTimerService(), 5);
                if (handle == null) {
                    TestUtil.logErr((String)"EJB_TIMEOUT: Null handle received from getTimerHandleFromEjbTimeout()");
                    msg = "Timer handle serialization failed in ejbTimeout";
                }
                TestUtil.logTrace((String)"EJB_TIMEOUT: Verifying handle is serializable...");
                if (!TimerImpl.isSerializable(handle)) {
                    TestUtil.logErr((String)"EJB_TIMEOUT: Timer handle is not serializable");
                    msg = "Timer handle serialization failed in ejbTimeout";
                    break;
                }
                TestUtil.logTrace((String)"EJB_TIMEOUT: Getting deserialized handle...");
                TimerHandle deserializedHandle = TimerImpl.getDeserializedHandle(handle);
                TestUtil.logTrace((String)"EJB_TIMEOUT: Verifying timers are identical...");
                if (!TimerImpl.timersAreIdentical(handle, deserializedHandle)) {
                    TestUtil.logErr((String)"EJB_TIMEOUT: Timers are not identical");
                    msg = "Timer handle serialization failed in ejbTimeout";
                    break;
                }
                msg = "Timer handle successfully serialized in ejbTimeout";
                break;
            }
            case 6: {
                Properties props = TimerImpl.doOperationTests((EJBContext)this.ectx, this.nctx, timer, skip, role, 2);
                boolean results = TimerImpl.checkOperationsTestResults(props, expected, skip);
                msg = results ? "allowed methods test successful in ejbTimeout" : "allowed methods test failed in ejbTimeout";
                break;
            }
            default: {
                msg = "Invalid action specified in ejbTimeout";
            }
        }
        TestUtil.logTrace((String)("EJB_TIMEOUT: Sending message at " + System.currentTimeMillis()));
        TimerImpl.sendMessage(queue, qcFactory, msg);
    }

    public boolean getInfoStrAndCancel(int timerType) {
        String infoStr = "info";
        try {
            TimerService ts = this.ectx.getTimerService();
            TestUtil.logTrace((String)("Initializing timer at " + System.currentTimeMillis()));
            TimerHandle handle = TimerImpl.createTimerHandle(timerType, (Serializable)((Object)infoStr), ts);
            String returnStr = (String)((Object)TimerImpl.getInfo(handle));
            if (!returnStr.equals(infoStr)) {
                TestUtil.logErr((String)("getInfo failed: input = " + infoStr + ", return value = " + returnStr));
                return false;
            }
            TestUtil.logTrace((String)("Timer info is " + infoStr));
            TimerImpl.cancelTimer(handle);
            TestUtil.logTrace((String)"Timer cancelled.");
        }
        catch (Exception e) {
            TimerImpl.handleException("getInfoStrAndCancel", e);
            return false;
        }
        return true;
    }

    public boolean getInfoClassAndCancel(int timerType) {
        try {
            TimerService ts = this.ectx.getTimerService();
            TestUtil.logTrace((String)("Initializing timer at " + System.currentTimeMillis()));
            TimerInfo infoClass = new TimerInfo("string", 1, true, 3.1415926);
            TimerHandle handle = TimerImpl.createTimerHandle(timerType, infoClass, ts);
            TimerInfo returnClass = (TimerInfo)TimerImpl.getInfo(handle);
            if (!returnClass.equals(infoClass)) {
                TestUtil.logErr((String)("getInfo failed: input = " + infoClass.toString() + ", return value = " + returnClass.toString()));
                return false;
            }
            TestUtil.logTrace((String)("Timer info is " + infoClass.toString()));
            TimerImpl.cancelTimer(handle);
            TestUtil.logTrace((String)"Timer cancelled.");
        }
        catch (Exception e) {
            TimerImpl.handleException("getInfoClassAndCancel", e);
            return false;
        }
        return true;
    }

    public boolean initializeTimer(int timerType, int timerAction) {
        TimerHandle handle;
        try {
            TimerService ts = this.ectx.getTimerService();
            TestUtil.logTrace((String)("Initializing timer at " + System.currentTimeMillis()));
            handle = TimerImpl.createTimerHandle(timerType, new Integer(timerAction), ts);
        }
        catch (Exception e) {
            TimerImpl.handleException("initializeTimer", e);
            return false;
        }
        return handle != null;
    }

    public TimerHandle initializeTimerHandle(int timerType, int timerAction) {
        TimerHandle handle = null;
        try {
            TimerService ts = this.ectx.getTimerService();
            TestUtil.logTrace((String)("Initializing timer at " + System.currentTimeMillis()));
            handle = TimerImpl.createTimerHandle(timerType, new Integer(timerAction), ts);
        }
        catch (Exception e) {
            TimerImpl.handleException("initializeTimer", e);
        }
        return handle;
    }

    public boolean createAndRollback(int timerType) {
        try {
            TimerService ts = this.ectx.getTimerService();
            TestUtil.logTrace((String)("Initializing timer at " + System.currentTimeMillis()));
            Timer timer = TimerImpl.createTimer(timerType, new Integer(-1), ts);
            TestUtil.logTrace((String)"Rolling back transaction in which timer was created...");
            this.ectx.setRollbackOnly();
        }
        catch (Exception e) {
            TimerImpl.handleException("createAndRollback", e);
            return false;
        }
        return true;
    }

    public boolean cancelAndRollback(TimerHandle handle) {
        try {
            TestUtil.logTrace((String)"Getting timer...");
            Timer timer = handle.getTimer();
            TestUtil.logTrace((String)("Cancelling timer at " + System.currentTimeMillis()));
            timer.cancel();
            TestUtil.logTrace((String)"Rolling back transaction in which timer was cancelled...");
            this.ectx.setRollbackOnly();
        }
        catch (Exception e) {
            TimerImpl.handleException("cancelAndRollback", e);
            return false;
        }
        return true;
    }

    public boolean cancelTimer(TimerHandle handle) {
        try {
            TimerImpl.cancelTimer(handle);
            return true;
        }
        catch (Exception e) {
            TimerImpl.handleException("cancelTimer", e);
            return false;
        }
    }

    public boolean isSerializable(int timerType) {
        try {
            TimerService ts = this.ectx.getTimerService();
            TestUtil.logTrace((String)("Initializing timer at " + System.currentTimeMillis()));
            TimerHandle handle = TimerImpl.createTimerHandle(timerType, new Integer(-1), ts);
            return TimerImpl.isSerializable(handle);
        }
        catch (Exception e) {
            TimerImpl.handleException("isSerializable", e);
            return false;
        }
    }

    public boolean createFlagStoreAndTimer(int timerType, int timerAction) {
        try {
            TestUtil.logTrace((String)"creating flag store bean");
            this.flagStoreHome = (FlagStoreHome)this.nctx.lookup("java:comp/env/ejb/FlagStore", FlagStoreHome.class);
            this.flagStoreRef = this.flagStoreHome.create(TestUtil.getProperties(), 2, "expresso", 10.5f, false, false);
            return this.initializeTimer(timerType, timerAction);
        }
        catch (Exception e) {
            TimerImpl.handleException("setupEjbTimeoutRetry", e);
            if (this.flagStoreRef != null) {
                try {
                    this.flagStoreRef.remove();
                }
                catch (Exception e1) {
                    TimerImpl.handleException("Exception while removing bean", e);
                }
            }
            return false;
        }
    }

    public boolean verifyTimerIsGone() {
        try {
            TimerService ts = this.ectx.getTimerService();
            return TimerImpl.verifyNoTimers(ts);
        }
        catch (Exception e) {
            TimerImpl.handleException("verifyTimerIsGone", e);
            return false;
        }
    }

    public void cancelAllTimers() {
        try {
            TimerService ts = this.ectx.getTimerService();
            TestUtil.logTrace((String)"Cancelling all timers...");
            TimerImpl.cancelAllTimers(ts);
        }
        catch (Exception e) {
            TimerImpl.handleException("cancelAllTimers", e);
        }
    }
}

