/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jaxrpc.sharedclients;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jaxrpc.common.JAXRPC_Util;
import javax.naming.InitialContext;
import javax.xml.namespace.QName;
import javax.xml.rpc.Service;
import javax.xml.rpc.Stub;

public class StubContext {
    public static final String TEST_NAME = "testName";
    public static final String WEB_SERVER_HOST = "webServerHost";
    public static final String WEB_SERVER_PORT = "webServerPort";
    public static final String SECURE_WEB_SERVER_PORT = "secureWebServerPort";
    public static final String MONITOR_PORT = "monitorPort";
    public static final String WSI_HOME = "wsiHome";
    private int mode;
    private String endpointURL;
    private String wsdllocURL;
    private String namespace;
    private String service;
    private String portPrefix;
    private Class serviceEndpointInterface;
    private QName serviceName;
    private QName portName;
    private Stub stub;

    public int getMode() {
        return this.mode;
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    public String getEndpointURL() {
        return this.endpointURL;
    }

    public void setEndpointURL(String endpointURL) {
        this.endpointURL = endpointURL;
    }

    public String getWsdllocURL() {
        return this.wsdllocURL;
    }

    public void setWsdllocURL(String wsdllocURL) {
        this.wsdllocURL = wsdllocURL;
    }

    protected void initStub() throws Exception {
        if (this.stub == null) {
            if (this.mode == 0) {
                this.createJAXRPCStub();
                this.stub._setProperty("javax.xml.rpc.service.endpoint.address", (Object)this.getEndpointURL());
            } else {
                this.createJavaEEStub();
            }
        }
    }

    protected void createJAXRPCStub() throws Exception {
        this.serviceName = new QName(this.namespace, this.service);
        this.portName = new QName(this.namespace, this.portPrefix + "Port");
        this.stub = (Stub)JAXRPC_Util.getStub(this.serviceEndpointInterface.getPackage().getName() + "." + this.service, "get" + this.portName.getLocalPart());
    }

    protected void createJavaEEStub() throws Exception {
        InitialContext context = new InitialContext();
        TestUtil.logMsg((String)("lookup java:comp/env/service/" + this.service));
        Service svc = (Service)context.lookup("java:comp/env/service/" + this.service);
        this.stub = (Stub)svc.getPort(this.getServiceInterface());
        JAXRPC_Util.setSOAPLogging(this.stub, System.out);
    }

    public String getNamespace() {
        return this.namespace;
    }

    public QName getPortName() {
        return this.portName;
    }

    public String getPortPrefix() {
        return this.portPrefix;
    }

    public String getService() {
        return this.service;
    }

    public Class getServiceInterface() {
        return this.serviceEndpointInterface;
    }

    public QName getServiceName() {
        return this.serviceName;
    }

    public Stub getStub() throws Exception {
        this.initStub();
        return this.stub;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setPortName(QName portName) {
        this.portName = portName;
    }

    public void setPortPrefix(String portPrefix) {
        this.portPrefix = portPrefix;
    }

    public void setService(String service) {
        this.service = service;
    }

    public void setServiceInterface(Class serviceEndpointInterface) {
        this.serviceEndpointInterface = serviceEndpointInterface;
    }

    public void setServiceName(QName serviceName) {
        this.serviceName = serviceName;
    }
}

