/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.concurrency.api.LastExecution;

import com.sun.ts.lib.util.TestUtil;
import java.util.Date;
import javax.enterprise.concurrent.LastExecution;
import javax.enterprise.concurrent.Trigger;

public class LogicDrivenTrigger
implements Trigger {
    private long delta;
    private String testName;
    private boolean moreThanTwice = false;
    private Date startTime;
    private static final long TIME_COMPARE_INACCURACY = 2000L;
    public static final long LASTEXECUTIONGETRUNNINGTIMETEST_SLEEP_TIME = 5000L;
    public static final int RIGHT_COUNT = 2;
    public static final int WRONG_COUNT = 1;
    public static final String TEST_NAME_LASTEXECUTIONGETIDENTITYNAMETEST = "lastExecutionGetIdentityNameTest";
    public static final String TEST_NAME_LASTEXECUTIONGETRESULTTEST_RUNNABLE = "lastExecutionGetResultTest_runnable";
    public static final String TEST_NAME_LASTEXECUTIONGETRESULTTEST_CALLABLE = "lastExecutionGetResultTest_callable";
    public static final String TEST_NAME_LASTEXECUTIONGETRUNNINGTIMETEST = "lastExecutionGetRunningTimeTest";

    public LogicDrivenTrigger(long delta, String testName) {
        this.delta = delta;
        this.testName = testName;
        this.startTime = new Date();
    }

    private String getErrStr4NotEqual(String testName, Object expected, Object real) {
        String result = testName + "failed, ";
        result = result + "expected " + expected + ",";
        result = result + "but got " + real;
        return result;
    }

    private boolean validateDateTimeEquals(Date time1, Date time2) {
        long diff = time1.getTime() - time2.getTime();
        return Math.abs(diff) < 2000L;
    }

    public Date getNextRunTime(LastExecution lastExecutionInfo, Date taskScheduledTime) {
        if (lastExecutionInfo == null) {
            return new Date();
        }
        if (!this.moreThanTwice) {
            if (TEST_NAME_LASTEXECUTIONGETIDENTITYNAMETEST.equals(this.testName)) {
                if (!TEST_NAME_LASTEXECUTIONGETIDENTITYNAMETEST.equals(lastExecutionInfo.getIdentityName())) {
                    TestUtil.logErr((String)this.getErrStr4NotEqual(TEST_NAME_LASTEXECUTIONGETIDENTITYNAMETEST, TEST_NAME_LASTEXECUTIONGETIDENTITYNAMETEST, lastExecutionInfo.getIdentityName()));
                    return null;
                }
            } else if (TEST_NAME_LASTEXECUTIONGETRESULTTEST_RUNNABLE.equals(this.testName)) {
                if (lastExecutionInfo.getResult() != null) {
                    TestUtil.logErr((String)this.getErrStr4NotEqual(TEST_NAME_LASTEXECUTIONGETRESULTTEST_RUNNABLE, null, lastExecutionInfo.getResult()));
                    return null;
                }
            } else if (TEST_NAME_LASTEXECUTIONGETRESULTTEST_CALLABLE.equals(this.testName)) {
                if (!Integer.valueOf(1).equals(lastExecutionInfo.getResult())) {
                    TestUtil.logErr((String)this.getErrStr4NotEqual(TEST_NAME_LASTEXECUTIONGETRESULTTEST_CALLABLE, 1, lastExecutionInfo.getResult()));
                    return null;
                }
            } else if (TEST_NAME_LASTEXECUTIONGETRUNNINGTIMETEST.equals(this.testName)) {
                if (!this.validateDateTimeEquals(this.startTime, lastExecutionInfo.getScheduledStart())) {
                    TestUtil.logErr((String)this.getErrStr4NotEqual(TEST_NAME_LASTEXECUTIONGETRUNNINGTIMETEST, this.startTime, lastExecutionInfo.getScheduledStart()));
                    return null;
                }
                if (lastExecutionInfo.getScheduledStart().getTime() > lastExecutionInfo.getRunStart().getTime()) {
                    TestUtil.logErr((String)"lastExecutionGetRunningTimeTestfailed, getRunStart time should not be earlier than getScheduledStart");
                    return null;
                }
                if (lastExecutionInfo.getRunEnd().getTime() - lastExecutionInfo.getRunStart().getTime() < 5000L) {
                    TestUtil.logErr((String)"lastExecutionGetRunningTimeTestfailed, the difference between getRunEnd and getRunStartis shorter than the real running time");
                    return null;
                }
            }
            this.moreThanTwice = true;
            return new Date(new Date().getTime() + this.delta);
        }
        return null;
    }

    public boolean skipRun(LastExecution lastExecutionInfo, Date scheduledRunTime) {
        return false;
    }
}

