/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jpa.core.entityManagerFactoryCloseExceptions;

import com.sun.ts.lib.harness.CleanupMethod;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jpa.common.PMClientBase;
import java.util.HashMap;
import java.util.Properties;
import javax.persistence.EntityManagerFactory;

public class Client
extends PMClientBase {
    Properties props = null;

    @Override
    public void setup(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logTrace((String)"setup");
        this.props = p;
        try {
            super.setup(args, p);
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception: ", (Throwable)e);
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    @Override
    public void cleanup() throws EETest.Fault {
        super.cleanup();
    }

    public void nullCleanup() throws EETest.Fault {
    }

    @CleanupMethod(name="nullCleanup")
    public void exceptionsTest() throws EETest.Fault {
        int passCount = 0;
        HashMap<String, String> myMap = new HashMap<String, String>();
        myMap.put("some.cts.specific.property", "nothing.in.particular");
        TestUtil.logMsg((String)"Getting EntityManagerFactory");
        EntityManagerFactory emf = this.isStandAloneMode() ? this.getEntityManager().getEntityManagerFactory() : this.getEntityManagerFactory();
        if (emf != null) {
            if (emf.isOpen()) {
                TestUtil.logMsg((String)"EMF is open, now closing it");
                emf.close();
            } else {
                TestUtil.logMsg((String)"EMF is already closed");
            }
            TestUtil.logMsg((String)"Testing getMetamodel() after close");
            try {
                emf.getMetamodel();
                TestUtil.logErr((String)"IllegalStateException not thrown");
            }
            catch (IllegalStateException ise) {
                TestUtil.logTrace((String)"Received expected IllegalStateException");
                ++passCount;
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
            }
            TestUtil.logMsg((String)"Testing emf.getProperties()");
            try {
                emf.getProperties();
                TestUtil.logErr((String)"IllegalStateException not thrown");
            }
            catch (IllegalStateException ise) {
                TestUtil.logTrace((String)"Received expected IllegalStateException");
                ++passCount;
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
            }
            TestUtil.logMsg((String)"Testing getPersistenceUnitUtil() after close");
            try {
                emf.getPersistenceUnitUtil();
                TestUtil.logErr((String)"Did no throw IllegalStateException");
            }
            catch (IllegalStateException ise) {
                TestUtil.logTrace((String)"Received expected IllegalStateException");
                ++passCount;
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
            }
            TestUtil.logMsg((String)"Testing close after close ");
            try {
                emf.close();
                TestUtil.logErr((String)"IllegalStateException not thrown");
            }
            catch (IllegalStateException e) {
                TestUtil.logTrace((String)"IllegalStateException Caught as Expected.");
                ++passCount;
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
            }
            TestUtil.logMsg((String)"Testing createEntityManager() after close");
            try {
                emf.createEntityManager();
                TestUtil.logErr((String)"IllegalStateException not thrown");
            }
            catch (IllegalStateException e) {
                TestUtil.logTrace((String)"IllegalStateException Caught as Expected.");
                ++passCount;
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
            }
            TestUtil.logMsg((String)"Testing createEntityManager(Map) after close");
            try {
                emf.createEntityManager(myMap);
                TestUtil.logErr((String)"IllegalStateException not thrown");
            }
            catch (IllegalStateException e) {
                TestUtil.logTrace((String)"IllegalStateException Caught as Expected.");
                ++passCount;
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
            }
            TestUtil.logMsg((String)"Testing getCache after close ");
            try {
                emf.getCache();
                TestUtil.logErr((String)"IllegalStateException not thrown");
            }
            catch (IllegalStateException e) {
                TestUtil.logTrace((String)"IllegalStateException Caught as Expected.");
                ++passCount;
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
            }
            try {
                emf.getCriteriaBuilder();
                TestUtil.logErr((String)"IllegalStateException was not thrown");
            }
            catch (IllegalStateException ise) {
                ++passCount;
                TestUtil.logTrace((String)"Received expected IllegalStateException");
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
            }
        } else {
            TestUtil.logErr((String)"Could not obtain an EntityManagerFactory");
        }
        if (passCount != 8) {
            throw new EETest.Fault("exceptionsTest failed");
        }
    }
}

