/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.interop.csiv2.common.parser;

import com.sun.ts.tests.interop.csiv2.common.parser.Entry;
import com.sun.ts.tests.interop.csiv2.common.parser.ParseException;
import com.sun.ts.tests.interop.csiv2.common.parser.TransportAddressEntry;
import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TLSTransEntry
extends Entry {
    private int targetSupports;
    private int targetRequires;
    private Vector transAddrs = new Vector();

    public TLSTransEntry(Element element) throws ParseException {
        if (!element.getTagName().equals("tls-trans")) {
            throw new ParseException("Unexpected tag: " + element.getTagName());
        }
        NodeList nodes = element.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (node.getNodeName().equals("target-supports")) {
                this.targetSupports = Integer.parseInt(this.getText(node));
                continue;
            }
            if (node.getNodeName().equals("target-requires")) {
                this.targetRequires = Integer.parseInt(this.getText(node));
                continue;
            }
            if (!node.getNodeName().equals("trans-addr")) continue;
            this.transAddrs.addElement(new TransportAddressEntry((Element)node));
        }
    }

    public int getTargetSupports() {
        return this.targetSupports;
    }

    public int getTargetRequires() {
        return this.targetRequires;
    }

    public Vector getTransAddrs() {
        return this.transAddrs;
    }

    public String toString() {
        String result = "<tls-trans>\n";
        result = result + "<target-supports>" + this.targetSupports + "</target-supports>\n";
        result = result + "<target-requires>" + this.targetRequires + "</target-requires>\n";
        for (int i = 0; i < this.transAddrs.size(); ++i) {
            result = result + this.transAddrs.elementAt(i).toString();
        }
        result = result + "</tls-trans>\n";
        return result;
    }
}

