/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jaxws.common;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jaxws.common.Modules;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.ServerSocket;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.soap.Detail;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import javax.xml.soap.Text;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class JAXWS_Util {
    public static final String SOAP11 = "soap11";
    public static final String SOAP12 = "soap12";
    private static MessageFactory mfactorySOAP11 = null;
    private static MessageFactory mfactorySOAP12 = null;
    private static SOAPFactory sfactorySOAP11 = null;
    private static SOAPFactory sfactorySOAP12 = null;
    private static boolean debug = false;
    private static Context nctx = null;
    private static String content = null;

    public static Object doJNDILookup(String name) throws NamingException {
        System.out.println("JAXWS_Util:doJNDILookup");
        if (nctx == null) {
            System.out.println("Create JAXWS naming context...");
            nctx = new InitialContext();
            System.out.println("List all names in JAXWS naming context...");
            NamingEnumeration<NameClassPair> list = nctx.list("");
            while (list.hasMore()) {
                NameClassPair nc = list.next();
                System.out.println(nc);
            }
        }
        return nctx.lookup(name);
    }

    public static String getURLFromProp(String urlProp) throws Exception {
        return TestUtil.getProperty((String)urlProp);
    }

    public static void setSOAPLogging(Object stub, OutputStream s) throws Exception {
        boolean enableSoapLogging = Boolean.parseBoolean(TestUtil.getProperty((String)"EnableSoapLogging"));
        boolean debug = false;
        if (!enableSoapLogging) {
            return;
        }
        System.out.println("DEBUG: setSOAPLogging - NOT USED");
    }

    public static void setSOAPLogging(Object stub) throws Exception {
        JAXWS_Util.setSOAPLogging(stub, System.out);
    }

    public static Service getService(QName sname) throws Exception {
        TestUtil.logMsg((String)"JAXWS_Util:getService(QName)");
        Service service = null;
        TestUtil.logMsg((String)("QNAME=" + sname));
        TestUtil.logMsg((String)"Creating Service via javax.xml.ws.Service.create(QName)");
        service = Service.create((QName)sname);
        if (service == null) {
            TestUtil.logErr((String)"FATAL: javax.xml.ws.Service.create(QName) returned a null");
        }
        return service;
    }

    public static Service getService(URL wsdlurl, QName sname) throws Exception {
        TestUtil.logMsg((String)"JAXWS_Util:getService(URL, QName)");
        Service service = null;
        if (wsdlurl != null) {
            TestUtil.logMsg((String)("URL=" + wsdlurl.toString()));
        }
        TestUtil.logMsg((String)("QName=" + sname));
        TestUtil.logMsg((String)"Creating Service via javax.xml.ws.Service.create(URL, QName)");
        service = Service.create((URL)wsdlurl, (QName)sname);
        if (service == null) {
            TestUtil.logErr((String)"FATAL: javax.xml.ws.Service.create(URL, QName) returned a null");
        }
        return service;
    }

    public static Service getService(Class siClass) throws Exception {
        TestUtil.logMsg((String)"JAXWS_Util:getService(Class)");
        Service service = null;
        TestUtil.logMsg((String)("siClass=" + siClass.getName()));
        service = (Service)siClass.newInstance();
        if (service == null) {
            TestUtil.logErr((String)"FATAL: JAXWS_Util.getService(Class) returned service=null");
        }
        return service;
    }

    public static Service getService(URL wsdlurl, QName siName, Class siClass) throws Exception {
        TestUtil.logMsg((String)"JAXWS_Util:getService(URL, QName, Class)");
        Service service = null;
        if (wsdlurl != null) {
            TestUtil.logMsg((String)("URL=" + wsdlurl.toString()));
        }
        TestUtil.logMsg((String)("siName=" + siName));
        Modules.ensureReadable(JAXWS_Util.class, siClass);
        Modules.ensureReadable(JAXWS_Util.class, siClass.getSuperclass());
        TestUtil.logMsg((String)("siClass=" + siClass.getName()));
        Constructor ctr = siClass.getConstructor(URL.class, QName.class);
        service = (Service)ctr.newInstance(wsdlurl, siName);
        if (service == null) {
            TestUtil.logErr((String)"FATAL: JAXWS_Util.getService(URL, QName, Class) returned service=null");
        }
        return service;
    }

    public static Object getPort(URL wsdlurl, QName siName, Class siClass, QName portName, Class seiClass) throws Exception {
        TestUtil.logMsg((String)"JAXWS_Util.getPort(URL, QName, Class, QName, Class)");
        Object stub = JAXWS_Util.getPort(wsdlurl, siName, siClass, portName, seiClass, null);
        return stub;
    }

    public static Object getPort(URL wsdlurl, QName siName, Class siClass, QName portName, Class seiClass, WebServiceFeature[] wsf) throws Exception {
        TestUtil.logMsg((String)"JAXWS_Util.getPort(URL, QName, Class, QName, Class, WebServiceFeature[])");
        if (wsdlurl != null) {
            TestUtil.logMsg((String)("URL=" + wsdlurl.toString()));
        }
        TestUtil.logMsg((String)("siName=" + siName));
        TestUtil.logMsg((String)("siClass=" + siClass.getName()));
        TestUtil.logMsg((String)("portName=" + portName));
        TestUtil.logMsg((String)("seiClass=" + seiClass.getName()));
        if (wsf != null) {
            TestUtil.logMsg((String)("wsf.length=" + wsf.length));
            for (int i = 0; i < wsf.length; ++i) {
                TestUtil.logMsg((String)("wsf[" + i + "]=" + wsf[i].toString()));
            }
        }
        Constructor ctr = siClass.getConstructor(URL.class, QName.class);
        Service svc = (Service)ctr.newInstance(wsdlurl, siName);
        TestUtil.logMsg((String)("Get stub/proxy for seiClass -> " + seiClass.getName() + ", port ->" + portName));
        Object stub = null;
        stub = wsf != null ? svc.getPort(portName, seiClass, wsf) : svc.getPort(portName, seiClass);
        if (stub == null) {
            if (wsf != null) {
                TestUtil.logErr((String)"FATAL: JAXWS_Util.getPort(URL, QName, Class, QName, Class, WebServiceFeature[]) returned stub/proxy=null");
            } else {
                TestUtil.logErr((String)"FATAL: JAXWS_Util.getPort(URL, QName, Class, QName, Class) returned stub/proxy=null");
            }
        } else {
            TestUtil.logMsg((String)("Obtained stub/proxy=" + stub));
        }
        return stub;
    }

    public static Object getPort(Service svc, QName port, Class seiClass) throws Exception {
        TestUtil.logMsg((String)"JAXWS_Util.getPort(javax.xml.ws.Service, QName, Class)");
        Object stub = JAXWS_Util.getPort(svc, port, seiClass, null);
        return stub;
    }

    public static Object getPort(Service svc, QName port, Class seiClass, WebServiceFeature[] wsf) throws Exception {
        TestUtil.logMsg((String)"JAXWS_Util.getPort(javax.xml.ws.Service, QName, Class, WebServiceFeature[])");
        TestUtil.logMsg((String)("Get stub/proxy for port qname=" + port));
        Object stub = null;
        stub = wsf != null ? svc.getPort(port, seiClass, wsf) : svc.getPort(port, seiClass);
        if (stub == null) {
            if (wsf != null) {
                TestUtil.logErr((String)"FATAL: JAXWS_Util.getPort(javax.xml.ws.Service, QName, Class, WebServiceFeature[]) returned stub/proxy=null");
            } else {
                TestUtil.logErr((String)"FATAL: JAXWS_Util.getPort(javax.xml.ws.Service, QName, Class) returned stub/proxy=null");
            }
        } else {
            TestUtil.logMsg((String)("Obtained stub/proxy=" + stub));
        }
        return stub;
    }

    public static void setTargetEndpointAddress(Object stub, String url) throws Exception {
        BindingProvider bindingprovider = (BindingProvider)stub;
        Map context = bindingprovider.getRequestContext();
        TestUtil.logMsg((String)("Set target endpoint address to=" + url + " ..."));
        context.put("javax.xml.ws.service.endpoint.address", url);
        JAXWS_Util.setSOAPLogging(stub);
    }

    public static String getTargetEndpointAddress(Object stub) throws Exception {
        BindingProvider bindingprovider = (BindingProvider)stub;
        Map context = bindingprovider.getRequestContext();
        String url = (String)context.get("javax.xml.ws.service.endpoint.address");
        TestUtil.logMsg((String)("Get target endpoint address=" + url));
        return url;
    }

    public static void dumpTargetEndpointAddress(Object stub) throws Exception {
        BindingProvider bindingprovider = (BindingProvider)stub;
        Map context = bindingprovider.getRequestContext();
        String url = (String)context.get("javax.xml.ws.service.endpoint.address");
        TestUtil.logMsg((String)("Dump target endpoint address=" + url));
    }

    public static void setUserNameAndPassword(Object stub, String username, String password) throws Exception {
        BindingProvider bindingprovider = (BindingProvider)stub;
        Map context = bindingprovider.getRequestContext();
        context.put("javax.xml.ws.security.auth.username", username);
        context.put("javax.xml.ws.security.auth.password", password);
    }

    public static void dumpWSDLLocation(Service service) {
        TestUtil.logMsg((String)("service wsdl loc=" + service.getWSDLDocumentLocation()));
    }

    public static void dumpServiceName(Service service) {
        TestUtil.logMsg((String)("service name=" + service.getServiceName()));
    }

    public static void dumpPorts(Service service) {
        Iterator iterator = service.getPorts();
        while (iterator.hasNext()) {
            QName name = (QName)iterator.next();
            TestUtil.logMsg((String)("port:" + name.toString()));
        }
    }

    public static String getMessageEncoding(SOAPMessage msg) throws SOAPException {
        String encoding = "utf-8";
        if (msg.getProperty("javax.xml.soap.character-set-encoding") != null) {
            encoding = msg.getProperty("javax.xml.soap.character-set-encoding").toString();
        }
        return encoding;
    }

    public static void printSOAPMessage(SOAPMessage msg, PrintWriter writer) {
        writer.println(JAXWS_Util.returnSOAPMessageAsString(msg));
    }

    public static void printSOAPMessage(SOAPMessage msg, PrintStream out) {
        out.println("" + JAXWS_Util.returnSOAPMessageAsString(msg));
    }

    public static void dumpSOAPMessage(SOAPMessage msg, boolean output) {
        if (msg == null) {
            TestUtil.logMsg((String)"SOAP Message is null");
            return;
        }
        if (output) {
            TestUtil.logMsg((String)"");
            TestUtil.logMsg((String)"--------------------");
            TestUtil.logMsg((String)"DUMP OF SOAP MESSAGE");
            TestUtil.logMsg((String)"--------------------");
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                msg.writeTo((OutputStream)baos);
                TestUtil.logMsg((String)baos.toString(JAXWS_Util.getMessageEncoding(msg)));
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
            }
        } else {
            System.out.println("\n--------------------\nDUMP OF SOAP MESSAGE\n--------------------");
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                msg.writeTo((OutputStream)baos);
                System.out.println(baos.toString(JAXWS_Util.getMessageEncoding(msg)));
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
    }

    public static void dumpSOAPMessage(SOAPMessage msg) {
        JAXWS_Util.dumpSOAPMessage(msg, true);
    }

    public static String returnSOAPMessageAsString(SOAPMessage msg) {
        if (msg == null) {
            TestUtil.logMsg((String)"SOAP Message is null");
            return null;
        }
        ByteArrayOutputStream baos = null;
        String s = null;
        try {
            baos = new ByteArrayOutputStream();
            msg.writeTo((OutputStream)baos);
            s = baos.toString(JAXWS_Util.getMessageEncoding(msg));
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
        return s;
    }

    public static void dumpSOAPMessageWOA(SOAPMessage msg) {
        JAXWS_Util.dumpSOAPMessageWOA(msg, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dumpSOAPMessageWOA(SOAPMessage msg, boolean output) {
        ByteArrayOutputStream baos = null;
        if (msg == null) {
            TestUtil.logMsg((String)"SOAP Message is null");
            return;
        }
        if (output) {
            TestUtil.logMsg((String)"");
            TestUtil.logMsg((String)"------------------------");
            TestUtil.logMsg((String)"DUMP OF SOAP MESSAGE WOA");
            TestUtil.logMsg((String)"------------------------");
            try {
                baos = new ByteArrayOutputStream();
                msg.writeTo((OutputStream)baos);
                MessageFactory mf = MessageFactory.newInstance();
                SOAPMessage tmpMsg = mf.createMessage(msg.getMimeHeaders(), (InputStream)new ByteArrayInputStream(baos.toString().getBytes()));
                tmpMsg.removeAllAttachments();
                tmpMsg.saveChanges();
                baos.close();
                baos = new ByteArrayOutputStream();
                tmpMsg.writeTo((OutputStream)baos);
                TestUtil.logMsg((String)baos.toString(JAXWS_Util.getMessageEncoding(tmpMsg)));
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
            }
            finally {
                try {
                    baos.close();
                }
                catch (Exception e) {}
            }
        } else {
            System.out.println("\n------------------------\nDUMP OF SOAP MESSAGE WOA\n------------------------");
            try {
                baos = new ByteArrayOutputStream();
                msg.writeTo((OutputStream)baos);
                MessageFactory mf = MessageFactory.newInstance();
                SOAPMessage tmpMsg = mf.createMessage(msg.getMimeHeaders(), (InputStream)new ByteArrayInputStream(baos.toString().getBytes()));
                tmpMsg.removeAllAttachments();
                tmpMsg.saveChanges();
                baos.close();
                baos = new ByteArrayOutputStream();
                tmpMsg.writeTo((OutputStream)baos);
                System.out.println(baos.toString(JAXWS_Util.getMessageEncoding(tmpMsg)));
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
            finally {
                try {
                    baos.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static boolean SOAPElementContentsEqual(SOAPElement request, SOAPElement response) {
        String requestContent = JAXWS_Util.getSOAPElementContent("Request", request);
        String responseContent = JAXWS_Util.getSOAPElementContent("Response", response);
        TestUtil.logMsg((String)"Comparing request and response SOAPElement content");
        if (requestContent.equals(responseContent)) {
            TestUtil.logMsg((String)"Request and Response SOAPElement content is equal (expected)");
            return true;
        }
        TestUtil.logErr((String)"Request and Response SOAPElement content is not equal (unexpected)");
        return false;
    }

    public static String getSOAPElementContent(String which, SOAPElement se) {
        content = null;
        TestUtil.logMsg((String)("Dumping SOAPElement " + which + " Content"));
        JAXWS_Util._GetSOAPElementContent(se);
        return content;
    }

    private static void _GetSOAPElementContent(SOAPElement se) {
        Object o;
        Name name = se.getElementName();
        if (name.getURI() == null || name.getURI().equals("")) {
            TestUtil.logMsg((String)(" Element=" + name.getLocalName()));
            content = content + name.getLocalName();
        } else {
            TestUtil.logMsg((String)(" Element=" + name.getLocalName() + " URI=" + name.getURI()));
            content = content + name.getLocalName() + " " + name.getURI();
        }
        Iterator i = se.getAllAttributes();
        while (i.hasNext()) {
            o = i.next();
            if (!(o instanceof Name)) continue;
            Name attr = (Name)o;
            if (attr.getURI() == null || attr.getURI().equals("")) {
                TestUtil.logMsg((String)("  AttrName=" + attr.getLocalName() + " AttrValue=" + se.getAttributeValue(attr)));
                continue;
            }
            TestUtil.logMsg((String)("  AttrName=" + attr.getLocalName() + " URI=" + attr.getURI() + " AttrValue=" + se.getAttributeValue(attr)));
        }
        i = se.getChildElements();
        while (i.hasNext()) {
            o = i.next();
            if (o instanceof Name) {
                Name elem = (Name)o;
                if (elem.getURI() == null || elem.getURI().equals("")) {
                    TestUtil.logMsg((String)(" Element=" + elem.getLocalName()));
                    content = content + " " + elem.getLocalName();
                    continue;
                }
                TestUtil.logMsg((String)(" Element=" + elem.getLocalName() + " URI=" + elem.getURI()));
                content = content + " " + elem.getLocalName() + " " + elem.getURI();
                continue;
            }
            if (o instanceof Text) {
                Text text = (Text)o;
                TestUtil.logMsg((String)("  Text=" + text.getValue()));
                content = content + " " + text.getValue();
                continue;
            }
            SOAPElement se2 = (SOAPElement)o;
            JAXWS_Util._GetSOAPElementContent(se2);
        }
    }

    public static SOAPFault createSOAPFault(String soapVer) throws Exception {
        SOAPFault soapFault = null;
        try {
            TestUtil.logMsg((String)("Create a SOAP MessageFactory instance - " + soapVer));
            MessageFactory mfactory = JAXWS_Util.getMessageFactory(soapVer);
            TestUtil.logMsg((String)"Create a SOAPMessage");
            SOAPMessage soapmsg = mfactory.createMessage();
            TestUtil.logMsg((String)"Get SOAP Part");
            SOAPPart sp = soapmsg.getSOAPPart();
            TestUtil.logMsg((String)"Get SOAP Envelope");
            SOAPEnvelope envelope = sp.getEnvelope();
            TestUtil.logMsg((String)"Get SOAP Body");
            SOAPBody body = envelope.getBody();
            soapFault = body.addFault();
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Exception caught: " + e));
            return null;
        }
        return soapFault;
    }

    public static SOAPFault createSOAPFault(String soapVer, QName faultCode, String faultActor, String faultString, Name name) throws Exception {
        SOAPFault soapFault = null;
        try {
            TestUtil.logMsg((String)("Create a SOAP MessageFactory instance - " + soapVer));
            MessageFactory mfactory = JAXWS_Util.getMessageFactory(soapVer);
            TestUtil.logMsg((String)"Create a SOAPMessage");
            SOAPMessage soapmsg = mfactory.createMessage();
            TestUtil.logMsg((String)"Get SOAP Part");
            SOAPPart sp = soapmsg.getSOAPPart();
            TestUtil.logMsg((String)"Get SOAP Envelope");
            SOAPEnvelope envelope = sp.getEnvelope();
            TestUtil.logMsg((String)"Get SOAP Body");
            SOAPBody body = envelope.getBody();
            soapFault = body.addFault();
            soapFault.setFaultCode(faultCode);
            soapFault.setFaultActor(faultActor);
            soapFault.setFaultString(faultString);
            Detail detail = soapFault.addDetail();
            detail.addDetailEntry(name);
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Exception caught: " + e));
            return null;
        }
        return soapFault;
    }

    public static MessageFactory getMessageFactory(String soapVer) throws Exception {
        System.out.println("JAXWS_Util:getMessageFactory");
        if (soapVer.equals(SOAP11)) {
            if (mfactorySOAP11 == null) {
                mfactorySOAP11 = MessageFactory.newInstance();
            }
            return mfactorySOAP11;
        }
        if (mfactorySOAP12 == null) {
            mfactorySOAP12 = MessageFactory.newInstance((String)"SOAP 1.2 Protocol");
        }
        return mfactorySOAP12;
    }

    public static SOAPFactory getSOAPFactory(String soapVer) throws Exception {
        System.out.println("JAXWS_Util:getSOAPFactory");
        if (soapVer.equals(SOAP11)) {
            if (sfactorySOAP11 == null) {
                sfactorySOAP11 = SOAPFactory.newInstance();
            }
            return sfactorySOAP11;
        }
        if (sfactorySOAP12 == null) {
            sfactorySOAP12 = SOAPFactory.newInstance((String)"SOAP 1.2 Protocol");
        }
        return sfactorySOAP12;
    }

    public static SOAPMessage createEmtpySOAPMessage(String soapVer) {
        try {
            SOAPMessage message = JAXWS_Util.getMessageFactory(soapVer).createMessage();
            return message;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static SOAPMessage makeSOAPMessage(String msg) {
        try {
            Source srcMsg = JAXWS_Util.makeSource(msg, "StreamSource");
            MessageFactory factory = MessageFactory.newInstance();
            SOAPMessage message = factory.createMessage();
            message.getSOAPPart().setContent(srcMsg);
            message.saveChanges();
            return message;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Source makeSource(String msg, String type) {
        StringReader reader = new StringReader(msg);
        if (type.equals("StreamSource")) {
            return new StreamSource(reader);
        }
        if (type.equals("DOMSource")) {
            return new DOMSource(JAXWS_Util.createDOMNode(reader));
        }
        if (type.equals("SAXSource")) {
            return new SAXSource(new InputSource(reader));
        }
        return null;
    }

    public static Node createDOMNode(Reader reader) {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        dbf.setValidating(false);
        try {
            DocumentBuilder builder = dbf.newDocumentBuilder();
            try {
                return builder.parse(new InputSource(reader));
            }
            catch (SAXException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        catch (ParserConfigurationException pce) {
            IllegalArgumentException iae = new IllegalArgumentException(pce.getMessage());
            iae.initCause(pce);
            throw iae;
        }
        return null;
    }

    public static String getDOMResultAsString(DOMResult dr) throws Exception {
        DOMSource ds = new DOMSource(dr.getNode());
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        transformer.setOutputProperty("method", "xml");
        StringWriter out = new StringWriter();
        StreamResult streamResult = new StreamResult();
        streamResult.setWriter(out);
        transformer.transform(ds, streamResult);
        return streamResult.getWriter().toString();
    }

    public static DOMResult getSourceAsDOMResult(Source s) throws Exception {
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        DOMResult result = new DOMResult();
        transformer.transform(s, result);
        return result;
    }

    public static String getSourceAsString(Source s) throws Exception {
        DOMResult dr = JAXWS_Util.getSourceAsDOMResult(s);
        return JAXWS_Util.getDOMResultAsString(dr);
    }

    public static String getSOAPMessageAsString(SOAPMessage message) {
        return JAXWS_Util.getMsgAsString(message);
    }

    public static String getMsgAsString(SOAPMessage message) {
        String msg = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            message.writeTo((OutputStream)baos);
            msg = baos.toString(JAXWS_Util.getMessageEncoding(message));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return msg;
    }

    public static int looseIndexOf(List<String> s, String searchStr) {
        int index = -1;
        int currentIndex = -1;
        TestUtil.logTrace((String)"In looseIndexOf");
        TestUtil.logTrace((String)("List.size()=" + s.size()));
        TestUtil.logTrace((String)("List.isEmpty()=" + s.isEmpty()));
        if (!s.isEmpty()) {
            Iterator<String> i = s.iterator();
            while (i.hasNext()) {
                ++currentIndex;
                String item = i.next();
                if (item != null) {
                    TestUtil.logTrace((String)("item=|" + item + "|"));
                    TestUtil.logTrace((String)("searchStr=" + searchStr));
                    if (item.indexOf(searchStr) == -1) continue;
                    TestUtil.logTrace((String)"found item");
                    index = currentIndex;
                    break;
                }
                TestUtil.logErr((String)"A null object was returned while iterating through");
                TestUtil.logErr((String)"the list of callbacks");
            }
        }
        return index;
    }

    public static int looseLastIndexOf(List<String> s, String searchStr) {
        TestUtil.logTrace((String)"In looseLastIndexOf");
        TestUtil.logTrace((String)("List.size()=" + s.size()));
        TestUtil.logTrace((String)("List.isEmpty()=" + s.isEmpty()));
        int lastIndex = -1;
        int currentIndex = -1;
        if (!s.isEmpty()) {
            Iterator<String> i = s.iterator();
            while (i.hasNext()) {
                ++currentIndex;
                String item = i.next();
                if (item != null) {
                    TestUtil.logTrace((String)("item=|" + item + "|"));
                    TestUtil.logTrace((String)("searchStr=" + searchStr));
                    if (item.indexOf(searchStr) == -1) continue;
                    TestUtil.logTrace((String)"found item");
                    lastIndex = currentIndex;
                    continue;
                }
                TestUtil.logErr((String)"A null object was returned while iterating through");
                TestUtil.logErr((String)"the list of callbacks");
            }
        }
        return lastIndex;
    }

    public static void dumpList(List<String> s) {
        TestUtil.logTrace((String)"------------------------------------");
        TestUtil.logTrace((String)"Dumping List<String>");
        TestUtil.logTrace((String)"------------------------------------");
        TestUtil.logTrace((String)"\n");
        TestUtil.logTrace((String)("List.size()=" + s.size()));
        TestUtil.logTrace((String)("List.isEmpty()=" + s.isEmpty()));
        if (!s.isEmpty()) {
            for (String o : s) {
                if (o != null) {
                    if (o instanceof String) {
                        TestUtil.logTrace((String)o);
                        continue;
                    }
                    TestUtil.logTrace((String)"An unexpected object was returned while iterating through");
                    TestUtil.logTrace((String)("the list of callbacks, expected String got:" + o));
                    continue;
                }
                TestUtil.logTrace((String)"A null object was returned while iterating through");
                TestUtil.logTrace((String)"the list of callbacks");
            }
        }
    }

    public static List<String> getMessagesStartingFrom(List<String> calls, String searchItem) {
        boolean pass = true;
        TestUtil.logTrace((String)"The complete list of messages are the following:");
        JAXWS_Util.dumpList(calls);
        TestUtil.logTrace((String)("Getting all messages after " + searchItem));
        Vector<String> messages = new Vector<String>();
        TestUtil.logTrace((String)"\n");
        TestUtil.logTrace((String)"The first item found is:");
        if (!calls.isEmpty()) {
            boolean found = false;
            for (String o : calls) {
                if (o != null) {
                    if (o instanceof String) {
                        String item = o;
                        if (!found && item.indexOf(searchItem) > -1) {
                            TestUtil.logTrace((String)item);
                            found = true;
                        }
                        if (!found) continue;
                        messages.add(item);
                        continue;
                    }
                    TestUtil.logErr((String)"An unexpected object was returned while iterating through");
                    TestUtil.logErr((String)("the list of callbacks, expected String got:" + o));
                    continue;
                }
                TestUtil.logErr((String)"A null object was returned while iterating through");
                TestUtil.logErr((String)"the list of callbacks");
            }
        }
        return messages;
    }

    public static boolean doesMethodExist(Class c, String methodName) {
        boolean found = false;
        Method[] methods = c.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            if (!methodName.equals(method.getName())) continue;
            found = true;
        }
        return found;
    }

    public static Method getMethod(Class c, String methodName) {
        TestUtil.logTrace((String)"in getMethod");
        Method result = null;
        for (Method method : c.getDeclaredMethods()) {
            String m = method.getName();
            TestUtil.logTrace((String)("method=" + m));
            if (!methodName.equals(m)) continue;
            result = method;
            TestUtil.logTrace((String)("found:" + methodName));
        }
        return result;
    }

    public static Class getMethodReturnType(Class c, String methodName) {
        Class<?> result = null;
        Method m = JAXWS_Util.getMethod(c, methodName);
        if (m != null) {
            TestUtil.logTrace((String)("The method:" + methodName + " was found for class:" + c));
            TestUtil.logTrace((String)"now returning the return type");
            result = m.getReturnType();
        } else {
            TestUtil.logTrace((String)("The method:" + methodName + " was not found for class:" + c));
        }
        return result;
    }

    public static Class getMethodParameterType(Class c, String methodName, int location) {
        Class<?> result = null;
        Method m = JAXWS_Util.getMethod(c, methodName);
        if (m != null) {
            TestUtil.logTrace((String)("The method:" + methodName + " was found for class:" + c));
            Class<?>[] pTypes = m.getParameterTypes();
            if (location <= pTypes.length) {
                TestUtil.logTrace((String)"Found specified parameter, now returning it");
                result = pTypes[location];
            } else {
                TestUtil.logTrace((String)("The method:" + methodName + " did not contain a parameter in position " + location));
            }
        } else {
            TestUtil.logTrace((String)("The method:" + methodName + " was not found for class:" + c));
        }
        return result;
    }

    public static boolean doesExceptionExistForAllMethods(Class c, String exceptionName) {
        boolean result = true;
        for (Method method : c.getDeclaredMethods()) {
            String m = method.getName();
            TestUtil.logTrace((String)("method=" + m));
            int count = 0;
            String eName = "";
            for (Class<?> c1 : method.getExceptionTypes()) {
                eName = c1.getName();
                TestUtil.logTrace((String)("exception name=" + eName));
                if (!eName.equals(exceptionName)) continue;
                ++count;
            }
            if (count != 0) continue;
            TestUtil.logErr((String)("The method:" + m + " did not declare " + exceptionName + " on all of it's methods"));
            result = false;
        }
        return result;
    }

    public static boolean validateURL(String theURL) {
        boolean valid = false;
        URL url = null;
        Object urlConnection = null;
        TestUtil.logMsg((String)("validateURL: -> " + theURL));
        try {
            url = new URL(theURL);
            Object o = url.openConnection().getContent();
            valid = true;
            TestUtil.logMsg((String)"validateURL passed");
        }
        catch (Exception e) {
            TestUtil.logMsg((String)"validateURL failed");
        }
        return valid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getFreePort() {
        int port = -1;
        ServerSocket soc = null;
        int minPort = -1;
        int maxPort = -1;
        try {
            minPort = Integer.parseInt(TestUtil.getProperty((String)"port.range.min", (String)"-1"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            maxPort = Integer.parseInt(TestUtil.getProperty((String)"port.range.max", (String)"-1"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        TestUtil.logMsg((String)("minPort=" + minPort));
        TestUtil.logMsg((String)("maxPort=" + maxPort));
        SecurityManager sec = System.getSecurityManager();
        if (minPort == -1 || minPort > maxPort) {
            if (sec != null) {
                try {
                    sec.checkListen(0);
                }
                catch (SecurityException secex) {
                    TestUtil.logErr((String)"Security configuration does not allow to wait for the connection on ports 1024-... ", (Throwable)secex);
                    return -1;
                }
            }
            try {
                soc = new ServerSocket(0);
                port = soc.getLocalPort();
            }
            catch (IOException e) {
                TestUtil.logErr((String)("Unable to get a free port because of an exception: " + e), (Throwable)e);
                int n = -1;
                return n;
            }
            finally {
                try {
                    soc.close();
                }
                catch (Exception exception) {}
            }
            return port;
        }
        if (minPort == maxPort && minPort != -1) {
            return minPort;
        }
        for (port = minPort; port <= maxPort; ++port) {
            try {
                if (sec != null) {
                    sec.checkListen(port);
                }
                soc = new ServerSocket(port);
                soc.close();
                int n = port;
                return n;
            }
            catch (IOException iOException) {
                continue;
            }
            catch (SecurityException securityException) {
                continue;
            }
            finally {
                try {
                    soc.close();
                }
                catch (Exception exception) {}
            }
        }
        TestUtil.logErr((String)("Ports in range [" + minPort + "," + maxPort + "] are not available on local machine or security configuration does not allow to wait for the connection on these ports."));
        return -1;
    }

    public static void dumpHTTPHeaders(SOAPMessageContext context) {
        JAXWS_Util.dumpHTTPHeaders(context, false);
    }

    public static void dumpHTTPHeaders(SOAPMessageContext context, boolean output) {
        Map mreq = (Map)context.get((Object)"javax.xml.ws.http.request.headers");
        Map mresp = (Map)context.get((Object)"javax.xml.ws.http.response.headers");
        StringBuffer sbreq = new StringBuffer();
        int cnt = 0;
        Iterator iterator = null;
        try {
            if (mreq != null) {
                if (mreq.size() > 0) {
                    for (String key : mreq.keySet()) {
                        List list = (List)mreq.get(key);
                        Iterator i = list.iterator();
                        String values = "";
                        while (i.hasNext()) {
                            values = (String)i.next() + " ";
                        }
                        sbreq.append("" + key + "=" + values);
                        ++cnt;
                    }
                }
            } else {
                sbreq.append("http_request_headers are null");
            }
        }
        catch (Exception key) {
            // empty catch block
        }
        StringBuffer sbresp = new StringBuffer();
        cnt = 0;
        iterator = null;
        try {
            if (mresp != null) {
                if (mresp.size() > 0) {
                    for (String key : mresp.keySet()) {
                        List list = (List)mresp.get(key);
                        Iterator i = list.iterator();
                        String values = "";
                        while (i.hasNext()) {
                            values = (String)i.next() + " ";
                        }
                        sbresp.append("" + key + "=" + values);
                        ++cnt;
                    }
                }
            } else {
                sbresp.append("http_response_headers are null");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (output) {
            TestUtil.logMsg((String)"");
            TestUtil.logMsg((String)"--------------------");
            TestUtil.logMsg((String)"DUMP OF HTTP Headers");
            TestUtil.logMsg((String)"--------------------");
            TestUtil.logMsg((String)("HTTP_REQUEST_HEADERS=" + sbreq.toString()));
            TestUtil.logMsg((String)("HTTP_RESPONSE_HEADERS=" + sbresp.toString()));
        } else {
            System.out.println("\n--------------------\nDUMP OF HTTP Headers\n--------------------");
            System.out.println("HTTP_REQUEST_HEADERS=" + sbreq.toString());
            System.out.println("HTTP_RESPONSE_HEADERS=" + sbresp.toString());
        }
    }

    public static Map<String, List<String>> convertKeysToLowerCase(Map<String, List<String>> in) {
        HashMap<String, List<String>> out = new HashMap<String, List<String>>();
        if (in != null) {
            for (Map.Entry<String, List<String>> e : in.entrySet()) {
                if (e.getKey() != null) {
                    out.put(e.getKey().toLowerCase(), e.getValue());
                    continue;
                }
                out.put(e.getKey(), e.getValue());
            }
        }
        return out;
    }

    public static void setSOAPACTIONURI(Object o, String action) {
        BindingProvider bp = (BindingProvider)o;
        Map requestContext = bp.getRequestContext();
        if (requestContext == null) {
            TestUtil.logErr((String)"setSOAPACTIONURI:getRequestContext() returned null");
        } else {
            requestContext.put("javax.xml.ws.soap.http.soapaction.uri", action);
            requestContext.put("javax.xml.ws.soap.http.soapaction.use", true);
            TestUtil.logMsg((String)("SOAPACTION_USE_PROPERTY being set to: " + requestContext.get("javax.xml.ws.soap.http.soapaction.use")));
            TestUtil.logMsg((String)("SOAPACTION_URI_PROPERTY being set to: " + requestContext.get("javax.xml.ws.soap.http.soapaction.uri")));
        }
    }
}

