/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jaxrpc.wsi.w2j.rpc.literal.R1015;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.tests.jaxrpc.sharedclients.ClientFactory;
import com.sun.ts.tests.jaxrpc.sharedclients.simpleclient.SimpleTestClient;
import com.sun.ts.tests.jaxrpc.wsi.requests.SOAPRequests;
import java.util.Properties;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;

public class Client
extends ServiceEETest
implements SOAPRequests {
    private SimpleTestClient client;

    public static void main(String[] args) {
        Client tests = new Client();
        Status status = tests.run(args, System.out, System.err);
        status.exit();
    }

    public void setup(String[] args, Properties properties) throws EETest.Fault {
        this.client = (SimpleTestClient)ClientFactory.getClient(SimpleTestClient.class, properties);
        this.logMsg("setup ok");
    }

    public void cleanup() {
        this.logMsg("cleanup");
    }

    public void testEnvelopeWrongNamespace() throws EETest.Fault {
        SOAPMessage response = null;
        try {
            response = this.client.makeSaajRequest("<?xml version='1.0' encoding='UTF-8'?> <!-- Copyright (c) 2003 Oracle Corporation.  All rights reserved. --> <env:Envelope xmlns:env='http://not.soap/envelope/' xmlns:xsd='http://www.w3.org/2001/XMLSchema' xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance' xmlns:enc='http://schemas.xmlsoap.org/soap/encoding/' xmlns:ns0='http://simpletestservice.org/wsdl' xmlns:ns1='http://simpletestservice.org/types'><env:Body><ns0:helloWorld/></env:Body></env:Envelope>");
        }
        catch (Exception e) {
            throw new EETest.Fault("Test didn't complete properly: ", e);
        }
        try {
            this.validateIsFault(response);
        }
        catch (SOAPException se) {
            throw new EETest.Fault("Error creating response object", se);
        }
        this.client.logMessageInHarness(response);
    }

    private void validateIsFault(SOAPMessage response) throws EETest.Fault, SOAPException {
        if (!response.getSOAPPart().getEnvelope().getBody().hasFault()) {
            this.client.logMessageInHarness(response);
            throw new EETest.Fault("Invalid response: instances must generate a soap:Fault when a request soap:Envelope uses a namespace other than http://schemas.xmlsoap.org/soap/envelope/(BP-R1015).");
        }
    }
}

