/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.interop.csiv2.common.validation;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.interop.csiv2.common.parser.ClientEntry;
import com.sun.ts.tests.interop.csiv2.common.parser.EstablishContextEntry;
import com.sun.ts.tests.interop.csiv2.common.parser.ITAbsent;
import com.sun.ts.tests.interop.csiv2.common.parser.ITAnonymous;
import com.sun.ts.tests.interop.csiv2.common.parser.ITCertificateChain;
import com.sun.ts.tests.interop.csiv2.common.parser.ITDistinguishedName;
import com.sun.ts.tests.interop.csiv2.common.parser.ITPrincipalName;
import com.sun.ts.tests.interop.csiv2.common.parser.IdentityToken;
import com.sun.ts.tests.interop.csiv2.common.parser.IdentityTokenEntry;
import com.sun.ts.tests.interop.csiv2.common.parser.RequestServiceContextEntry;
import com.sun.ts.tests.interop.csiv2.common.parser.ServerInterceptorEntry;
import com.sun.ts.tests.interop.csiv2.common.parser.TransportClientPrincipalsEntry;
import com.sun.ts.tests.interop.csiv2.common.validation.OutputLog;
import java.util.Vector;

public class RequestValidationStrategy {
    private OutputLog log = new OutputLog();
    private boolean expectingTransportClientPrincipals;
    private boolean expectingServiceContext;
    private boolean expectingSASClientAuthenticationPrincipal;
    private int validSASIdentityTokenTypes;
    public static final int ITTAbsent = 1;
    public static final int ITTAnonymous = 2;
    public static final int ITTPrincipalName = 4;
    public static final int ITTX509CertChain = 8;
    public static final int ITTDistinguishedName = 16;
    public static final int ITTAllowAll = 31;
    private String[] tokenTypeDescriptions = new String[]{"ITTAbsent", "ITTAnonymous", "ITTPrincipalName", "ITTX509CertChain", "ITTDistinguishedName"};

    public RequestValidationStrategy(boolean expectingTransportClientPrincipals, boolean expectingServiceContext, boolean expectingSASClientAuthenticationPrincipal, int validSASIdentityTokenTypes) {
        this.expectingTransportClientPrincipals = expectingTransportClientPrincipals;
        this.expectingServiceContext = expectingServiceContext;
        this.expectingSASClientAuthenticationPrincipal = expectingSASClientAuthenticationPrincipal;
        this.validSASIdentityTokenTypes = validSASIdentityTokenTypes;
    }

    public boolean validate(ClientEntry entry) {
        boolean result = true;
        TestUtil.logTrace((String)("Validating the following invocation:\n-------------------------------------------\n" + entry.toString() + "-------------------------------------------"));
        boolean valid = this.verifyTransportClientPrincipals(entry);
        boolean bl = result = result && valid;
        if (!valid) {
            this.log.logMismatch("Mismatched transport client principals.");
        }
        valid = this.verifyServiceContextPresent(entry);
        boolean bl2 = result = result && valid;
        if (!valid) {
            if (this.expectingServiceContext) {
                this.log.logMismatch("Expecting request service context.");
            } else {
                this.log.logMismatch("Not expecting request service context.");
            }
        }
        if (this.expectingServiceContext) {
            valid = this.verifySASClientAuthenticationPrincipal(entry);
            boolean bl3 = result = result && valid;
            if (!valid) {
                this.log.logMismatch("Mismatched SAS Client Authentication principal.");
            }
            valid = this.verifyIdentityTokenType(entry);
            boolean bl4 = result = result && valid;
            if (!valid) {
                this.log.logMismatch("Mismatched SAS Identity Token Type.");
            }
        } else {
            this.log.logInfo("Not expecting service context - skipping SAS validation.");
        }
        return result;
    }

    private boolean verifyTransportClientPrincipals(ClientEntry entry) {
        boolean result = true;
        ServerInterceptorEntry serverInterceptor = entry.getServerInterceptor();
        if (serverInterceptor == null) {
            this.log.logMismatch("Error: Expecting server interceptor element.");
            result = false;
        } else {
            TransportClientPrincipalsEntry transportClientPrincipals = serverInterceptor.getTransportClientPrincipals();
            if (transportClientPrincipals == null) {
                this.log.logMismatch("Error: Expecting tranport client principals log entry.");
                result = false;
            } else {
                Vector principals = transportClientPrincipals.getPrincipals();
                if (this.expectingTransportClientPrincipals) {
                    if (principals.size() == 0) {
                        this.log.logMismatch("Error: Expecting at least one transport client principal.");
                        result = false;
                    } else {
                        this.log.logMatch("Match: At least one transport client principal found");
                    }
                } else if (principals.size() != 0) {
                    this.log.logMismatch("Error: Expecting no transport client principals.  Found " + principals.size() + ".");
                    result = false;
                } else {
                    this.log.logMatch("Match: Transport client principals absent, as expected.");
                }
            }
        }
        return result;
    }

    private boolean verifyServiceContextPresent(ClientEntry entry) {
        boolean result = true;
        ServerInterceptorEntry serverInterceptor = entry.getServerInterceptor();
        RequestServiceContextEntry requestServiceContext = null;
        if (serverInterceptor == null) {
            this.log.logMismatch("Error: Expecting server interceptor element.");
        } else {
            requestServiceContext = serverInterceptor.getRequestServiceContext();
            result = requestServiceContext == null || !requestServiceContext.isPresent() ? !this.expectingServiceContext : this.expectingServiceContext;
        }
        return result;
    }

    private boolean verifySASClientAuthenticationPrincipal(ClientEntry entry) {
        boolean result = true;
        EstablishContextEntry establishContext = this.findEstablishContext(entry);
        if (establishContext == null) {
            result = false;
        } else {
            byte[] token = establishContext.getClientAuthToken();
            if (token == null || token.length == 0) {
                if (this.expectingSASClientAuthenticationPrincipal) {
                    this.log.logMismatch("Error: Expecting SAS Client authentication principal.");
                    result = false;
                } else {
                    this.log.logMatch("Match: SAS Client principal absent.");
                }
            } else if (!this.expectingSASClientAuthenticationPrincipal) {
                this.log.logMismatch("Error: Not expecting SAS Client authentication principal.");
                result = false;
            } else {
                this.log.logMatch("Match: SAS Client principal present, as expected.");
            }
        }
        return result;
    }

    private boolean verifyIdentityTokenType(ClientEntry entry) {
        boolean result = true;
        EstablishContextEntry establishContext = this.findEstablishContext(entry);
        if (establishContext == null) {
            result = false;
        } else {
            IdentityTokenEntry tokenEntry = establishContext.getIdentityToken();
            if (tokenEntry == null) {
                this.log.logMismatch("Identity token entry not found.");
                result = false;
            } else {
                IdentityToken token = tokenEntry.getIdentityToken();
                if (token == null) {
                    this.log.logMismatch("Unknown identity token.");
                    result = false;
                } else {
                    int type = 0;
                    if (token instanceof ITAbsent) {
                        type = 1;
                    } else if (token instanceof ITAnonymous) {
                        type = 2;
                    } else if (token instanceof ITPrincipalName) {
                        type = 4;
                    } else if (token instanceof ITCertificateChain) {
                        type = 8;
                    } else if (token instanceof ITDistinguishedName) {
                        type = 16;
                    }
                    if ((type & this.validSASIdentityTokenTypes) == 0) {
                        this.log.logMismatch("Identity Token Type is invalid.  Expecting one of the following:");
                        this.log.logInfo(this.describeTokenTypes(this.validSASIdentityTokenTypes));
                        this.log.logInfo(" Found:");
                        this.log.logInfo(this.describeTokenTypes(type));
                        result = false;
                    } else {
                        this.log.logMatch("Match: Identity Token Type is valid.");
                    }
                }
            }
        }
        return result;
    }

    private EstablishContextEntry findEstablishContext(ClientEntry entry) {
        boolean okay = true;
        EstablishContextEntry result = null;
        ServerInterceptorEntry serverInterceptor = entry.getServerInterceptor();
        RequestServiceContextEntry requestServiceContext = null;
        if (serverInterceptor == null) {
            this.log.logMismatch("Error: Expecting server interceptor element.");
            okay = false;
        }
        if (okay && ((requestServiceContext = serverInterceptor.getRequestServiceContext()) == null || !requestServiceContext.isPresent())) {
            this.log.logMismatch("Error: Request service context not present.");
            okay = false;
        }
        if (okay && (result = requestServiceContext.getEstablishContext()) == null) {
            this.log.logMismatch("Error: EstablishContext message not found.");
        }
        return result;
    }

    private String describeTokenTypes(int type) {
        String result = "";
        int bit = 1;
        for (int i = 0; i <= this.tokenTypeDescriptions.length; ++i) {
            if ((type & bit) > 0) {
                result = result + "  * " + this.tokenTypeDescriptions[i] + "\n";
            }
            bit *= 2;
        }
        if (result.equals("")) {
            result = "  * No token type.";
        }
        return result;
    }
}

