/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.interop.csiv2.common.parser;

import com.sun.ts.tests.interop.csiv2.common.parser.CompleteEstablishContextEntry;
import com.sun.ts.tests.interop.csiv2.common.parser.ContextErrorEntry;
import com.sun.ts.tests.interop.csiv2.common.parser.Entry;
import com.sun.ts.tests.interop.csiv2.common.parser.InvalidMessageEntry;
import com.sun.ts.tests.interop.csiv2.common.parser.ParseException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ReplyServiceContextEntry
extends Entry {
    private boolean present;
    private InvalidMessageEntry invalidMessage;
    private ContextErrorEntry contextError;
    private CompleteEstablishContextEntry completeEstablishContext;

    public ReplyServiceContextEntry(Element element) throws ParseException {
        if (!element.getTagName().equals("reply-svc-context")) {
            throw new ParseException("Unexpected tag: " + element.getTagName());
        }
        this.present = element.getAttribute("present").equals("true");
        NodeList nodes = element.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (node.getNodeName().equals("complete-establish-context")) {
                this.completeEstablishContext = new CompleteEstablishContextEntry((Element)node);
                continue;
            }
            if (node.getNodeName().equals("context-error")) {
                this.contextError = new ContextErrorEntry((Element)node);
                continue;
            }
            if (!node.getNodeName().equals("invalid-message")) continue;
            this.invalidMessage = new InvalidMessageEntry((Element)node);
        }
    }

    public boolean isPresent() {
        return this.present;
    }

    public InvalidMessageEntry getInvalidMessage() {
        return this.invalidMessage;
    }

    public ContextErrorEntry getContextError() {
        return this.contextError;
    }

    public CompleteEstablishContextEntry getCompleteEstablishContext() {
        return this.completeEstablishContext;
    }

    public String toString() {
        String result;
        if (this.present) {
            result = "<reply-svc-context present=\"true\">\n";
            if (this.completeEstablishContext != null) {
                result = result + this.completeEstablishContext.toString();
            }
            if (this.contextError != null) {
                result = result + this.contextError.toString();
            }
            if (this.invalidMessage != null) {
                result = result + this.invalidMessage.toString();
            }
            result = result + "</reply-svc-context>\n";
        } else {
            result = "<reply-svc-context present=\"false\"/>\n";
        }
        return result;
    }
}

