/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.concurrency.api.ManagedScheduledExecutorService;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.concurrency.api.common.CallableTask;
import com.sun.ts.tests.concurrency.api.common.CommonTriggers;
import com.sun.ts.tests.concurrency.api.common.RunnableTask;
import com.sun.ts.tests.concurrency.api.common.Util;
import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledFuture;
import javax.enterprise.concurrent.ManagedScheduledExecutorService;
import javax.enterprise.concurrent.Trigger;
import javax.naming.InitialContext;

public class Client
extends ServiceEETest
implements Serializable {
    InitialContext context;
    ManagedScheduledExecutorService executorService;
    public static final String CALLABLETESTTASK1_RUN_RESULT = "CallableTestTask1";
    private static final String TEST_JNDI_EVN_ENTRY_VALUE = "hello";
    private static final String TEST_JNDI_EVN_ENTRY_JNDI_NAME = "java:comp/env/ManagedScheduledExecutorService_test_string";
    private static final String TEST_CLASSLOADER_CLASS_NAME = "com.sun.ts.tests.concurrency.api.ManagedScheduledExecutorService.Client";

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logTrace((String)"setup");
        try {
            this.context = new InitialContext();
            this.executorService = (ManagedScheduledExecutorService)this.context.lookup("java:comp/DefaultManagedScheduledExecutorService");
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception: ", (Throwable)e);
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    public void cleanup() throws EETest.Fault {
        TestUtil.logTrace((String)"cleanup");
    }

    public void normalScheduleProcess1Test() throws EETest.Fault {
        ScheduledFuture result = this.executorService.schedule((Runnable)new RunnableTask(TEST_JNDI_EVN_ENTRY_JNDI_NAME, TEST_JNDI_EVN_ENTRY_VALUE, TEST_CLASSLOADER_CLASS_NAME), (Trigger)new CommonTriggers.OnceTrigger());
        Util.waitForTaskComplete(result, 30);
        try {
            Object obj = result.get();
            if (obj != null) {
                TestUtil.logErr((String)("the task should return null result, actual result=" + obj));
                throw new EETest.Fault("normalScheduleProcess1Test failed");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception: ", (Throwable)e);
            throw new EETest.Fault(e);
        }
    }

    public void nullCommandScheduleProcessTest() throws EETest.Fault {
        Runnable command = null;
        try {
            this.executorService.schedule(command, (Trigger)new CommonTriggers.OnceTrigger());
        }
        catch (NullPointerException e) {
            return;
        }
        TestUtil.logErr((String)"NullPointerException should be thrown when arg command is null");
        throw new EETest.Fault("nullCommandScheduleProcessTest failed");
    }

    public void normalScheduleProcess2Test() throws EETest.Fault {
        ScheduledFuture result = this.executorService.schedule(new CallableTask<String>(TEST_JNDI_EVN_ENTRY_JNDI_NAME, TEST_JNDI_EVN_ENTRY_VALUE, TEST_CLASSLOADER_CLASS_NAME, CALLABLETESTTASK1_RUN_RESULT), (Trigger)new CommonTriggers.OnceTrigger());
        Util.waitForTaskComplete(result, 30);
        try {
            Object obj = result.get();
            if (CALLABLETESTTASK1_RUN_RESULT.equals(obj)) {
                return;
            }
            throw new RuntimeException("get wrong result:" + obj);
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception: ", (Throwable)e);
            throw new EETest.Fault(e);
        }
    }

    public void nullCallableScheduleProcessTest() throws EETest.Fault {
        Callable callable = null;
        try {
            this.executorService.schedule(callable, (Trigger)new CommonTriggers.OnceTrigger());
        }
        catch (NullPointerException e) {
            return;
        }
        TestUtil.logErr((String)"NullPointerException should be thrown when arg command is null");
        throw new EETest.Fault("nullCallableScheduleProcessTest failed");
    }
}

