/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.signaturetest.javaee;

import com.sun.javatest.Status;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.signaturetest.SigTestEE;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class JavaEESigTest
extends SigTestEE {
    public static final String JAVAEE_FULL = "full";
    public static final String JAVAEE_KEYWORD = "javaee";
    public static final String JAVAEE_WEB = "web";
    public static final String JAVAEE_WEB_KEYWORD = "javaee_web_profile";
    public static final String KEYWORD_JAVAEE = "ejb interceptors caj jms wsmd javamail javaeemgmt cdi di beanval persistence jaxb saaj jaxws connector jacc jaspic jsonp jta el servlet jsf jaxrs websocket batch concurrency jsonb securityapi";
    public static final String KEYWORD_WEB = "caj ejb persistence el jsf jsonp jsp servlet jta jaxrs cdi di beanval interceptors websocket jsonb securityapi";
    public static final ArrayList<String> KEYWORD_JAVAEE_FULL_OPTIONAL_TECHS = new ArrayList<String>(Arrays.asList("jaxrpc", "jaxr", "javaeedeploy"));
    public static final ArrayList<String> KEYWORD_WEB_FULL_OPTIONAL_TECHS = new ArrayList<String>(Arrays.asList("batch", "jaxrpc", "jaxr", "javaeedeploy", "connector", "jaxws", "jaxb", "jms", "javamail", "javaeemgmt", "jacc", "jaspic", "wsmd"));
    public static final Map<Containers, Map<String, String[]>> CONTAINER_PACKAGE_MAPS;
    private boolean isFullEEProfile = true;
    private String level;
    private String otherTechnologyKeywords = null;

    private void debugit(String str) {
        TestUtil.logTrace((String)str);
    }

    private void setLevel() {
        this.level = this.testInfo.getJavaeeLevel().toLowerCase();
        this.debugit("in setLevel()");
        this.debugit("javaee.level = " + this.level);
        if (this.level.contains(JAVAEE_FULL)) {
            this.isFullEEProfile = true;
            this.debugit("isFullEEProfile = true");
            this.otherTechnologyKeywords = this.level.replace(JAVAEE_FULL, "");
        } else if (this.level.contains(JAVAEE_WEB)) {
            this.isFullEEProfile = false;
            this.debugit("isFullEEProfile = false");
            this.otherTechnologyKeywords = this.level.replace(JAVAEE_WEB, "");
        } else {
            System.err.println("ERROR level set to \"" + this.level + "\"");
            System.err.println("\t level must be set to full or web");
            System.err.println("Tests will run assuming level:  full");
            this.isFullEEProfile = true;
            this.debugit("level is indeterminate so setting isFullEEProfile = true");
        }
        this.debugit("JavaEESigTest.ssetLevel():  otherTechnologyKeywords = " + this.otherTechnologyKeywords);
    }

    private Set<String> resolveAggregateKeywords() throws IOException {
        String tsHome = this.testInfo.getTSHome();
        HashSet<String> result = new HashSet<String>();
        String strKeywords = this.isFullEEProfile ? KEYWORD_JAVAEE : KEYWORD_WEB;
        if (this.otherTechnologyKeywords != null) {
            strKeywords = strKeywords + " " + this.otherTechnologyKeywords;
        }
        List<String> terminals = this.getTerminals(strKeywords);
        result.addAll(terminals);
        this.debugit("JavaEESigTest.resolveAggregateKeywords(): strKeywords = " + strKeywords);
        return result;
    }

    private List<String> getTerminals(String s) {
        ArrayList<String> result = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(s, " \t\n\r\f,");
        while (st.hasMoreTokens()) {
            String keyword = st.nextToken().trim().toLowerCase();
            if (!(keyword.equals(JAVAEE_FULL) || keyword.equals(JAVAEE_KEYWORD) || keyword.equals(JAVAEE_WEB) || keyword.equals(JAVAEE_WEB_KEYWORD))) {
                result.add(keyword);
                this.debugit("added the following keyword to result:  " + keyword);
                continue;
            }
            this.debugit("not adding keyword (" + keyword + ") to result");
        }
        return result;
    }

    @Override
    protected ArrayList<String> getUnlistedOptionalPackages() {
        int ii;
        String[] otherTechKeywords;
        ArrayList<String> unlistedOptPkgs = new ArrayList<String>();
        ArrayList<Object> unlistedKeywords = new ArrayList();
        this.debugit("Enterred getUnlistedOptionalPackages()");
        if (this.isFullEEProfile) {
            unlistedKeywords = this.cloneArrayList(KEYWORD_JAVAEE_FULL_OPTIONAL_TECHS);
            if (this.otherTechnologyKeywords == null) {
                this.debugit("No Optional Technology Keywords found in ts.jte's javaee.level property.");
            } else {
                this.debugit("Optional Technology Keywords found in ts.jte's javaee.level property: " + this.otherTechnologyKeywords);
                this.otherTechnologyKeywords = this.otherTechnologyKeywords.trim();
                otherTechKeywords = this.otherTechnologyKeywords.split(" ");
                for (ii = 0; ii < otherTechKeywords.length; ++ii) {
                    unlistedKeywords.remove(otherTechKeywords[ii]);
                }
            }
        } else {
            unlistedKeywords = this.cloneArrayList(KEYWORD_WEB_FULL_OPTIONAL_TECHS);
            if (this.otherTechnologyKeywords == null) {
                this.debugit("No Optional Technology Keywords found in ts.jte's javaee.level property.");
            } else {
                this.debugit("Optional Technology Keywords found in ts.jte's javaee.level property: " + this.otherTechnologyKeywords);
                this.otherTechnologyKeywords = this.otherTechnologyKeywords.trim();
                otherTechKeywords = this.otherTechnologyKeywords.split(" ");
                for (ii = 0; ii < otherTechKeywords.length; ++ii) {
                    unlistedKeywords.remove(otherTechKeywords[ii]);
                }
            }
        }
        block2: for (int ii2 = 0; ii2 < unlistedKeywords.size(); ++ii2) {
            this.debugit("getting packages for Optional Technology Keyword == " + unlistedKeywords.get(ii2));
            for (Containers cc : Containers.values()) {
                String[] pkgs;
                Map<String, String[]> containerMap = CONTAINER_PACKAGE_MAPS.get((Object)cc);
                if (!containerMap.containsKey(unlistedKeywords.get(ii2))) continue;
                this.debugit("Container: " + (Object)((Object)cc) + "  contains packages for Optional Technolgoy of: " + unlistedKeywords.get(ii2));
                for (String otPkg : pkgs = containerMap.get(unlistedKeywords.get(ii2))) {
                    unlistedOptPkgs.add(otPkg);
                }
                continue block2;
            }
        }
        this.debugit("getUnlistedOptionalPackages(): returning the following unlistedOptPkgs: " + unlistedOptPkgs.toString());
        return unlistedOptPkgs;
    }

    private ArrayList<String> cloneArrayList(ArrayList<String> listToBeCloned) {
        ArrayList<String> returnVal = new ArrayList<String>(listToBeCloned.size());
        for (String str : listToBeCloned) {
            returnVal.add(new String(str));
        }
        return returnVal;
    }

    @Override
    protected String[] getPackages(String vehicleName) {
        HashSet<String> packages = new HashSet<String>();
        Containers vehicle = Containers.valueOf(vehicleName);
        Set<String> keywords = null;
        this.debugit("vehicleName = " + vehicleName);
        this.setLevel();
        try {
            keywords = this.resolveAggregateKeywords();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.dumpKeywords(keywords);
        Map<String, String[]> vehicleMap = CONTAINER_PACKAGE_MAPS.get((Object)vehicle);
        this.dumpMap(vehicle, vehicleMap);
        for (String keyword : keywords) {
            if (!vehicleMap.containsKey(keyword)) continue;
            packages.addAll(Arrays.asList((Object[])vehicleMap.get(keyword)));
        }
        this.dumpPackages(vehicle, packages);
        return packages.toArray(new String[packages.size()]);
    }

    private void dumpKeywords(Set<String> words) {
        this.debugit("Level is set to \"" + this.level + "\"");
        this.debugit("\tKeywords:");
        for (String s : words) {
            this.debugit("\t\t" + s);
        }
        this.debugit("// dumpKeywords *****");
    }

    private void dumpMap(Containers vehicle, Map<String, String[]> packages) {
        this.debugit("Vehicle is set to \"" + (Object)((Object)vehicle) + "\"");
        for (String s : packages.keySet()) {
            if (packages != null) {
                String[] pkgs = packages.get(s);
                String outStr = s + " -> ";
                for (int ii = 0; ii < pkgs.length; ++ii) {
                    outStr = outStr + pkgs[ii] + " ";
                }
                this.debugit(outStr);
                continue;
            }
            this.debugit(s + " ->  no packages ");
        }
        this.debugit("// dumpMap *****");
    }

    private void dumpPackages(Containers vehicle, Set<String> packages) {
        this.debugit("Vehicle is set to \"" + (Object)((Object)vehicle) + "\"");
        if (packages != null) {
            String outStr = "";
            for (String item : packages) {
                outStr = outStr + item + " ";
            }
            this.debugit(outStr);
        } else {
            this.debugit("no packages found");
        }
        this.debugit("// dumpPackages *****");
    }

    public static void main(String[] args) {
        JavaEESigTest theTests = new JavaEESigTest();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    static {
        EnumMap tempMap = new EnumMap(Containers.class);
        HashMap EJB_MAP = new HashMap();
        HashMap SERVLET_MAP = new HashMap();
        HashMap JSP_MAP = new HashMap();
        HashMap<String, String[]> APPCLIENT_MAP = new HashMap<String, String[]>();
        HashMap<String, String[]> STANDALONE_MAP = new HashMap<String, String[]>();
        APPCLIENT_MAP.put("ejb", new String[]{"javax.ejb", "javax.ejb.spi", "javax.ejb.embeddable", "javax.interceptor"});
        APPCLIENT_MAP.put("interceptors", new String[]{"javax.interceptor"});
        APPCLIENT_MAP.put("caj", new String[]{"javax.annotation", "javax.annotation.security", "javax.annotation.sql"});
        APPCLIENT_MAP.put("jms", new String[]{"javax.jms"});
        APPCLIENT_MAP.put("javamail", new String[]{"javax.mail", "javax.mail.event", "javax.mail.internet", "javax.mail.search", "javax.mail.util"});
        APPCLIENT_MAP.put("javaeemgmt", new String[]{"javax.management.j2ee", "javax.management.j2ee.statistics"});
        APPCLIENT_MAP.put("persistence", new String[]{"javax.persistence", "javax.persistence.spi", "javax.persistence.criteria", "javax.persistence.metamodel"});
        APPCLIENT_MAP.put("jaxr", new String[]{"javax.xml.registry", "javax.xml.registry.infomodel"});
        APPCLIENT_MAP.put("jaxrpc", new String[]{"javax.xml.rpc", "javax.xml.rpc.encoding", "javax.xml.rpc.handler", "javax.xml.rpc.handler.soap", "javax.xml.rpc.holders", "javax.xml.rpc.server", "javax.xml.rpc.soap"});
        APPCLIENT_MAP.put("cdi", new String[]{"javax.decorator", "javax.enterprise.context", "javax.enterprise.context.control", "javax.enterprise.context.spi", "javax.enterprise.event", "javax.enterprise.inject", "javax.enterprise.inject.spi", "javax.enterprise.inject.literal", "javax.enterprise.inject.spi.configurator", "javax.enterprise.util"});
        APPCLIENT_MAP.put("beanval", new String[]{"javax.validation", "javax.validation.bootstrap", "javax.validation.constraints", "javax.validation.groups", "javax.validation.metadata", "javax.validation.constraintvalidation", "javax.validation.executable", "javax.validation.spi", "javax.validation.valueextraction"});
        APPCLIENT_MAP.put("di", new String[]{"javax.inject"});
        APPCLIENT_MAP.put("jsonp", new String[]{"javax.json", "javax.json.spi", "javax.json.stream"});
        APPCLIENT_MAP.put("jsonb", new String[]{"javax.json.bind", "javax.json.bind.adapter", "javax.json.bind.annotation", "javax.json.bind.config", "javax.json.bind.serializer", "javax.json.bind.spi"});
        EJB_MAP.putAll(APPCLIENT_MAP);
        EJB_MAP.put("connector", new String[]{"javax.resource", "javax.resource.cci", "javax.resource.spi", "javax.resource.spi.work", "javax.resource.spi.endpoint", "javax.resource.spi.security"});
        EJB_MAP.put("jacc", new String[]{"javax.security.jacc"});
        EJB_MAP.put("jaspic", new String[]{"javax.security.auth.message", "javax.security.auth.message.callback", "javax.security.auth.message.config", "javax.security.auth.message.module"});
        EJB_MAP.put("jta", new String[]{"javax.transaction"});
        EJB_MAP.put("batch", new String[]{"javax.batch.api", "javax.batch.api.chunk", "javax.batch.api.chunk.listener", "javax.batch.api.listener", "javax.batch.api.partition", "javax.batch.operations", "javax.batch.runtime", "javax.batch.runtime.context"});
        EJB_MAP.put("concurrency", new String[]{"javax.enterprise.concurrent"});
        EJB_MAP.put("securityapi", new String[]{"javax.security.enterprise", "javax.security.enterprise.authentication.mechanism.http", "javax.security.enterprise.credential", "javax.security.enterprise.identitystore"});
        SERVLET_MAP.putAll(EJB_MAP);
        SERVLET_MAP.put("el", new String[]{"javax.el"});
        SERVLET_MAP.put("servlet", new String[]{"javax.servlet", "javax.servlet.annotation", "javax.servlet.descriptor", "javax.servlet.http", "javax.servlet.jsp", "javax.servlet.jsp.el", "javax.servlet.jsp.jstl.core", "javax.servlet.jsp.jstl.fmt", "javax.servlet.jsp.jstl.sql", "javax.servlet.jsp.jstl.tlv", "javax.servlet.jsp.tagext"});
        SERVLET_MAP.put("jsf", new String[]{"javax.faces", "javax.faces.application", "javax.faces.annotation", "javax.faces.component", "javax.faces.bean", "javax.faces.flow", "javax.faces.flow.builder", "javax.faces.component.behavior", "javax.faces.component.html", "javax.faces.component.visit", "javax.faces.component.search", "javax.faces.context", "javax.faces.convert", "javax.faces.el", "javax.faces.event", "javax.faces.lifecycle", "javax.faces.model", "javax.faces.push", "javax.faces.render", "javax.faces.validator", "javax.faces.view", "javax.faces.view.facelets", "javax.faces.webapp"});
        SERVLET_MAP.put("jaxrs", new String[]{"javax.ws.rs", "javax.ws.rs.core", "javax.ws.rs.ext", "javax.ws.rs.client", "javax.ws.rs.container", "javax.ws.rs.sse"});
        SERVLET_MAP.put("websocket", new String[]{"javax.websocket", "javax.websocket.server"});
        JSP_MAP = SERVLET_MAP;
        STANDALONE_MAP.put("javaeedeploy", new String[]{"javax.enterprise.deploy.model", "javax.enterprise.deploy.model.exceptions", "javax.enterprise.deploy.shared", "javax.enterprise.deploy.shared.factories", "javax.enterprise.deploy.spi", "javax.enterprise.deploy.spi.exceptions", "javax.enterprise.deploy.spi.factories", "javax.enterprise.deploy.spi.status"});
        tempMap.put(Containers.ejb, Collections.unmodifiableMap(EJB_MAP));
        tempMap.put(Containers.servlet, Collections.unmodifiableMap(SERVLET_MAP));
        tempMap.put(Containers.jsp, Collections.unmodifiableMap(JSP_MAP));
        tempMap.put(Containers.appclient, Collections.unmodifiableMap(APPCLIENT_MAP));
        tempMap.put(Containers.standalone, Collections.unmodifiableMap(STANDALONE_MAP));
        CONTAINER_PACKAGE_MAPS = Collections.unmodifiableMap(tempMap);
    }

    static enum Containers {
        ejb,
        servlet,
        jsp,
        appclient,
        standalone;

    }
}

