/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jaxr.api.javax_xml_registry.JAXRException;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jaxr.common.JAXRCommonClient;
import com.sun.ts.tests.jaxr.common.JAXR_Util;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import javax.xml.registry.BulkResponse;
import javax.xml.registry.JAXRException;
import javax.xml.registry.RegistryException;
import javax.xml.registry.infomodel.Key;
import javax.xml.registry.infomodel.Organization;

public class JAXRClient
extends JAXRCommonClient {
    JAXR_Util util = null;

    public static void main(String[] args) {
        JAXRClient theTests = new JAXRClient();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    @Override
    public void setup(String[] args, Properties p) throws EETest.Fault {
        try {
            super.setup(args, p);
        }
        catch (Exception e) {
            throw new EETest.Fault("setup failed:", e);
        }
    }

    @Override
    public void cleanup() throws EETest.Fault {
        try {
            super.cleanup();
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Cleanup error: " + e.toString()));
            TestUtil.printStackTrace((Throwable)e);
        }
        finally {
            if (this.debug != null) {
                TestUtil.logTrace((String)this.debug.toString());
            }
        }
    }

    public void jaxrException_ConstructorTest1() throws EETest.Fault {
        String testName = "jaxrException_ConstructorTest1()";
        try {
            this.debug.add("Create and verify a JAXRException instance\n");
            JAXRException e = new JAXRException();
            if (!(e instanceof JAXRException)) {
                throw new EETest.Fault(testName + "failed to create JAXRException instance");
            }
            this.debug.add("JAXRException created successfully\n");
        }
        catch (Exception ue) {
            TestUtil.logErr((String)("Caught unexpected exception: " + ue.getMessage()));
            TestUtil.printStackTrace((Throwable)ue);
            throw new EETest.Fault(testName + "failed", ue);
        }
    }

    public void jaxrException_ConstructorTest2() throws EETest.Fault {
        String testName = "jaxrException_ConstructorTest2";
        String reason = "test reason";
        boolean pass = true;
        try {
            this.debug.add("Create and verify a JAXRException(reason)\n");
            JAXRException e = new JAXRException(reason);
            if (!(e instanceof JAXRException)) {
                pass = false;
                this.debug.add(testName + " failed to create JAXRException instance\n");
            } else {
                this.debug.add("JAXRException created successfully\n");
            }
            if (!e.getMessage().equals(reason)) {
                pass = false;
                this.debug.add(testName + " failed to return correct reason\n");
            } else {
                this.debug.add("JAXRException returned reason successfully\n");
            }
        }
        catch (Exception ue) {
            TestUtil.logErr((String)("Caught unexpected exception: " + ue.getMessage()));
            TestUtil.printStackTrace((Throwable)ue);
            throw new EETest.Fault(testName + "failed", ue);
        }
        if (!pass) {
            throw new EETest.Fault(testName + " failed");
        }
    }

    public void jaxrException_ConstructorTest3() throws EETest.Fault {
        String testName = "jaxrException_ConstructorTest3()";
        String reason = "test reason";
        String cause = "test cause";
        boolean pass = true;
        try {
            Throwable tCause = new Throwable(cause);
            this.debug.add("Create and verify a JAXRException(reason,cause)\n");
            JAXRException e = new JAXRException(reason, tCause);
            if (!(e instanceof JAXRException)) {
                pass = false;
                this.debug.add(testName + " failed to create  JAXRException instance\n");
            } else {
                this.debug.add("JAXRException created successfully\n");
            }
            if (!e.getMessage().equals(reason)) {
                pass = false;
                this.debug.add(testName + " failed to return correct reason\n");
            } else {
                this.debug.add("  JAXRException returned reason successfully\n");
            }
            Throwable t = e.getCause();
            this.debug.add("Cause is: " + t.getMessage() + "\n");
            if (!t.getMessage().equals(cause)) {
                pass = false;
                this.debug.add(testName + " failed to return valid Throwable\n");
            }
        }
        catch (Exception ue) {
            TestUtil.logErr((String)("Caught unexpected exception: " + ue.getMessage()));
            TestUtil.printStackTrace((Throwable)ue);
            throw new EETest.Fault(testName + " failed", ue);
        }
        if (!pass) {
            throw new EETest.Fault(testName + " failed");
        }
    }

    public void jaxrException_ConstructorTest4() throws EETest.Fault {
        String testName = "jaxrException_ConstructorTest4";
        String cause = "test cause";
        boolean pass = true;
        try {
            Throwable tCause = new Throwable(cause);
            this.debug.add("Create and verify a JAXRException(cause)\n");
            JAXRException e = new JAXRException(tCause);
            if (!(e instanceof JAXRException)) {
                pass = false;
                this.debug.add(testName + "failed to create JAXRException instance\n");
            } else {
                this.debug.add(" JAXRException created successfully\n");
            }
            Throwable t = e.getCause();
            this.debug.add("Cause is: " + t.getMessage() + "\n");
            if (!t.getMessage().equals(cause)) {
                pass = false;
                this.debug.add(testName + " failed to return valid Throwable\n");
            }
        }
        catch (Exception ue) {
            TestUtil.logErr((String)("Caught unexpected exception: " + ue.getMessage()));
            TestUtil.printStackTrace((Throwable)ue);
            throw new EETest.Fault(testName + "failed", ue);
        }
        if (!pass) {
            throw new EETest.Fault(testName + " failed");
        }
    }

    public void jaxrException_getCauseTest() throws EETest.Fault {
        String testName = "jaxrException_getCauseTest";
        boolean pass = true;
        try {
            JAXRException e = new JAXRException();
            if (!(e instanceof JAXRException)) {
                pass = false;
                this.debug.add(testName + "failed to create JAXRException instance\n");
            } else {
                this.debug.add(" JAXRException created successfully\n");
            }
            Throwable t = e.getCause();
            if (t != null) {
                this.debug.add("Error: cause should have been null \n");
                pass = false;
            } else {
                this.debug.add("getCause returned null as expected\n");
            }
        }
        catch (Exception ue) {
            TestUtil.logErr((String)("Caught unexpected exception: " + ue.getMessage()));
            TestUtil.printStackTrace((Throwable)ue);
            throw new EETest.Fault(testName + "failed", ue);
        }
        if (!pass) {
            throw new EETest.Fault(testName + " failed");
        }
    }

    public void jaxrException_getMessageTest() throws EETest.Fault {
        String testName = "jaxrException_getMessageTest";
        boolean pass = true;
        String warningMessage = " test getMessage returns JAXRException reason";
        try {
            JAXRException e = new JAXRException(warningMessage);
            if (!e.getMessage().equals(warningMessage)) {
                pass = false;
                this.debug.add("Error: JAXRException reason not returned with getMessage!\n");
            } else {
                this.debug.add("JAXRException reason returned successfully\n");
            }
        }
        catch (Exception ue) {
            TestUtil.logErr((String)("Caught unexpected exception: " + ue.getMessage()));
            TestUtil.printStackTrace((Throwable)ue);
            throw new EETest.Fault(testName + "failed", ue);
        }
        if (!pass) {
            throw new EETest.Fault(testName + " failed");
        }
    }

    public void jaxrException_getMessageThrowableTest() throws EETest.Fault {
        String testName = "jaxrException_getMessageThrowableTest";
        boolean pass = true;
        String cause = "detail message from embedded throwable";
        try {
            Throwable tCause = new Throwable(cause);
            JAXRException e = new JAXRException(tCause);
            this.debug.add("e.getMessage returns: " + e.getMessage() + "\n");
            if (!e.getMessage().endsWith(cause)) {
                pass = false;
                this.debug.add("Error: JAXRException cause not returned with getMessage!\n");
            } else {
                this.debug.add("JAXRException cause returned successfully\n");
            }
        }
        catch (Exception ue) {
            TestUtil.logErr((String)("Caught unexpected exception: " + ue.getMessage()));
            TestUtil.printStackTrace((Throwable)ue);
            throw new EETest.Fault(testName + "failed", ue);
        }
        if (!pass) {
            throw new EETest.Fault(testName + " failed");
        }
    }

    public void jaxrException_initCauseTest() throws EETest.Fault {
        String testName = "jaxrException_initCauseTest()";
        String reason = "test reason";
        String cause = "test cause";
        boolean pass = true;
        try {
            Throwable tCause = new Throwable(cause);
            this.debug.add("Create a JAXRException()\n");
            JAXRException e = new JAXRException();
            if (!(e instanceof JAXRException)) {
                pass = false;
                this.debug.add(testName + " failed to create  JAXRException instance\n");
            } else {
                this.debug.add("JAXRException created successfully\n");
            }
            this.debug.add("Call initCause method and initialize the cause\n");
            e.initCause(tCause);
            Throwable t = e.getCause();
            this.debug.add("Cause is: " + t.getMessage() + "\n");
            if (!t.getMessage().equals(cause)) {
                pass = false;
                this.debug.add(testName + " failed to return valid Throwable\n");
            }
        }
        catch (Exception ue) {
            TestUtil.logErr((String)("Caught unexpected exception: " + ue.getMessage()));
            TestUtil.printStackTrace((Throwable)ue);
            throw new EETest.Fault(testName + " failed", ue);
        }
        if (!pass) {
            throw new EETest.Fault(testName + " failed");
        }
    }

    public void jaxrException_getStatusTest() throws EETest.Fault {
        String testName = "jaxrException_getStatusTest()";
        boolean pass = false;
        ArrayList<Key> savedKeys = new ArrayList<Key>();
        try {
            ArrayList<Organization> orgs = new ArrayList<Organization>();
            Organization org = (Organization)this.blm.createObject("Organization");
            org.setName(this.blm.createInternationalString("org_for_getStatus_test"));
            org.setDescription(this.blm.createInternationalString("Description: Testorg"));
            orgs.add(org);
            BulkResponse br = this.blm.saveOrganizations(orgs);
            Collection ex = br.getExceptions();
            if (ex != null && ex.size() > 0) {
                for (RegistryException re : ex) {
                    this.debug.add("unexpected registry exception, its status is " + br.getStatus() + "\n");
                }
            }
            Collection o = br.getCollection();
            ArrayList<Key> keys = new ArrayList<Key>();
            if (o != null && o.size() > 0) {
                for (Key theKey : o) {
                    keys.add(theKey);
                    savedKeys.add(theKey);
                }
            }
            Key myKey = this.blm.createKey("myKey");
            keys.add(myKey);
            br = this.blm.deleteOrganizations(keys);
            ex = br.getExceptions();
            if (ex != null) {
                this.debug.add("expected registry exception, its status is " + br.getStatus() + "\n");
                if (ex.size() > 0) {
                    for (RegistryException re : ex) {
                        if (re.getStatus() != 0) {
                            pass = true;
                            continue;
                        }
                        this.debug.add("Test failed with incorrect status = " + re.getStatus());
                    }
                }
            }
        }
        catch (JAXRException je) {
            pass = true;
            TestUtil.logMsg((String)("Caught Allowed JAXRException: " + je.getMessage()));
            TestUtil.printStackTrace((Throwable)je);
        }
        catch (Exception ue) {
            TestUtil.logErr((String)("Caught unexpected exception: " + ue.getMessage()));
            TestUtil.printStackTrace((Throwable)ue);
            throw new EETest.Fault(testName + " failed", ue);
        }
        finally {
            try {
                this.debug.add(" Cleanup: Remove test organization\n");
                this.blm.deleteOrganizations(savedKeys);
            }
            catch (JAXRException je) {
                TestUtil.printStackTrace((Throwable)je);
                this.debug.add("Error: not able to delete registry object\n");
            }
        }
        if (!pass) {
            throw new EETest.Fault(testName + " failed");
        }
    }
}

