/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb30.bb.mdb.callback.listener.annotated;

import com.sun.ts.tests.ejb30.bb.mdb.callback.listener.annotated.CallbackBean;
import com.sun.ts.tests.ejb30.common.helper.TLogger;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.interceptor.AroundInvoke;
import javax.interceptor.InvocationContext;

public class MDBCallbackListener {
    @PostConstruct
    private void myCreate(InvocationContext inv) throws RuntimeException {
        CallbackBean bean = (CallbackBean)inv.getTarget();
        bean.setPostConstructCalled(true);
        TLogger.log("PostConstruct method in " + this + " called for bean " + bean);
        if (bean.getEJBContext() != null) {
            bean.setInjectionDone(true);
        }
        try {
            inv.proceed();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @PreDestroy
    private void myRemove(InvocationContext inv) throws RuntimeException {
        Object bean = inv.getTarget();
        if (bean instanceof CallbackBean) {
            CallbackBean b = (CallbackBean)bean;
            b.setPreDestroyCalled(true);
            TLogger.log("PreDestroy method in " + this + " called for bean " + bean);
        }
        try {
            inv.proceed();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @AroundInvoke
    private Object intercept(InvocationContext inv) throws Exception {
        return inv.proceed();
    }
}

