/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jaxr.api.javax_xml_registry_infomodel.SpecificationLink;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jaxr.common.JAXRCommonClient;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import java.util.Properties;
import javax.xml.registry.infomodel.Concept;
import javax.xml.registry.infomodel.InternationalString;
import javax.xml.registry.infomodel.RegistryObject;
import javax.xml.registry.infomodel.ServiceBinding;
import javax.xml.registry.infomodel.SpecificationLink;

public class JAXRClient
extends JAXRCommonClient {
    Locale tsLocale = new Locale("en", "US");

    public static void main(String[] args) {
        JAXRClient theTests = new JAXRClient();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    @Override
    public void setup(String[] args, Properties p) throws EETest.Fault {
        try {
            super.setup(args, p);
            this.debug.clear();
        }
        catch (Exception e) {
            throw new EETest.Fault("setup failed:", e);
        }
    }

    @Override
    public void cleanup() throws EETest.Fault {
        try {
            this.logMsg("in cleanup");
            if (this.conn != null) {
                this.logTrace("Cleanup is closing the connection");
                this.conn.close();
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Cleanup error: " + e.toString()));
            TestUtil.printStackTrace((Throwable)e);
        }
        finally {
            if (this.debug != null) {
                TestUtil.logTrace((String)this.debug.toString());
            }
        }
    }

    public void specificationLink_setGetUsageDescriptionTest() throws EETest.Fault {
        String testName = "specificationLink_setGetUsageDescriptionTest";
        boolean pass = true;
        String usage = "Testing get/set UsageDescription";
        try {
            SpecificationLink sl = this.blm.createSpecificationLink();
            InternationalString iusage = this.blm.createInternationalString(usage);
            sl.setUsageDescription(iusage);
            if (!sl.getUsageDescription().getValue().equals(usage)) {
                throw new EETest.Fault(testName + "Error: did not get expected usage description");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault(testName + "failed ");
        }
    }

    public void specificationLink_setGetUsageParametersTest() throws EETest.Fault {
        String testName = "specificationLink_setGetUsageParametersTest";
        boolean pass = false;
        String usage = "Testing get/set UsageParameters";
        try {
            ArrayList<String> params = new ArrayList<String>();
            params.add(usage);
            SpecificationLink sl = this.blm.createSpecificationLink();
            sl.setUsageParameters(params);
            Collection list = sl.getUsageParameters();
            if (list.size() != 1) {
                throw new EETest.Fault(testName + "Error: invalid parameter count: " + list.size());
            }
            TestUtil.logMsg((String)(" Usage parameter is set to: " + usage));
            if (list.contains(usage)) {
                pass = true;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault(testName + "failed ");
        }
    }

    public void specificationLink_setGetSpecificationObjectTest() throws EETest.Fault {
        String testName = "specificationLink_setGetSpecificationObjectTest";
        boolean pass = true;
        String conceptName = "concept for test specificationLink_setGetSpecificationObjectTest";
        try {
            SpecificationLink sl = this.blm.createSpecificationLink();
            Concept concept = (Concept)this.blm.createObject("Concept");
            concept.setName(this.blm.createInternationalString(this.tsLocale, conceptName));
            sl.setSpecificationObject((RegistryObject)concept);
            Concept retConcept = (Concept)sl.getSpecificationObject();
            if (retConcept == null) {
                throw new EETest.Fault(testName + "Error: null returned from getSpecificationObject");
            }
            String retName = retConcept.getName().getValue(this.tsLocale);
            if (!retName.equals(conceptName)) {
                throw new EETest.Fault(testName + "Error: concept name does not match");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault(testName + "failed ");
        }
    }

    public void specificationLink_getServiceBinding() throws EETest.Fault {
        String testName = "specificationLink_getServiceBinding";
        String uri = "binding uri";
        Object lnk = null;
        boolean pass = true;
        try {
            SpecificationLink sl = this.blm.createSpecificationLink();
            ServiceBinding sb = this.blm.createServiceBinding();
            sb.setValidateURI(false);
            sb.setAccessURI(uri);
            sb.addSpecificationLink(sl);
            ServiceBinding retSb = sl.getServiceBinding();
            if (!retSb.getAccessURI().equals(uri)) {
                throw new EETest.Fault(testName + "Error: Did not get expected name for servicebinding.  ");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault(testName + "failed ");
        }
    }
}

